/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.jdbc.authentication;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.sql.SQLException;
import java.util.Properties;
import org.apache.derby.authentication.UserAuthenticator;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.iapi.services.property.PropertyUtil;
import org.apache.derby.iapi.sql.dictionary.PasswordHasher;
import org.apache.derby.iapi.util.StringUtil;
import org.apache.derby.impl.jdbc.Util;
import org.apache.derby.impl.jdbc.authentication.AuthenticationServiceBase;
import org.apache.derby.shared.common.error.StandardException;

public final class BasicAuthenticationServiceImpl
extends AuthenticationServiceBase
implements UserAuthenticator {
    @Override
    public boolean canSupport(Properties properties) {
        if (!this.requireAuthentication(properties)) {
            return false;
        }
        String authenticationProvider = PropertyUtil.getPropertyFromSet(properties, "derby.authentication.provider");
        return authenticationProvider == null || authenticationProvider.length() == 0 || StringUtil.SQLEqualsIgnoreCase(authenticationProvider, "BUILTIN");
    }

    @Override
    public void boot(boolean create, Properties properties) throws StandardException {
        super.boot(create, properties);
        try {
            MessageDigest digestAlgorithm = MessageDigest.getInstance("SHA-1");
            digestAlgorithm.reset();
        }
        catch (NoSuchAlgorithmException nsae) {
            throw Monitor.exceptionStartingModule(nsae);
        }
        this.setAuthenticationService(this);
    }

    @Override
    public boolean authenticateUser(String userName, String userPassword, String databaseName, Properties info) throws SQLException {
        boolean passwordsMatch;
        String userNameProperty;
        String clientSecurityMechanism = null;
        int secMec = 0;
        if (userName == null) {
            return false;
        }
        String definedUserPassword = null;
        String passedUserPassword = null;
        clientSecurityMechanism = info.getProperty("drdaSecMec");
        if (clientSecurityMechanism != null) {
            secMec = Integer.parseInt(clientSecurityMechanism);
        }
        if ((definedUserPassword = this.getDatabaseProperty(userNameProperty = "derby.user.".concat(userName))) != null) {
            if (secMec != 8) {
                try {
                    passedUserPassword = this.hashPasswordUsingStoredAlgorithm(userName, userPassword, definedUserPassword);
                }
                catch (StandardException se) {
                    throw Util.generateCsSQLException(se);
                }
            } else {
                definedUserPassword = this.substitutePassword(userName, definedUserPassword, info, true);
                passedUserPassword = userPassword;
            }
        } else {
            try {
                Properties props = this.getDatabaseProperties();
                if (props != null) {
                    this.hashUsingDefaultAlgorithm(userName, userPassword, props);
                }
            }
            catch (StandardException se) {
                throw Util.generateCsSQLException(se);
            }
            definedUserPassword = this.getSystemProperty(userNameProperty);
            passedUserPassword = userPassword;
            if (definedUserPassword != null && secMec == 8) {
                definedUserPassword = this.substitutePassword(userName, definedUserPassword, info, false);
            }
        }
        boolean bl = passwordsMatch = definedUserPassword != null && definedUserPassword.equals(passedUserPassword);
        if (!passwordsMatch && secMec == 8) {
            throw Util.generateCsSQLException("08004.C.12", new Object[0]);
        }
        return passwordsMatch;
    }

    private String hashPasswordUsingStoredAlgorithm(String user, String password, String storedPassword) throws StandardException {
        if (storedPassword.startsWith("3b60")) {
            return this.hashPasswordSHA1Scheme(password);
        }
        PasswordHasher hasher = new PasswordHasher(storedPassword);
        return hasher.hashAndEncode(user, password);
    }
}

