/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.spatial.common;

import org.apache.lucene.geo.Component2D;
import org.apache.lucene.geo.LatLonGeometry;
import org.apache.lucene.index.PointValues;
import org.apache.lucene.spatial3d.geom.Bounds;
import org.apache.lucene.spatial3d.geom.GeoArea;
import org.apache.lucene.spatial3d.geom.GeoAreaFactory;
import org.apache.lucene.spatial3d.geom.GeoPolygon;
import org.apache.lucene.spatial3d.geom.GeoShape;
import org.apache.lucene.spatial3d.geom.LatLonBounds;
import org.apache.lucene.spatial3d.geom.PlanetModel;
import org.elasticsearch.h3.H3;
import org.elasticsearch.xpack.spatial.common.H3SphericalUtil;

class H3SphericalGeometry
extends LatLonGeometry {
    private final long h3;

    H3SphericalGeometry(long h3) {
        this.h3 = h3;
    }

    @Override
    protected Component2D toComponent2D() {
        return new H3Polygon2D(this.h3);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof H3SphericalGeometry) {
            H3SphericalGeometry geom = (H3SphericalGeometry)o;
            return this.h3 == geom.h3;
        }
        return false;
    }

    public int hashCode() {
        return Long.hashCode(this.h3);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("H3 : ");
        sb.append("\"");
        sb.append(this.h3);
        sb.append("\"");
        return sb.toString();
    }

    private static class H3Polygon2D
    implements Component2D {
        private static final double BBOX_EDGE_DELTA = 1.0E-4;
        private final long h3;
        private final int res;
        private final GeoPolygon hexagon;
        private final double minX;
        private final double maxX;
        private final double minY;
        private final double maxY;

        private H3Polygon2D(long h3) {
            double maxX;
            double minX;
            double maxY;
            this.h3 = h3;
            this.res = H3.getResolution((long)h3);
            this.hexagon = H3SphericalUtil.toGeoPolygon(h3);
            LatLonBounds bounds = new LatLonBounds();
            this.hexagon.getBounds((Bounds)bounds);
            double minY = bounds.checkNoBottomLatitudeBound() ? -90.0 : Math.toDegrees(bounds.getMinLatitude());
            double d = maxY = bounds.checkNoTopLatitudeBound() ? 90.0 : Math.toDegrees(bounds.getMaxLatitude());
            if (bounds.checkNoLongitudeBound() || bounds.getLeftLongitude() > bounds.getRightLongitude()) {
                minX = -180.0;
                maxX = 180.0;
            } else {
                minX = Math.toDegrees(bounds.getLeftLongitude());
                maxX = Math.toDegrees(bounds.getRightLongitude());
            }
            this.minX = Math.max(-180.0, minX - 1.0E-4);
            this.maxX = Math.min(180.0, maxX + 1.0E-4);
            this.minY = Math.max(-90.0, minY - 1.0E-4);
            this.maxY = Math.min(90.0, maxY + 1.0E-4);
        }

        @Override
        public double getMinX() {
            return this.minX;
        }

        @Override
        public double getMaxX() {
            return this.maxX;
        }

        @Override
        public double getMinY() {
            return this.minY;
        }

        @Override
        public double getMaxY() {
            return this.maxY;
        }

        @Override
        public boolean contains(double x, double y) {
            return this.h3 == H3.geoToH3((double)y, (double)x, (int)this.res);
        }

        @Override
        public PointValues.Relation relate(double minX, double maxX, double minY, double maxY) {
            if (minX > this.maxX || maxX < this.minX || maxY < this.minY || minY > this.maxY) {
                return PointValues.Relation.CELL_OUTSIDE_QUERY;
            }
            GeoArea box = GeoAreaFactory.makeGeoArea((PlanetModel)PlanetModel.SPHERE, (double)Math.toRadians(Math.min(90.0, maxY + 1.0E-4)), (double)Math.toRadians(Math.max(-90.0, minY - 1.0E-4)), (double)Math.toRadians(Math.max(-180.0, minX - 1.0E-4)), (double)Math.toRadians(Math.min(180.0, maxX + 1.0E-4)));
            return switch (box.getRelationship((GeoShape)this.hexagon)) {
                case 0 -> PointValues.Relation.CELL_INSIDE_QUERY;
                case 3 -> PointValues.Relation.CELL_OUTSIDE_QUERY;
                default -> PointValues.Relation.CELL_CROSSES_QUERY;
            };
        }

        @Override
        public boolean intersectsLine(double minX, double maxX, double minY, double maxY, double aX, double aY, double bX, double bY) {
            throw new UnsupportedOperationException("intersectsLine not implemented in H3Polygon2D");
        }

        @Override
        public boolean intersectsTriangle(double minX, double maxX, double minY, double maxY, double aX, double aY, double bX, double bY, double cX, double cY) {
            throw new UnsupportedOperationException("intersectsTriangle not implemented in H3Polygon2D");
        }

        @Override
        public boolean containsLine(double minX, double maxX, double minY, double maxY, double aX, double aY, double bX, double bY) {
            throw new UnsupportedOperationException("containsLine not implemented in H3Polygon2D");
        }

        @Override
        public boolean containsTriangle(double minX, double maxX, double minY, double maxY, double aX, double aY, double bX, double bY, double cX, double cY) {
            throw new IllegalArgumentException();
        }

        @Override
        public Component2D.WithinRelation withinPoint(double x, double y) {
            return this.contains(x, y) ? Component2D.WithinRelation.NOTWITHIN : Component2D.WithinRelation.DISJOINT;
        }

        @Override
        public Component2D.WithinRelation withinLine(double minX, double maxX, double minY, double maxY, double aX, double aY, boolean ab, double bX, double bY) {
            throw new UnsupportedOperationException("withinLine not implemented in H3Polygon2D");
        }

        @Override
        public Component2D.WithinRelation withinTriangle(double minX, double maxX, double minY, double maxY, double aX, double aY, boolean ab, double bX, double bY, boolean bc, double cX, double cY, boolean ca) {
            throw new UnsupportedOperationException("withinTriangle not implemented in H3Polygon2D");
        }
    }
}

