/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.action.settings;

import java.io.IOException;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.master.MasterNodeReadRequest;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;

public class GetSecuritySettingsAction {
    public static final ActionType<Response> INSTANCE = new ActionType("cluster:admin/xpack/security/settings/get");

    private GetSecuritySettingsAction() {
    }

    public static class Response
    extends ActionResponse
    implements ToXContentObject {
        private final Settings mainIndexSettings;
        private final Settings tokensIndexSettings;
        private final Settings profilesIndexSettings;

        public Response(Settings mainIndexSettings, Settings tokensIndexSettings, Settings profilesIndexSettings) {
            this.mainIndexSettings = mainIndexSettings;
            this.tokensIndexSettings = tokensIndexSettings;
            this.profilesIndexSettings = profilesIndexSettings;
        }

        public Response(StreamInput in) throws IOException {
            this.mainIndexSettings = Settings.readSettingsFromStream(in);
            this.tokensIndexSettings = Settings.readSettingsFromStream(in);
            this.profilesIndexSettings = Settings.readSettingsFromStream(in);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            this.mainIndexSettings.writeTo(out);
            this.tokensIndexSettings.writeTo(out);
            this.profilesIndexSettings.writeTo(out);
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.startObject("security");
            this.mainIndexSettings.toXContent(builder, params);
            builder.endObject();
            builder.startObject("security-tokens");
            this.tokensIndexSettings.toXContent(builder, params);
            builder.endObject();
            builder.startObject("security-profile");
            this.profilesIndexSettings.toXContent(builder, params);
            builder.endObject();
            builder.endObject();
            return builder;
        }
    }

    public static class Request
    extends MasterNodeReadRequest<Request> {
        public Request(TimeValue masterNodeTimeout) {
            super(masterNodeTimeout);
        }

        public static Request readFrom(StreamInput in) throws IOException {
            return new Request(in);
        }

        private Request(StreamInput in) throws IOException {
            super(in);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            if (out.getTransportVersion().onOrAfter(TransportVersions.V_8_15_0)) {
                super.writeTo(out);
            }
        }

        @Override
        public ActionRequestValidationException validate() {
            return null;
        }
    }
}

