/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.inference.results;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.inference.WeightedToken;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.ml.inference.results.NlpInferenceResults;

public class TextExpansionResults
extends NlpInferenceResults {
    public static final String NAME = "text_expansion_result";
    private final String resultsField;
    private final List<WeightedToken> weightedTokens;

    public TextExpansionResults(String resultField, List<WeightedToken> weightedTokens, boolean isTruncated) {
        super(isTruncated);
        this.resultsField = resultField;
        this.weightedTokens = weightedTokens;
    }

    public TextExpansionResults(StreamInput in) throws IOException {
        super(in);
        this.resultsField = in.readString();
        this.weightedTokens = in.readCollectionAsList(WeightedToken::new);
    }

    public List<WeightedToken> getWeightedTokens() {
        return this.weightedTokens;
    }

    @Override
    public String getWriteableName() {
        return NAME;
    }

    @Override
    public String getResultsField() {
        return this.resultsField;
    }

    @Override
    public Object predictedValue() {
        throw new UnsupportedOperationException("[text_expansion_result] does not support a single predicted value");
    }

    @Override
    void doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(this.resultsField);
        for (WeightedToken weightedToken : this.weightedTokens) {
            weightedToken.toXContent(builder, params);
        }
        builder.endObject();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TextExpansionResults that = (TextExpansionResults)o;
        return Objects.equals(this.resultsField, that.resultsField) && Objects.equals(this.weightedTokens, that.weightedTokens);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.resultsField, this.weightedTokens);
    }

    @Override
    void doWriteTo(StreamOutput out) throws IOException {
        out.writeString(this.resultsField);
        out.writeCollection(this.weightedTokens);
    }

    @Override
    void addMapFields(Map<String, Object> map) {
        map.put(this.resultsField, this.weightedTokens.stream().collect(Collectors.toMap(WeightedToken::token, WeightedToken::weight)));
    }

    @Override
    public Map<String, Object> asMap(String outputField) {
        Map<String, Object> map = super.asMap(outputField);
        map.put(outputField, this.weightedTokens.stream().collect(Collectors.toMap(WeightedToken::token, WeightedToken::weight)));
        return map;
    }
}

