/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.action;

import java.io.IOException;
import java.util.Date;
import java.util.Objects;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.LegacyActionRequest;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.core.ml.job.config.Job;

public class ValidateJobConfigAction
extends ActionType<AcknowledgedResponse> {
    public static final ValidateJobConfigAction INSTANCE = new ValidateJobConfigAction();
    public static final String NAME = "cluster:admin/xpack/ml/job/validate";

    protected ValidateJobConfigAction() {
        super(NAME);
    }

    public static class Request
    extends LegacyActionRequest {
        private final Job job;

        public static Request parseRequest(XContentParser parser) {
            Job.Builder jobBuilder;
            jobBuilder.setId((jobBuilder = Job.REST_REQUEST_PARSER.apply(parser, null)).getId() != null ? jobBuilder.getId() : "ok");
            jobBuilder.validateDetectorsAreUnique();
            return new Request(jobBuilder.build(new Date()));
        }

        public Request() {
            this.job = null;
        }

        public Request(Job job) {
            this.job = job;
        }

        public Request(StreamInput in) throws IOException {
            super(in);
            this.job = new Job(in);
        }

        public Job getJob() {
            return this.job;
        }

        @Override
        public ActionRequestValidationException validate() {
            return null;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            this.job.writeTo(out);
        }

        public int hashCode() {
            return Objects.hash(this.job);
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Request other = (Request)obj;
            return Objects.equals(this.job, other.job);
        }
    }
}

