/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.vectors;

import java.io.IOException;
import java.util.Objects;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.FilterWeight;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryVisitor;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.ScorerSupplier;
import org.apache.lucene.search.Weight;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.lucene.search.function.MinScoreScorer;
import org.elasticsearch.search.profile.query.QueryProfiler;
import org.elasticsearch.search.vectors.QueryProfilerProvider;

public class VectorSimilarityQuery
extends Query
implements QueryProfilerProvider {
    private final float similarity;
    private final float docScore;
    private final Query innerKnnQuery;

    public VectorSimilarityQuery(Query innerKnnQuery, float similarity, float docScore) {
        this.similarity = similarity;
        this.docScore = docScore;
        this.innerKnnQuery = innerKnnQuery;
    }

    Query getInnerKnnQuery() {
        return this.innerKnnQuery;
    }

    float getSimilarity() {
        return this.similarity;
    }

    @Override
    public Query rewrite(IndexSearcher searcher) throws IOException {
        Query rewrittenInnerQuery = this.innerKnnQuery.rewrite(searcher);
        if (rewrittenInnerQuery instanceof MatchNoDocsQuery) {
            return rewrittenInnerQuery;
        }
        if (rewrittenInnerQuery == this.innerKnnQuery) {
            return this;
        }
        return new VectorSimilarityQuery(rewrittenInnerQuery, this.similarity, this.docScore);
    }

    @Override
    public Weight createWeight(IndexSearcher searcher, ScoreMode scoreMode, float boost) throws IOException {
        Weight innerWeight = scoreMode.isExhaustive() ? this.innerKnnQuery.createWeight(searcher, ScoreMode.COMPLETE, 1.0f) : this.innerKnnQuery.createWeight(searcher, ScoreMode.TOP_SCORES, 1.0f);
        return new MinScoreWeight(innerWeight, this.docScore, this.similarity, this, boost);
    }

    @Override
    public void profile(QueryProfiler queryProfiler) {
        Query query = this.innerKnnQuery;
        if (query instanceof QueryProfilerProvider) {
            QueryProfilerProvider queryProfilerProvider = (QueryProfilerProvider)((Object)query);
            queryProfilerProvider.profile(queryProfiler);
        }
    }

    @Override
    public String toString(String field) {
        return "VectorSimilarityQuery[similarity=" + this.similarity + ", docScore=" + this.docScore + ", innerKnnQuery=" + this.innerKnnQuery.toString(field) + "]";
    }

    @Override
    public void visit(QueryVisitor visitor) {
        visitor.visitLeaf(this);
    }

    @Override
    public boolean equals(Object obj) {
        if (!this.sameClassAs(obj)) {
            return false;
        }
        VectorSimilarityQuery other = (VectorSimilarityQuery)obj;
        return Objects.equals(this.innerKnnQuery, other.innerKnnQuery) && this.docScore == other.docScore && this.similarity == other.similarity;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.innerKnnQuery, Float.valueOf(this.docScore), Float.valueOf(this.similarity));
    }

    private static class MinScoreWeight
    extends FilterWeight {
        private final float similarity;
        private final float docScore;
        private final float boost;

        private MinScoreWeight(Weight innerWeight, float docScore, float similarity, Query parent, float boost) {
            super(parent, innerWeight);
            this.docScore = docScore;
            this.similarity = similarity;
            this.boost = boost;
        }

        @Override
        public Explanation explain(LeafReaderContext context, int doc) throws IOException {
            Explanation explanation = this.in.explain(context, doc);
            if (explanation.isMatch()) {
                float score = explanation.getValue().floatValue();
                if (score >= this.docScore) {
                    return Explanation.match((Number)Float.valueOf(explanation.getValue().floatValue() * this.boost), "vector similarity within limit", explanation);
                }
                return Explanation.noMatch(Strings.format("vector found, but score [%f] is less than matching minimum score [%f] from similarity [%f]", Float.valueOf(explanation.getValue().floatValue()), Float.valueOf(this.docScore), Float.valueOf(this.similarity)), explanation);
            }
            return explanation;
        }

        @Override
        public ScorerSupplier scorerSupplier(LeafReaderContext context) throws IOException {
            final ScorerSupplier inScorerSupplier = this.in.scorerSupplier(context);
            if (inScorerSupplier == null) {
                return null;
            }
            return new ScorerSupplier(){

                @Override
                public Scorer get(long leadCost) throws IOException {
                    return new MinScoreScorer(inScorerSupplier.get(leadCost), docScore, boost);
                }

                @Override
                public long cost() {
                    return inScorerSupplier.cost();
                }
            };
        }
    }
}

