/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.rank.context;

import java.util.Arrays;
import java.util.Comparator;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.search.rank.feature.RankFeatureDoc;

public abstract class RankFeaturePhaseRankCoordinatorContext {
    protected final int size;
    protected final int from;
    protected final int rankWindowSize;
    protected final boolean failuresAllowed;

    public RankFeaturePhaseRankCoordinatorContext(int size, int from, int rankWindowSize, boolean failuresAllowed) {
        this.size = size < 0 ? 10 : size;
        this.from = from < 0 ? 0 : from;
        this.rankWindowSize = rankWindowSize;
        this.failuresAllowed = failuresAllowed;
    }

    public boolean failuresAllowed() {
        return this.failuresAllowed;
    }

    protected abstract void computeScores(RankFeatureDoc[] var1, ActionListener<float[]> var2);

    protected RankFeatureDoc[] preprocess(RankFeatureDoc[] originalDocs, boolean rerankedScores) {
        Arrays.sort(originalDocs, Comparator.comparing(doc -> Float.valueOf(doc.score)).reversed());
        return originalDocs;
    }

    public void computeRankScoresForGlobalResults(RankFeatureDoc[] featureDocs, ActionListener<RankFeatureDoc[]> rankListener) {
        this.computeScores(featureDocs, rankListener.delegateFailureAndWrap((listener, scores) -> {
            for (int i = 0; i < featureDocs.length; ++i) {
                featureDocs[i].score = scores[i];
            }
            listener.onResponse(featureDocs);
        }));
    }

    public RankFeatureDoc[] rankAndPaginate(RankFeatureDoc[] rankFeatureDocs, boolean rerankedScores) {
        RankFeatureDoc[] sortedDocs = this.preprocess(rankFeatureDocs, rerankedScores);
        RankFeatureDoc[] topResults = new RankFeatureDoc[Math.max(0, Math.min(this.size, sortedDocs.length - this.from))];
        for (int rank = 0; rank < topResults.length; ++rank) {
            topResults[rank] = sortedDocs[this.from + rank];
            topResults[rank].rank = this.from + rank + 1;
        }
        return topResults;
    }
}

