/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.internal;

import java.io.IOException;
import java.util.Objects;
import org.apache.lucene.codecs.StoredFieldsReader;
import org.apache.lucene.index.ByteVectorValues;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.FilterDirectoryReader;
import org.apache.lucene.index.FilterLeafReader;
import org.apache.lucene.index.FloatVectorValues;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.KnnVectorValues;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.PointValues;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.KnnCollector;
import org.apache.lucene.search.VectorScorer;
import org.apache.lucene.search.suggest.document.CompletionTerms;
import org.apache.lucene.util.BitSet;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.automaton.CompiledAutomaton;
import org.elasticsearch.common.lucene.index.SequentialStoredFieldsLeafReader;

class ExitableDirectoryReader
extends FilterDirectoryReader {
    ExitableDirectoryReader(DirectoryReader in, final QueryCancellation queryCancellation) throws IOException {
        super(in, new FilterDirectoryReader.SubReaderWrapper(){

            @Override
            public LeafReader wrap(LeafReader reader) {
                return new ExitableLeafReader(reader, queryCancellation);
            }
        });
    }

    @Override
    protected DirectoryReader doWrapDirectoryReader(DirectoryReader in) {
        throw new UnsupportedOperationException("doWrapDirectoryReader() should never be invoked");
    }

    @Override
    public IndexReader.CacheHelper getReaderCacheHelper() {
        return this.in.getReaderCacheHelper();
    }

    private static KnnVectorValues.DocIndexIterator createExitableIterator(final KnnVectorValues.DocIndexIterator delegate, final QueryCancellation queryCancellation) {
        return new KnnVectorValues.DocIndexIterator(){
            private int calls;

            @Override
            public int index() {
                return delegate.index();
            }

            @Override
            public int docID() {
                return delegate.docID();
            }

            @Override
            public long cost() {
                return delegate.cost();
            }

            @Override
            public int nextDoc() throws IOException {
                int nextDoc = delegate.nextDoc();
                this.checkAndThrowWithSampling();
                return nextDoc;
            }

            @Override
            public int advance(int target) throws IOException {
                int advance = delegate.advance(target);
                this.checkAndThrowWithSampling();
                return advance;
            }

            private void checkAndThrowWithSampling() {
                if ((this.calls++ & 0x1FFF) == 0) {
                    queryCancellation.checkCancelled();
                }
            }
        };
    }

    static interface QueryCancellation {
        public boolean isEnabled();

        public void checkCancelled();
    }

    private static abstract class FilterFloatVectorValues
    extends FloatVectorValues {
        protected final FloatVectorValues in;

        protected FilterFloatVectorValues(FloatVectorValues in) {
            Objects.requireNonNull(in);
            this.in = in;
        }

        @Override
        public KnnVectorValues.DocIndexIterator iterator() {
            return this.in.iterator();
        }

        @Override
        public float[] vectorValue(int ord) throws IOException {
            return this.in.vectorValue(ord);
        }

        @Override
        public FloatVectorValues copy() throws IOException {
            return this.in.copy();
        }

        @Override
        public int dimension() {
            return this.in.dimension();
        }

        @Override
        public int size() {
            return this.in.size();
        }
    }

    private static class ExitableDocSetIterator
    extends DocIdSetIterator {
        private int calls;
        private final DocIdSetIterator in;
        private final QueryCancellation queryCancellation;

        private ExitableDocSetIterator(DocIdSetIterator in, QueryCancellation queryCancellation) {
            this.in = in;
            this.queryCancellation = queryCancellation;
        }

        @Override
        public int docID() {
            return this.in.docID();
        }

        @Override
        public int advance(int target) throws IOException {
            int advance = this.in.advance(target);
            this.checkAndThrowWithSampling();
            return advance;
        }

        @Override
        public int nextDoc() throws IOException {
            int nextDoc = this.in.nextDoc();
            this.checkAndThrowWithSampling();
            return nextDoc;
        }

        @Override
        public long cost() {
            return this.in.cost();
        }

        private void checkAndThrowWithSampling() {
            if ((this.calls++ & 0x1FFF) == 0) {
                this.queryCancellation.checkCancelled();
            }
        }
    }

    private static class ExitableFloatVectorValues
    extends FilterFloatVectorValues {
        private final QueryCancellation queryCancellation;

        ExitableFloatVectorValues(FloatVectorValues vectorValues, QueryCancellation queryCancellation) {
            super(vectorValues);
            this.queryCancellation = queryCancellation;
            this.queryCancellation.checkCancelled();
        }

        @Override
        public float[] vectorValue(int ord) throws IOException {
            return this.in.vectorValue(ord);
        }

        @Override
        public int ordToDoc(int ord) {
            return this.in.ordToDoc(ord);
        }

        @Override
        public VectorScorer scorer(float[] target) throws IOException {
            final VectorScorer scorer = this.in.scorer(target);
            if (scorer == null) {
                return null;
            }
            return new VectorScorer(){
                private final DocIdSetIterator iterator;
                {
                    this.iterator = new ExitableDocSetIterator(scorer.iterator(), queryCancellation);
                }

                @Override
                public float score() throws IOException {
                    return scorer.score();
                }

                @Override
                public DocIdSetIterator iterator() {
                    return this.iterator;
                }
            };
        }

        @Override
        public KnnVectorValues.DocIndexIterator iterator() {
            return ExitableDirectoryReader.createExitableIterator(this.in.iterator(), this.queryCancellation);
        }

        @Override
        public FloatVectorValues copy() throws IOException {
            return this.in.copy();
        }
    }

    private static class ExitableByteVectorValues
    extends ByteVectorValues {
        private final QueryCancellation queryCancellation;
        private final ByteVectorValues in;

        private ExitableByteVectorValues(QueryCancellation queryCancellation, ByteVectorValues in) {
            this.queryCancellation = queryCancellation;
            this.in = in;
        }

        @Override
        public int dimension() {
            return this.in.dimension();
        }

        @Override
        public int size() {
            return this.in.size();
        }

        @Override
        public byte[] vectorValue(int ord) throws IOException {
            return this.in.vectorValue(ord);
        }

        @Override
        public int ordToDoc(int ord) {
            return this.in.ordToDoc(ord);
        }

        @Override
        public VectorScorer scorer(byte[] bytes) throws IOException {
            final VectorScorer scorer = this.in.scorer(bytes);
            if (scorer == null) {
                return null;
            }
            return new VectorScorer(){
                private final DocIdSetIterator iterator;
                {
                    this.iterator = new ExitableDocSetIterator(scorer.iterator(), queryCancellation);
                }

                @Override
                public float score() throws IOException {
                    return scorer.score();
                }

                @Override
                public DocIdSetIterator iterator() {
                    return this.iterator;
                }
            };
        }

        @Override
        public KnnVectorValues.DocIndexIterator iterator() {
            return ExitableDirectoryReader.createExitableIterator(this.in.iterator(), this.queryCancellation);
        }

        @Override
        public ByteVectorValues copy() throws IOException {
            return this.in.copy();
        }
    }

    private static class ExitableIntersectVisitor
    implements PointValues.IntersectVisitor {
        static final int MAX_CALLS_BEFORE_QUERY_TIMEOUT_CHECK = 8191;
        private final QueryCancellation queryCancellation;
        private PointValues.IntersectVisitor in;
        private int calls;

        private ExitableIntersectVisitor(QueryCancellation queryCancellation) {
            this.queryCancellation = queryCancellation;
        }

        private void setIntersectVisitor(PointValues.IntersectVisitor in) {
            this.in = in;
        }

        private void checkAndThrowWithSampling() {
            if ((this.calls++ & 0x1FFF) == 0) {
                this.queryCancellation.checkCancelled();
            }
        }

        @Override
        public void visit(int docID) throws IOException {
            this.checkAndThrowWithSampling();
            this.in.visit(docID);
        }

        @Override
        public void visit(DocIdSetIterator iterator) throws IOException {
            this.checkAndThrowWithSampling();
            this.in.visit(iterator);
        }

        @Override
        public void visit(int docID, byte[] packedValue) throws IOException {
            this.checkAndThrowWithSampling();
            this.in.visit(docID, packedValue);
        }

        @Override
        public void visit(DocIdSetIterator iterator, byte[] packedValue) throws IOException {
            this.checkAndThrowWithSampling();
            this.in.visit(iterator, packedValue);
        }

        @Override
        public PointValues.Relation compare(byte[] minPackedValue, byte[] maxPackedValue) {
            this.queryCancellation.checkCancelled();
            return this.in.compare(minPackedValue, maxPackedValue);
        }

        @Override
        public void grow(int count) {
            this.queryCancellation.checkCancelled();
            this.in.grow(count);
        }
    }

    private static class ExitablePointTree
    implements PointValues.PointTree {
        private final PointValues pointValues;
        private final PointValues.PointTree in;
        private final ExitableIntersectVisitor exitableIntersectVisitor;
        private final QueryCancellation queryCancellation;
        private int calls;

        private ExitablePointTree(PointValues pointValues, PointValues.PointTree in, QueryCancellation queryCancellation) {
            this.pointValues = pointValues;
            this.in = in;
            this.queryCancellation = queryCancellation;
            this.exitableIntersectVisitor = new ExitableIntersectVisitor(queryCancellation);
        }

        private void checkAndThrowWithSampling() {
            if ((this.calls++ & 0x1FFF) == 0) {
                this.queryCancellation.checkCancelled();
            }
        }

        @Override
        public PointValues.PointTree clone() {
            this.queryCancellation.checkCancelled();
            return new ExitablePointTree(this.pointValues, this.in.clone(), this.queryCancellation);
        }

        @Override
        public boolean moveToChild() throws IOException {
            this.checkAndThrowWithSampling();
            return this.in.moveToChild();
        }

        @Override
        public boolean moveToSibling() throws IOException {
            this.checkAndThrowWithSampling();
            return this.in.moveToSibling();
        }

        @Override
        public boolean moveToParent() throws IOException {
            this.checkAndThrowWithSampling();
            return this.in.moveToParent();
        }

        @Override
        public byte[] getMinPackedValue() {
            this.checkAndThrowWithSampling();
            return this.in.getMinPackedValue();
        }

        @Override
        public byte[] getMaxPackedValue() {
            this.checkAndThrowWithSampling();
            return this.in.getMaxPackedValue();
        }

        @Override
        public long size() {
            this.queryCancellation.checkCancelled();
            return this.in.size();
        }

        @Override
        public void visitDocIDs(PointValues.IntersectVisitor visitor) throws IOException {
            this.queryCancellation.checkCancelled();
            this.in.visitDocIDs(visitor);
        }

        @Override
        public void visitDocValues(PointValues.IntersectVisitor visitor) throws IOException {
            this.queryCancellation.checkCancelled();
            this.exitableIntersectVisitor.setIntersectVisitor(visitor);
            this.in.visitDocValues(this.exitableIntersectVisitor);
        }
    }

    static class ExitablePointValues
    extends PointValues {
        private final PointValues in;
        private final QueryCancellation queryCancellation;

        private ExitablePointValues(PointValues in, QueryCancellation queryCancellation) {
            this.in = in;
            this.queryCancellation = queryCancellation;
            this.queryCancellation.checkCancelled();
        }

        @Override
        public PointValues.PointTree getPointTree() throws IOException {
            this.queryCancellation.checkCancelled();
            return new ExitablePointTree(this.in, this.in.getPointTree(), this.queryCancellation);
        }

        @Override
        public byte[] getMinPackedValue() throws IOException {
            this.queryCancellation.checkCancelled();
            return this.in.getMinPackedValue();
        }

        @Override
        public byte[] getMaxPackedValue() throws IOException {
            this.queryCancellation.checkCancelled();
            return this.in.getMaxPackedValue();
        }

        @Override
        public int getNumDimensions() throws IOException {
            this.queryCancellation.checkCancelled();
            return this.in.getNumDimensions();
        }

        @Override
        public int getNumIndexDimensions() throws IOException {
            this.queryCancellation.checkCancelled();
            return this.in.getNumIndexDimensions();
        }

        @Override
        public int getBytesPerDimension() throws IOException {
            this.queryCancellation.checkCancelled();
            return this.in.getBytesPerDimension();
        }

        @Override
        public long size() {
            this.queryCancellation.checkCancelled();
            return this.in.size();
        }

        @Override
        public int getDocCount() {
            this.queryCancellation.checkCancelled();
            return this.in.getDocCount();
        }
    }

    private static class ExitableTermsEnum
    extends FilterLeafReader.FilterTermsEnum {
        private static final int MAX_CALLS_BEFORE_QUERY_TIMEOUT_CHECK = 15;
        private int calls;
        private final QueryCancellation queryCancellation;

        private ExitableTermsEnum(TermsEnum termsEnum, QueryCancellation queryCancellation) {
            super(termsEnum);
            this.queryCancellation = queryCancellation;
            this.queryCancellation.checkCancelled();
        }

        private void checkAndThrowWithSampling() {
            if ((this.calls++ & 0xF) == 0) {
                this.queryCancellation.checkCancelled();
            }
        }

        @Override
        public BytesRef next() throws IOException {
            this.checkAndThrowWithSampling();
            return this.in.next();
        }
    }

    static class ExitableTerms
    extends FilterLeafReader.FilterTerms {
        private final QueryCancellation queryCancellation;

        ExitableTerms(Terms terms, QueryCancellation queryCancellation) {
            super(terms);
            this.queryCancellation = queryCancellation;
        }

        @Override
        public TermsEnum intersect(CompiledAutomaton compiled, BytesRef startTerm) throws IOException {
            return new ExitableTermsEnum(this.in.intersect(compiled, startTerm), this.queryCancellation);
        }

        @Override
        public TermsEnum iterator() throws IOException {
            return new ExitableTermsEnum(this.in.iterator(), this.queryCancellation);
        }

        @Override
        public BytesRef getMin() throws IOException {
            return this.in.getMin();
        }

        @Override
        public BytesRef getMax() throws IOException {
            return this.in.getMax();
        }
    }

    static class ExitableLeafReader
    extends SequentialStoredFieldsLeafReader {
        private final QueryCancellation queryCancellation;

        private ExitableLeafReader(LeafReader leafReader, QueryCancellation queryCancellation) {
            super(leafReader);
            this.queryCancellation = queryCancellation;
        }

        @Override
        public PointValues getPointValues(String field) throws IOException {
            PointValues pointValues = this.in.getPointValues(field);
            if (pointValues == null) {
                return null;
            }
            return this.queryCancellation.isEnabled() ? new ExitablePointValues(pointValues, this.queryCancellation) : pointValues;
        }

        @Override
        public Terms terms(String field) throws IOException {
            Terms terms = this.in.terms(field);
            if (terms == null) {
                return null;
            }
            return this.queryCancellation.isEnabled() && !(terms instanceof CompletionTerms) ? new ExitableTerms(terms, this.queryCancellation) : terms;
        }

        @Override
        public IndexReader.CacheHelper getCoreCacheHelper() {
            return this.in.getCoreCacheHelper();
        }

        @Override
        public IndexReader.CacheHelper getReaderCacheHelper() {
            return this.in.getReaderCacheHelper();
        }

        @Override
        protected StoredFieldsReader doGetSequentialStoredFieldsReader(StoredFieldsReader reader) {
            return reader;
        }

        @Override
        public ByteVectorValues getByteVectorValues(String field) throws IOException {
            ByteVectorValues vectorValues = this.in.getByteVectorValues(field);
            if (vectorValues == null) {
                return null;
            }
            return this.queryCancellation.isEnabled() ? new ExitableByteVectorValues(this.queryCancellation, vectorValues) : vectorValues;
        }

        @Override
        public void searchNearestVectors(String field, byte[] target, KnnCollector collector, Bits acceptDocs) throws IOException {
            if (!this.queryCancellation.isEnabled()) {
                this.in.searchNearestVectors(field, target, collector, acceptDocs);
                return;
            }
            this.in.searchNearestVectors(field, target, collector, this.createTimeOutCheckingBits(acceptDocs));
        }

        @Override
        public FloatVectorValues getFloatVectorValues(String field) throws IOException {
            FloatVectorValues vectorValues = this.in.getFloatVectorValues(field);
            if (vectorValues == null) {
                return null;
            }
            return this.queryCancellation.isEnabled() ? new ExitableFloatVectorValues(vectorValues, this.queryCancellation) : vectorValues;
        }

        @Override
        public void searchNearestVectors(String field, float[] target, KnnCollector collector, Bits acceptDocs) throws IOException {
            if (!this.queryCancellation.isEnabled()) {
                this.in.searchNearestVectors(field, target, collector, acceptDocs);
                return;
            }
            this.in.searchNearestVectors(field, target, collector, this.createTimeOutCheckingBits(acceptDocs));
        }

        private Bits createTimeOutCheckingBits(Bits acceptDocs) {
            if (acceptDocs == null || acceptDocs instanceof BitSet) {
                return new TimeOutCheckingBitSet((BitSet)acceptDocs);
            }
            return new TimeOutCheckingBits(acceptDocs);
        }

        private class TimeOutCheckingBitSet
        extends BitSet {
            private static final int MAX_CALLS_BEFORE_QUERY_TIMEOUT_CHECK = 10;
            private int calls;
            private final BitSet inner;
            private final int maxDoc;

            private TimeOutCheckingBitSet(BitSet inner) {
                this.inner = inner;
                this.maxDoc = ExitableLeafReader.this.maxDoc();
            }

            @Override
            public void set(int i) {
                throw new UnsupportedOperationException("not supported on TimeOutCheckingBitSet");
            }

            @Override
            public boolean getAndSet(int i) {
                throw new UnsupportedOperationException("not supported on TimeOutCheckingBitSet");
            }

            @Override
            public void clear(int i) {
                throw new UnsupportedOperationException("not supported on TimeOutCheckingBitSet");
            }

            @Override
            public void clear(int startIndex, int endIndex) {
                throw new UnsupportedOperationException("not supported on TimeOutCheckingBitSet");
            }

            @Override
            public int cardinality() {
                if (this.inner == null) {
                    return this.maxDoc;
                }
                return this.inner.cardinality();
            }

            @Override
            public int approximateCardinality() {
                if (this.inner == null) {
                    return this.maxDoc;
                }
                return this.inner.approximateCardinality();
            }

            @Override
            public int prevSetBit(int index) {
                throw new UnsupportedOperationException("not supported on TimeOutCheckingBitSet");
            }

            @Override
            public int nextSetBit(int start, int end) {
                throw new UnsupportedOperationException("not supported on TimeOutCheckingBitSet");
            }

            @Override
            public long ramBytesUsed() {
                throw new UnsupportedOperationException("not supported on TimeOutCheckingBitSet");
            }

            @Override
            public boolean get(int index) {
                if (this.calls++ % 10 == 0) {
                    ExitableLeafReader.this.queryCancellation.checkCancelled();
                }
                if (this.inner == null) {
                    return index >= 0 && index < this.maxDoc;
                }
                return this.inner.get(index);
            }

            @Override
            public int length() {
                if (this.inner == null) {
                    return this.maxDoc;
                }
                return 0;
            }
        }

        private class TimeOutCheckingBits
        implements Bits {
            private static final int MAX_CALLS_BEFORE_QUERY_TIMEOUT_CHECK = 10;
            private final Bits updatedAcceptDocs;
            private int calls;

            private TimeOutCheckingBits(Bits acceptDocs) {
                this.updatedAcceptDocs = acceptDocs == null ? new Bits.MatchAllBits(ExitableLeafReader.this.maxDoc()) : acceptDocs;
            }

            @Override
            public boolean get(int index) {
                if (this.calls++ % 10 == 0) {
                    ExitableLeafReader.this.queryCancellation.checkCancelled();
                }
                return this.updatedAcceptDocs.get(index);
            }

            @Override
            public int length() {
                return this.updatedAcceptDocs.length();
            }
        }
    }
}

