/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.sampler;

import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import org.apache.lucene.misc.search.DiversifiedTopDocsCollector;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.common.util.LongArray;
import org.elasticsearch.common.xcontent.LoggingDeprecationHandler;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.search.aggregations.AggregationExecutionContext;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.LeafBucketCollector;
import org.elasticsearch.search.aggregations.bucket.DeferableBucketAggregator;
import org.elasticsearch.search.aggregations.bucket.DeferringBucketCollector;
import org.elasticsearch.search.aggregations.bucket.SingleBucketAggregator;
import org.elasticsearch.search.aggregations.bucket.sampler.BestDocsDeferringCollector;
import org.elasticsearch.search.aggregations.bucket.sampler.DiversifiedBytesHashSamplerAggregator;
import org.elasticsearch.search.aggregations.bucket.sampler.DiversifiedMapSamplerAggregator;
import org.elasticsearch.search.aggregations.bucket.sampler.DiversifiedOrdinalsSamplerAggregator;
import org.elasticsearch.search.aggregations.bucket.sampler.InternalSampler;
import org.elasticsearch.search.aggregations.support.AggregationContext;
import org.elasticsearch.search.aggregations.support.ValuesSourceConfig;
import org.elasticsearch.xcontent.ParseField;

public class SamplerAggregator
extends DeferableBucketAggregator
implements SingleBucketAggregator {
    public static final ParseField SHARD_SIZE_FIELD = new ParseField("shard_size", new String[0]);
    public static final ParseField MAX_DOCS_PER_VALUE_FIELD = new ParseField("max_docs_per_value", new String[0]);
    public static final ParseField EXECUTION_HINT_FIELD = new ParseField("execution_hint", new String[0]);
    static final long SCOREDOCKEY_SIZE = RamUsageEstimator.shallowSizeOfInstance(DiversifiedTopDocsCollector.ScoreDocKey.class);
    protected final int shardSize;
    protected BestDocsDeferringCollector bdd;

    SamplerAggregator(String name, int shardSize, AggregatorFactories factories, AggregationContext context, Aggregator parent, Map<String, Object> metadata) throws IOException {
        super(name, factories, context, parent, metadata);
        this.shardSize = Math.min(shardSize, this.searcher().getIndexReader().maxDoc());
    }

    @Override
    public ScoreMode scoreMode() {
        return ScoreMode.COMPLETE;
    }

    @Override
    public DeferringBucketCollector buildDeferringCollector() {
        this.bdd = new BestDocsDeferringCollector(this.shardSize, this.bigArrays(), x$0 -> this.addRequestCircuitBreakerBytes((long)x$0));
        return this.bdd;
    }

    @Override
    protected boolean shouldDefer(Aggregator aggregator) {
        return true;
    }

    @Override
    public InternalAggregation[] buildAggregations(LongArray owningBucketOrds) throws IOException {
        return this.buildAggregationsForSingleBucket(owningBucketOrds, (owningBucketOrd, subAggregationResults) -> new InternalSampler(this.name, this.bdd == null ? 0L : (long)this.bdd.getDocCount(owningBucketOrd), subAggregationResults, this.metadata()));
    }

    @Override
    public InternalAggregation buildEmptyAggregation() {
        return new InternalSampler(this.name, 0L, this.buildEmptySubAggregations(), this.metadata());
    }

    @Override
    protected LeafBucketCollector getLeafCollector(AggregationExecutionContext aggCtx, LeafBucketCollector sub) throws IOException {
        if (this.bdd == null) {
            throw new IllegalArgumentException("Sampler aggregation must be used with child aggregations.");
        }
        return this.bdd.getLeafCollector(aggCtx);
    }

    @Override
    protected void doClose() {
        Releasables.close((Releasable)this.bdd);
        super.doClose();
    }

    public static enum ExecutionMode {
        MAP(new ParseField("map", new String[0])){

            @Override
            Aggregator create(String name, AggregatorFactories factories, int shardSize, int maxDocsPerValue, ValuesSourceConfig valuesSourceConfig, AggregationContext context, Aggregator parent, Map<String, Object> metadata) throws IOException {
                return new DiversifiedMapSamplerAggregator(name, shardSize, factories, context, parent, metadata, valuesSourceConfig, maxDocsPerValue);
            }

            @Override
            boolean needsGlobalOrdinals() {
                return false;
            }
        }
        ,
        BYTES_HASH(new ParseField("bytes_hash", new String[0])){

            @Override
            Aggregator create(String name, AggregatorFactories factories, int shardSize, int maxDocsPerValue, ValuesSourceConfig valuesSourceConfig, AggregationContext context, Aggregator parent, Map<String, Object> metadata) throws IOException {
                return new DiversifiedBytesHashSamplerAggregator(name, shardSize, factories, context, parent, metadata, valuesSourceConfig, maxDocsPerValue);
            }

            @Override
            boolean needsGlobalOrdinals() {
                return false;
            }
        }
        ,
        GLOBAL_ORDINALS(new ParseField("global_ordinals", new String[0])){

            @Override
            Aggregator create(String name, AggregatorFactories factories, int shardSize, int maxDocsPerValue, ValuesSourceConfig valuesSourceConfig, AggregationContext context, Aggregator parent, Map<String, Object> metadata) throws IOException {
                return new DiversifiedOrdinalsSamplerAggregator(name, shardSize, factories, context, parent, metadata, valuesSourceConfig, maxDocsPerValue);
            }

            @Override
            boolean needsGlobalOrdinals() {
                return true;
            }
        };

        private final ParseField parseField;

        public static ExecutionMode fromString(String value) {
            for (ExecutionMode mode : ExecutionMode.values()) {
                if (!mode.parseField.match(value, LoggingDeprecationHandler.INSTANCE)) continue;
                return mode;
            }
            throw new IllegalArgumentException("Unknown `execution_hint`: [" + value + "], expected any of " + Arrays.toString((Object[])ExecutionMode.values()));
        }

        private ExecutionMode(ParseField parseField) {
            this.parseField = parseField;
        }

        abstract Aggregator create(String var1, AggregatorFactories var2, int var3, int var4, ValuesSourceConfig var5, AggregationContext var6, Aggregator var7, Map<String, Object> var8) throws IOException;

        abstract boolean needsGlobalOrdinals();

        public String toString() {
            return this.parseField.getPreferredName();
        }
    }
}

