/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import org.elasticsearch.common.util.LongArray;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.BucketCollector;
import org.elasticsearch.search.aggregations.CardinalityUpperBound;
import org.elasticsearch.search.aggregations.MultiBucketCollector;
import org.elasticsearch.search.aggregations.bucket.BestBucketsDeferringCollector;
import org.elasticsearch.search.aggregations.bucket.BucketsAggregator;
import org.elasticsearch.search.aggregations.bucket.DeferringBucketCollector;
import org.elasticsearch.search.aggregations.support.AggregationContext;

public abstract class DeferableBucketAggregator
extends BucketsAggregator {
    private DeferringBucketCollector deferringCollector;
    private List<String> deferredAggregationNames;
    private final boolean inSortOrderExecutionRequired;

    protected DeferableBucketAggregator(String name, AggregatorFactories factories, AggregationContext context, Aggregator parent, Map<String, Object> metadata) throws IOException {
        super(name, factories, context, parent, CardinalityUpperBound.MANY, metadata);
        this.inSortOrderExecutionRequired = context.isInSortOrderExecutionRequired();
    }

    @Override
    protected void doPreCollection() throws IOException {
        ArrayList<BucketCollector> collectors = new ArrayList<BucketCollector>(this.subAggregators.length);
        ArrayList<Aggregator> deferredAggregations = null;
        for (int i = 0; i < this.subAggregators.length; ++i) {
            if (this.shouldDefer(this.subAggregators[i])) {
                if (this.inSortOrderExecutionRequired) {
                    throw new IllegalArgumentException("[" + this.name + "] aggregation is incompatible with time series execution mode");
                }
                if (this.deferringCollector == null) {
                    this.deferringCollector = this.buildDeferringCollector();
                    deferredAggregations = new ArrayList<Aggregator>(this.subAggregators.length);
                    this.deferredAggregationNames = new ArrayList<String>(this.subAggregators.length);
                }
                deferredAggregations.add(this.subAggregators[i]);
                this.deferredAggregationNames.add(this.subAggregators[i].name());
                this.subAggregators[i] = this.deferringCollector.wrap(this.subAggregators[i], this.bigArrays());
                continue;
            }
            collectors.add(this.subAggregators[i]);
        }
        if (this.deferringCollector != null) {
            this.deferringCollector.setDeferredCollector(deferredAggregations);
            collectors.add(this.deferringCollector);
        }
        this.collectableSubAggregators = MultiBucketCollector.wrap(false, collectors);
    }

    protected DeferringBucketCollector deferringCollector() {
        return this.deferringCollector;
    }

    protected DeferringBucketCollector buildDeferringCollector() {
        return new BestBucketsDeferringCollector(this.topLevelQuery(), this.searcher(), DeferableBucketAggregator.descendsFromGlobalAggregator(this.parent()));
    }

    protected boolean shouldDefer(Aggregator aggregator) {
        return false;
    }

    @Override
    protected final void prepareSubAggs(LongArray bucketOrdsToCollect) throws IOException {
        if (this.deferringCollector != null) {
            this.deferringCollector.prepareSelectedBuckets(bucketOrdsToCollect);
        }
    }

    @Override
    public void collectDebugInfo(BiConsumer<String, Object> add) {
        if (this.deferredAggregationNames != null) {
            add.accept("deferred_aggregators", this.deferredAggregationNames);
        }
        super.collectDebugInfo(add);
    }
}

