/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.persistent;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.MasterNodeRequest;
import org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.ProjectId;
import org.elasticsearch.cluster.project.ProjectResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.persistent.PersistentTaskResponse;
import org.elasticsearch.persistent.PersistentTasksClusterService;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class RemovePersistentTaskAction {
    public static final ActionType<PersistentTaskResponse> INSTANCE = new ActionType("cluster:admin/persistent/remove");

    private RemovePersistentTaskAction() {
    }

    public static class TransportAction
    extends TransportMasterNodeAction<Request, PersistentTaskResponse> {
        private final PersistentTasksClusterService persistentTasksClusterService;
        private final ProjectResolver projectResolver;

        @Inject
        public TransportAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, PersistentTasksClusterService persistentTasksClusterService, ProjectResolver projectResolver) {
            super(INSTANCE.name(), transportService, clusterService, threadPool, actionFilters, Request::new, PersistentTaskResponse::new, threadPool.executor("management"));
            this.persistentTasksClusterService = persistentTasksClusterService;
            this.projectResolver = projectResolver;
        }

        @Override
        protected ClusterBlockException checkBlock(Request request, ClusterState state) {
            return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
        }

        @Override
        protected final void masterOperation(Task ignoredTask, Request request, ClusterState state, ActionListener<PersistentTaskResponse> listener) {
            ProjectId projectIdHint = PersistentTasksClusterService.resolveProjectIdHint(this.projectResolver);
            this.persistentTasksClusterService.removePersistentTask(projectIdHint, request.taskId, listener.map(PersistentTaskResponse::new));
        }
    }

    public static class Request
    extends MasterNodeRequest<Request> {
        private final String taskId;

        public Request(StreamInput in) throws IOException {
            super(in);
            this.taskId = in.readString();
        }

        public Request(TimeValue masterNodeTimeout, String taskId) {
            super(masterNodeTimeout);
            this.taskId = taskId;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeString(this.taskId);
        }

        @Override
        public ActionRequestValidationException validate() {
            return null;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Request request = (Request)o;
            return Objects.equals(this.taskId, request.taskId);
        }

        public int hashCode() {
            return Objects.hash(this.taskId);
        }
    }
}

