/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.license;

import java.util.UUID;
import org.elasticsearch.common.logging.LoggerMessageFormat;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.license.License;

abstract class ExpirationCallback {
    static final String EXPIRATION_JOB_PREFIX = ".license_expiration_job_";
    private final String id;
    private final Orientation orientation;
    private final long min;
    private final long max;
    private final long frequency;

    private ExpirationCallback(Orientation orientation, TimeValue min, TimeValue max, TimeValue frequency) {
        this.orientation = orientation;
        this.min = min == null ? 0L : min.getMillis();
        this.max = max == null ? Long.MAX_VALUE : max.getMillis();
        this.frequency = frequency.getMillis();
        this.id = String.join((CharSequence)"", EXPIRATION_JOB_PREFIX, UUID.randomUUID().toString());
    }

    public final String getId() {
        return this.id;
    }

    public final long getFrequency() {
        return this.frequency;
    }

    final TimeValue delay(long expirationDate, long now) {
        return switch (this.orientation.ordinal()) {
            case 0 -> {
                if (expirationDate >= now) {
                    long preExpiryDuration = expirationDate - now;
                    if (preExpiryDuration > this.max) {
                        yield TimeValue.timeValueMillis(preExpiryDuration - this.max);
                    }
                    if (preExpiryDuration <= this.max && preExpiryDuration >= this.min) {
                        yield TimeValue.timeValueMillis(0L);
                    }
                    yield null;
                }
                yield null;
            }
            case 1 -> {
                if (expirationDate >= now) {
                    yield TimeValue.timeValueMillis(expirationDate - now + this.min);
                }
                long expiredDuration = now - expirationDate;
                if (expiredDuration < this.min) {
                    yield TimeValue.timeValueMillis(this.min - expiredDuration);
                }
                if (expiredDuration >= this.min && expiredDuration <= this.max) {
                    yield TimeValue.timeValueMillis(0L);
                }
                yield null;
            }
            default -> throw new IllegalStateException("orientation [" + String.valueOf((Object)this.orientation) + "] unknown");
        };
    }

    public final long nextScheduledTimeForExpiry(long expiryDate, long startTime, long time) {
        TimeValue delay = this.delay(expiryDate, time);
        if (delay != null) {
            long delayInMillis = delay.getMillis();
            if (delayInMillis == 0L) {
                if (startTime == time) {
                    return time;
                }
                return time + this.frequency;
            }
            return time + delayInMillis;
        }
        return -1L;
    }

    public abstract void on(License var1);

    public final String toString() {
        return LoggerMessageFormat.format(null, "ExpirationCallback:(orientation [{}],  min [{}], max [{}], freq [{}])", this.orientation.name(), TimeValue.timeValueMillis(this.min), TimeValue.timeValueMillis(this.max), TimeValue.timeValueMillis(this.frequency));
    }

    public static enum Orientation {
        PRE,
        POST;

    }

    public static abstract class Post
    extends ExpirationCallback {
        Post(TimeValue min, TimeValue max, TimeValue frequency) {
            super(Orientation.POST, min, max, frequency);
        }
    }

    public static abstract class Pre
    extends ExpirationCallback {
        Pre(TimeValue min, TimeValue max, TimeValue frequency) {
            super(Orientation.PRE, min, max, frequency);
        }
    }
}

