/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.ingest.common;

import java.util.Map;
import org.elasticsearch.cluster.metadata.ProjectId;
import org.elasticsearch.ingest.AbstractProcessor;
import org.elasticsearch.ingest.ConfigurationUtils;
import org.elasticsearch.ingest.IngestDocument;
import org.elasticsearch.ingest.Processor;
import org.elasticsearch.ingest.common.FailProcessorException;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.script.TemplateScript;

public final class FailProcessor
extends AbstractProcessor {
    public static final String TYPE = "fail";
    private final TemplateScript.Factory message;

    FailProcessor(String tag, String description, TemplateScript.Factory message) {
        super(tag, description);
        this.message = message;
    }

    public TemplateScript.Factory getMessage() {
        return this.message;
    }

    @Override
    public IngestDocument execute(IngestDocument document) {
        throw new FailProcessorException(document.renderTemplate(this.message));
    }

    @Override
    public String getType() {
        return TYPE;
    }

    public static final class Factory
    implements Processor.Factory {
        private final ScriptService scriptService;

        public Factory(ScriptService scriptService) {
            this.scriptService = scriptService;
        }

        @Override
        public FailProcessor create(Map<String, Processor.Factory> registry, String processorTag, String description, Map<String, Object> config, ProjectId projectId) throws Exception {
            String message = ConfigurationUtils.readStringProperty(FailProcessor.TYPE, processorTag, config, "message");
            TemplateScript.Factory compiledTemplate = ConfigurationUtils.compileTemplate(FailProcessor.TYPE, processorTag, "message", message, this.scriptService);
            return new FailProcessor(processorTag, description, compiledTemplate);
        }
    }
}

