/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.ingest.common;

import java.util.Map;
import org.elasticsearch.cluster.metadata.ProjectId;
import org.elasticsearch.ingest.AbstractProcessor;
import org.elasticsearch.ingest.ConfigurationUtils;
import org.elasticsearch.ingest.IngestDocument;
import org.elasticsearch.ingest.Processor;
import org.elasticsearch.ingest.ValueSource;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.script.TemplateScript;

public final class AppendProcessor
extends AbstractProcessor {
    public static final String TYPE = "append";
    private final TemplateScript.Factory field;
    private final ValueSource value;
    private final boolean allowDuplicates;

    AppendProcessor(String tag, String description, TemplateScript.Factory field, ValueSource value, boolean allowDuplicates) {
        super(tag, description);
        this.field = field;
        this.value = value;
        this.allowDuplicates = allowDuplicates;
    }

    public TemplateScript.Factory getField() {
        return this.field;
    }

    public ValueSource getValue() {
        return this.value;
    }

    @Override
    public IngestDocument execute(IngestDocument document) throws Exception {
        String path = document.renderTemplate(this.field);
        document.appendFieldValue(path, this.value, this.allowDuplicates);
        return document;
    }

    @Override
    public String getType() {
        return TYPE;
    }

    public static final class Factory
    implements Processor.Factory {
        private final ScriptService scriptService;

        public Factory(ScriptService scriptService) {
            this.scriptService = scriptService;
        }

        @Override
        public AppendProcessor create(Map<String, Processor.Factory> registry, String processorTag, String description, Map<String, Object> config, ProjectId projectId) throws Exception {
            String field = ConfigurationUtils.readStringProperty(AppendProcessor.TYPE, processorTag, config, "field");
            Object value = ConfigurationUtils.readObject(AppendProcessor.TYPE, processorTag, config, "value");
            boolean allowDuplicates = ConfigurationUtils.readBooleanProperty(AppendProcessor.TYPE, processorTag, config, "allow_duplicates", true);
            TemplateScript.Factory compiledTemplate = ConfigurationUtils.compileTemplate(AppendProcessor.TYPE, processorTag, "field", field, this.scriptService);
            String mediaType = ConfigurationUtils.readMediaTypeProperty(AppendProcessor.TYPE, processorTag, config, "media_type", "application/json");
            return new AppendProcessor(processorTag, description, compiledTemplate, ValueSource.wrap(value, this.scriptService, Map.of("content_type", mediaType)), allowDuplicates);
        }
    }
}

