/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.store;

import java.io.IOException;
import java.io.UncheckedIOException;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FilterDirectory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexOutput;
import org.elasticsearch.common.lucene.store.FilterIndexOutput;
import org.elasticsearch.common.util.SingleObjectCache;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.index.store.ByteSizeDirectory;

public final class ByteSizeCachingDirectory
extends ByteSizeDirectory {
    private final SingleObjectCache<SizeAndModCount> size;
    private long modCount = 0L;
    private long numOpenOutputs = 0L;

    ByteSizeCachingDirectory(Directory in, TimeValue refreshInterval) {
        super(in);
        this.size = new SingleObjectCache<SizeAndModCount>(refreshInterval, new SizeAndModCount(0L, -1L, true)){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected SizeAndModCount refresh() {
                long size;
                boolean pendingWrite;
                long modCount;
                ByteSizeCachingDirectory byteSizeCachingDirectory = ByteSizeCachingDirectory.this;
                synchronized (byteSizeCachingDirectory) {
                    modCount = ByteSizeCachingDirectory.this.modCount;
                    pendingWrite = ByteSizeCachingDirectory.this.numOpenOutputs != 0L;
                }
                try {
                    size = ByteSizeDirectory.estimateSizeInBytes(ByteSizeCachingDirectory.this.getDelegate());
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
                return new SizeAndModCount(size, modCount, pendingWrite);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected boolean needsRefresh() {
                if (!super.needsRefresh()) {
                    return false;
                }
                SizeAndModCount cached = (SizeAndModCount)this.getNoRefresh();
                if (cached.pendingWrite) {
                    return true;
                }
                ByteSizeCachingDirectory byteSizeCachingDirectory = ByteSizeCachingDirectory.this;
                synchronized (byteSizeCachingDirectory) {
                    return ByteSizeCachingDirectory.this.numOpenOutputs != 0L || cached.modCount != ByteSizeCachingDirectory.this.modCount;
                }
            }
        };
    }

    @Override
    public long estimateSizeInBytes() throws IOException {
        try {
            return this.size.getOrRefresh().size;
        }
        catch (UncheckedIOException e) {
            throw e.getCause();
        }
    }

    @Override
    public long estimateDataSetSizeInBytes() throws IOException {
        return this.estimateSizeInBytes();
    }

    @Override
    public IndexOutput createOutput(String name, IOContext context) throws IOException {
        return this.wrapIndexOutput(super.createOutput(name, context));
    }

    @Override
    public IndexOutput createTempOutput(String prefix, String suffix, IOContext context) throws IOException {
        return this.wrapIndexOutput(super.createTempOutput(prefix, suffix, context));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IndexOutput wrapIndexOutput(IndexOutput out) {
        ByteSizeCachingDirectory byteSizeCachingDirectory = this;
        synchronized (byteSizeCachingDirectory) {
            ++this.numOpenOutputs;
        }
        return new FilterIndexOutput(out.toString(), out){
            private boolean closed;

            @Override
            public void writeBytes(byte[] b, int length) throws IOException {
                super.writeBytes(b, length);
            }

            @Override
            public void writeByte(byte b) throws IOException {
                super.writeByte(b);
            }

            @Override
            public void writeInt(int i) throws IOException {
                this.out.writeInt(i);
            }

            @Override
            public void writeShort(short s) throws IOException {
                this.out.writeShort(s);
            }

            @Override
            public void writeLong(long l) throws IOException {
                this.out.writeLong(l);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void close() throws IOException {
                try {
                    super.close();
                }
                finally {
                    ByteSizeCachingDirectory byteSizeCachingDirectory = ByteSizeCachingDirectory.this;
                    synchronized (byteSizeCachingDirectory) {
                        if (!this.closed) {
                            this.closed = true;
                            --ByteSizeCachingDirectory.this.numOpenOutputs;
                            ++ByteSizeCachingDirectory.this.modCount;
                        }
                    }
                }
            }
        };
    }

    @Override
    public void deleteFile(String name) throws IOException {
        try {
            super.deleteFile(name);
        }
        finally {
            this.markEstimatedSizeAsStale();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markEstimatedSizeAsStale() {
        ByteSizeCachingDirectory byteSizeCachingDirectory = this;
        synchronized (byteSizeCachingDirectory) {
            ++this.modCount;
        }
    }

    public static ByteSizeCachingDirectory unwrapDirectory(Directory dir) {
        while (dir != null) {
            if (dir instanceof ByteSizeCachingDirectory) {
                return (ByteSizeCachingDirectory)dir;
            }
            if (dir instanceof FilterDirectory) {
                dir = ((FilterDirectory)dir).getDelegate();
                continue;
            }
            dir = null;
        }
        return null;
    }

    private static class SizeAndModCount {
        final long size;
        final long modCount;
        final boolean pendingWrite;

        SizeAndModCount(long length, long modCount, boolean pendingWrite) {
            this.size = length;
            this.modCount = modCount;
            this.pendingWrite = pendingWrite;
        }
    }
}

