/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Objects;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.AutomatonQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.automaton.Automaton;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.index.query.AbstractQueryBuilder;
import org.elasticsearch.index.query.MultiTermQueryBuilder;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;

public class AutomatonQueryBuilder
extends AbstractQueryBuilder<AutomatonQueryBuilder>
implements MultiTermQueryBuilder {
    private final String fieldName;
    private final Automaton automaton;
    private final String description;

    public AutomatonQueryBuilder(String fieldName, Automaton automaton, String description) {
        if (Strings.isEmpty(fieldName)) {
            throw new IllegalArgumentException("field name is null or empty");
        }
        if (automaton == null) {
            throw new IllegalArgumentException("automaton cannot be null");
        }
        this.fieldName = fieldName;
        this.automaton = automaton;
        this.description = description;
    }

    @Override
    public String fieldName() {
        return this.fieldName;
    }

    public String description() {
        return this.description;
    }

    @Override
    public String getWriteableName() {
        throw new UnsupportedOperationException("AutomatonQueryBuilder does not support getWriteableName");
    }

    @Override
    protected void doWriteTo(StreamOutput out) throws IOException {
        throw new UnsupportedEncodingException("AutomatonQueryBuilder does not support doWriteTo");
    }

    @Override
    protected void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        throw new UnsupportedEncodingException("AutomatonQueryBuilder does not support doXContent");
    }

    @Override
    protected Query doToQuery(SearchExecutionContext context) throws IOException {
        return new AutomatonQueryWithDescription(new Term(this.fieldName), this.automaton, this.description);
    }

    @Override
    protected int doHashCode() {
        return Objects.hash(this.fieldName, this.automaton, this.description);
    }

    @Override
    protected boolean doEquals(AutomatonQueryBuilder other) {
        return Objects.equals(this.fieldName, other.fieldName) && Objects.equals(this.automaton, other.automaton) && Objects.equals(this.description, other.description);
    }

    @Override
    public TransportVersion getMinimalSupportedVersion() {
        throw new UnsupportedOperationException("AutomatonQueryBuilder does not support getMinimalSupportedVersion");
    }

    static class AutomatonQueryWithDescription
    extends AutomatonQuery {
        private final String description;

        AutomatonQueryWithDescription(Term term, Automaton automaton, String description) {
            super(term, automaton);
            this.description = description;
        }

        @Override
        public String toString(String field) {
            if (this.field.equals(field)) {
                return this.description;
            }
            return this.field + ":" + this.description;
        }
    }
}

