/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata.plain;

import java.io.IOException;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.SortedNumericDocValues;
import org.elasticsearch.index.fielddata.MultiGeoPointValues;
import org.elasticsearch.index.fielddata.plain.LeafGeoPointFieldData;
import org.elasticsearch.script.field.ToScriptFieldFactory;

final class LatLonPointDVLeafFieldData
extends LeafGeoPointFieldData {
    private final LeafReader reader;
    private final String fieldName;

    LatLonPointDVLeafFieldData(LeafReader reader, String fieldName, ToScriptFieldFactory<MultiGeoPointValues> toScriptFieldFactory) {
        super(toScriptFieldFactory);
        this.reader = reader;
        this.fieldName = fieldName;
    }

    @Override
    public long ramBytesUsed() {
        return 0L;
    }

    @Override
    public SortedNumericDocValues getSortedNumericDocValues() {
        try {
            return DocValues.getSortedNumeric(this.reader, this.fieldName);
        }
        catch (IOException e) {
            throw new IllegalStateException("Cannot load doc values", e);
        }
    }
}

