/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.grok.shaded.org.joni.ast;

import org.elasticsearch.grok.shaded.org.jcodings.CodeRange;
import org.elasticsearch.grok.shaded.org.jcodings.Encoding;
import org.elasticsearch.grok.shaded.org.jcodings.IntHolder;
import org.elasticsearch.grok.shaded.org.joni.BitSet;
import org.elasticsearch.grok.shaded.org.joni.CodeRangeBuffer;
import org.elasticsearch.grok.shaded.org.joni.ScanEnvironment;
import org.elasticsearch.grok.shaded.org.joni.ast.Node;
import org.elasticsearch.grok.shaded.org.joni.exception.InternalException;
import org.elasticsearch.grok.shaded.org.joni.exception.SyntaxException;
import org.elasticsearch.grok.shaded.org.joni.exception.ValueException;

public final class CClassNode
extends Node {
    private static final int FLAG_NCCLASS_NOT = 1;
    private int flags;
    public final BitSet bs = new BitSet();
    public CodeRangeBuffer mbuf;

    public CClassNode() {
        super(1);
    }

    public void clear() {
        this.bs.clear();
        this.flags = 0;
        this.mbuf = null;
    }

    @Override
    public String getName() {
        return "Character Class";
    }

    @Override
    public String toString(int level) {
        StringBuilder value = new StringBuilder();
        value.append("\n  flags: " + this.flagsToString());
        value.append("\n  bs: " + CClassNode.pad(this.bs, level + 1));
        value.append("\n  mbuf: " + CClassNode.pad(this.mbuf, level + 1));
        return value.toString();
    }

    public String flagsToString() {
        StringBuilder flags = new StringBuilder();
        if (this.isNot()) {
            flags.append("NOT ");
        }
        return flags.toString();
    }

    public boolean isEmpty() {
        return this.mbuf == null && this.bs.isEmpty();
    }

    void addCodeRangeToBuf(ScanEnvironment env, int from, int to) {
        this.addCodeRangeToBuf(env, from, to, true);
    }

    void addCodeRangeToBuf(ScanEnvironment env, int from, int to, boolean checkDup) {
        this.mbuf = CodeRangeBuffer.addCodeRangeToBuff(this.mbuf, env, from, to, checkDup);
    }

    public void addCodeRange(ScanEnvironment env, int from, int to) {
        this.addCodeRange(env, from, to, true);
    }

    public void addCodeRange(ScanEnvironment env, int from, int to, boolean checkDup) {
        this.mbuf = CodeRangeBuffer.addCodeRange(this.mbuf, env, from, to, checkDup);
    }

    void addAllMultiByteRange(ScanEnvironment env) {
        this.mbuf = CodeRangeBuffer.addAllMultiByteRange(env, this.mbuf);
    }

    public void clearNotFlag(ScanEnvironment env) {
        if (this.isNot()) {
            this.bs.invert();
            if (!env.enc.isSingleByte()) {
                this.mbuf = CodeRangeBuffer.notCodeRangeBuff(env, this.mbuf);
            }
            this.clearNot();
        }
    }

    public int isOneChar() {
        if (this.isNot()) {
            return -1;
        }
        int c = -1;
        if (this.mbuf != null) {
            int[] range = this.mbuf.getCodeRange();
            c = range[1];
            if (range[0] == 1 && c == range[2]) {
                if (c < 256 && this.bs.at(c)) {
                    c = -1;
                }
            } else {
                return -1;
            }
        }
        for (int i = 0; i < 8; ++i) {
            int b1 = this.bs.bits[i];
            if (b1 == 0) continue;
            if ((b1 & b1 - 1) == 0 && c == -1) {
                c = 32 * i + Integer.bitCount(b1 - 1);
                continue;
            }
            return -1;
        }
        return c;
    }

    public void and(CClassNode other, ScanEnvironment env) {
        boolean not1 = this.isNot();
        BitSet bsr1 = this.bs;
        CodeRangeBuffer buf1 = this.mbuf;
        boolean not2 = other.isNot();
        BitSet bsr2 = other.bs;
        CodeRangeBuffer buf2 = other.mbuf;
        if (not1) {
            BitSet bs1 = new BitSet();
            bsr1.invertTo(bs1);
            bsr1 = bs1;
        }
        if (not2) {
            BitSet bs2 = new BitSet();
            bsr2.invertTo(bs2);
            bsr2 = bs2;
        }
        bsr1.and(bsr2);
        if (bsr1 != this.bs) {
            this.bs.copy(bsr1);
            bsr1 = this.bs;
        }
        if (not1) {
            this.bs.invert();
        }
        CodeRangeBuffer pbuf = null;
        if (!env.enc.isSingleByte()) {
            if (not1 && not2) {
                pbuf = CodeRangeBuffer.orCodeRangeBuff(env, buf1, false, buf2, false);
            } else {
                pbuf = CodeRangeBuffer.andCodeRangeBuff(buf1, not1, buf2, not2, env);
                if (not1) {
                    pbuf = CodeRangeBuffer.notCodeRangeBuff(env, pbuf);
                }
            }
            this.mbuf = pbuf;
        }
    }

    public void or(CClassNode other, ScanEnvironment env) {
        boolean not1 = this.isNot();
        BitSet bsr1 = this.bs;
        CodeRangeBuffer buf1 = this.mbuf;
        boolean not2 = other.isNot();
        BitSet bsr2 = other.bs;
        CodeRangeBuffer buf2 = other.mbuf;
        if (not1) {
            BitSet bs1 = new BitSet();
            bsr1.invertTo(bs1);
            bsr1 = bs1;
        }
        if (not2) {
            BitSet bs2 = new BitSet();
            bsr2.invertTo(bs2);
            bsr2 = bs2;
        }
        bsr1.or(bsr2);
        if (bsr1 != this.bs) {
            this.bs.copy(bsr1);
            bsr1 = this.bs;
        }
        if (not1) {
            this.bs.invert();
        }
        if (!env.enc.isSingleByte()) {
            CodeRangeBuffer pbuf = null;
            if (not1 && not2) {
                pbuf = CodeRangeBuffer.andCodeRangeBuff(buf1, false, buf2, false, env);
            } else {
                pbuf = CodeRangeBuffer.orCodeRangeBuff(env, buf1, not1, buf2, not2);
                if (not1) {
                    pbuf = CodeRangeBuffer.notCodeRangeBuff(env, pbuf);
                }
            }
            this.mbuf = pbuf;
        }
    }

    public void addCTypeByRange(int ctype, boolean not, ScanEnvironment env, int sbOut, int[] mbr) {
        int n = mbr[0];
        if (!not) {
            int i;
            for (i = 0; i < n; ++i) {
                for (int j = CClassNode.CR_FROM(mbr, i); j <= CClassNode.CR_TO(mbr, i); ++j) {
                    if (j >= sbOut) {
                        if (j > CClassNode.CR_FROM(mbr, i)) {
                            this.addCodeRangeToBuf(env, j, CClassNode.CR_TO(mbr, i));
                            ++i;
                        }
                        while (i < n) {
                            this.addCodeRangeToBuf(env, CClassNode.CR_FROM(mbr, i), CClassNode.CR_TO(mbr, i));
                            ++i;
                        }
                        return;
                    }
                    this.bs.set(env, j);
                }
            }
            while (i < n) {
                this.addCodeRangeToBuf(env, CClassNode.CR_FROM(mbr, i), CClassNode.CR_TO(mbr, i));
                ++i;
            }
        } else {
            int j;
            int i;
            int prev = 0;
            for (i = 0; i < n; ++i) {
                for (j = prev; j < CClassNode.CR_FROM(mbr, i); ++j) {
                    if (j >= sbOut) {
                        prev = sbOut;
                        for (i = 0; i < n; ++i) {
                            if (prev < CClassNode.CR_FROM(mbr, i)) {
                                this.addCodeRangeToBuf(env, prev, CClassNode.CR_FROM(mbr, i) - 1);
                            }
                            prev = CClassNode.CR_TO(mbr, i) + 1;
                        }
                        if (prev < Integer.MAX_VALUE) {
                            this.addCodeRangeToBuf(env, prev, Integer.MAX_VALUE);
                        }
                        return;
                    }
                    this.bs.set(env, j);
                }
                prev = CClassNode.CR_TO(mbr, i) + 1;
            }
            for (j = prev; j < sbOut; ++j) {
                this.bs.set(env, j);
            }
            prev = sbOut;
            for (i = 0; i < n; ++i) {
                if (prev < CClassNode.CR_FROM(mbr, i)) {
                    this.addCodeRangeToBuf(env, prev, CClassNode.CR_FROM(mbr, i) - 1);
                }
                prev = CClassNode.CR_TO(mbr, i) + 1;
            }
            if (prev < Integer.MAX_VALUE) {
                this.addCodeRangeToBuf(env, prev, Integer.MAX_VALUE);
            }
        }
    }

    private static int CR_FROM(int[] range, int i) {
        return range[i * 2 + 1];
    }

    private static int CR_TO(int[] range, int i) {
        return range[i * 2 + 2];
    }

    public void addCType(int ctype, boolean not, boolean asciiRange, ScanEnvironment env, IntHolder sbOut) {
        Encoding enc = env.enc;
        int[] ranges = enc.ctypeCodeRange(ctype, sbOut);
        if (ranges != null) {
            if (asciiRange) {
                CClassNode ccWork = new CClassNode();
                ccWork.addCTypeByRange(ctype, not, env, sbOut.value, ranges);
                if (not) {
                    ccWork.addCodeRangeToBuf(env, 128, Integer.MAX_VALUE, false);
                } else {
                    CClassNode ccAscii = new CClassNode();
                    if (enc.minLength() > 1) {
                        ccAscii.addCodeRangeToBuf(env, 0, 127);
                    } else {
                        ccAscii.bs.setRange(env, 0, 127);
                    }
                    ccWork.and(ccAscii, env);
                }
                this.or(ccWork, env);
            } else {
                this.addCTypeByRange(ctype, not, env, sbOut.value, ranges);
            }
            return;
        }
        int maxCode = asciiRange ? 128 : 256;
        switch (ctype) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: {
                if (not) {
                    for (int c = 0; c < 256; ++c) {
                        if (enc.isCodeCType(c, ctype)) continue;
                        this.bs.set(env, c);
                    }
                    this.addAllMultiByteRange(env);
                    break;
                }
                for (int c = 0; c < 256; ++c) {
                    if (!enc.isCodeCType(c, ctype)) continue;
                    this.bs.set(env, c);
                }
                break;
            }
            case 5: 
            case 7: {
                if (not) {
                    for (int c = 0; c < 256; ++c) {
                        if (enc.isCodeCType(c, ctype) && c < maxCode) continue;
                        this.bs.set(env, c);
                    }
                    if (!asciiRange) break;
                    this.addAllMultiByteRange(env);
                    break;
                }
                for (int c = 0; c < maxCode; ++c) {
                    if (!enc.isCodeCType(c, ctype)) continue;
                    this.bs.set(env, c);
                }
                if (asciiRange) break;
                this.addAllMultiByteRange(env);
                break;
            }
            case 12: {
                if (!not) {
                    for (int c = 0; c < maxCode; ++c) {
                        if (!enc.isSbWord(c)) continue;
                        this.bs.set(env, c);
                    }
                    if (asciiRange) break;
                    this.addAllMultiByteRange(env);
                    break;
                }
                for (int c = 0; c < 256; ++c) {
                    if (enc.codeToMbcLength(c) <= 0 || enc.isWord(c) || c >= maxCode) continue;
                    this.bs.set(env, c);
                }
                if (!asciiRange) break;
                this.addAllMultiByteRange(env);
                break;
            }
            default: {
                throw new InternalException("internal parser error (bug)");
            }
        }
    }

    public void nextStateClass(CCStateArg arg, CClassNode ascCC, ScanEnvironment env) {
        if (arg.state == CCSTATE.RANGE) {
            throw new SyntaxException("char-class value at end of range");
        }
        if (arg.state == CCSTATE.VALUE && arg.type != CCVALTYPE.CLASS) {
            if (arg.type == CCVALTYPE.SB) {
                this.bs.set(env, arg.from);
                if (ascCC != null) {
                    ascCC.bs.set(arg.from);
                }
            } else if (arg.type == CCVALTYPE.CODE_POINT) {
                this.addCodeRange(env, arg.from, arg.from);
                if (ascCC != null) {
                    ascCC.addCodeRange(env, arg.from, arg.from, false);
                }
            }
        }
        arg.state = CCSTATE.VALUE;
        arg.type = CCVALTYPE.CLASS;
    }

    public void nextStateValue(CCStateArg arg, CClassNode ascCc, ScanEnvironment env) {
        switch (arg.state) {
            case VALUE: {
                if (arg.type == CCVALTYPE.SB) {
                    this.bs.set(env, arg.from);
                    if (ascCc == null) break;
                    ascCc.bs.set(arg.from);
                    break;
                }
                if (arg.type != CCVALTYPE.CODE_POINT) break;
                this.addCodeRange(env, arg.from, arg.from);
                if (ascCc == null) break;
                ascCc.addCodeRange(env, arg.from, arg.from, false);
                break;
            }
            case RANGE: {
                if (arg.inType == arg.type) {
                    if (arg.inType == CCVALTYPE.SB) {
                        if (arg.from > 255 || arg.to > 255) {
                            throw new ValueException("invalid code point value");
                        }
                        if (arg.from > arg.to) {
                            if (env.syntax.allowEmptyRangeInCC()) {
                                arg.state = CCSTATE.COMPLETE;
                                break;
                            }
                            throw new ValueException("empty range in char class");
                        }
                        this.bs.setRange(env, arg.from, arg.to);
                        if (ascCc != null) {
                            ascCc.bs.setRange(null, arg.from, arg.to);
                        }
                    } else {
                        this.addCodeRange(env, arg.from, arg.to);
                        if (ascCc != null) {
                            ascCc.addCodeRange(env, arg.from, arg.to, false);
                        }
                    }
                } else {
                    if (arg.from > arg.to) {
                        if (env.syntax.allowEmptyRangeInCC()) {
                            arg.state = CCSTATE.COMPLETE;
                            break;
                        }
                        throw new ValueException("empty range in char class");
                    }
                    this.bs.setRange(env, arg.from, arg.to < 255 ? arg.to : 255);
                    this.addCodeRange(env, arg.from, arg.to);
                    if (ascCc != null) {
                        ascCc.bs.setRange(null, arg.from, arg.to < 255 ? arg.to : 255);
                        ascCc.addCodeRange(env, arg.from, arg.to, false);
                    }
                }
                arg.state = CCSTATE.COMPLETE;
                break;
            }
            case COMPLETE: 
            case START: {
                arg.state = CCSTATE.VALUE;
                break;
            }
        }
        arg.fromIsRaw = arg.toIsRaw;
        arg.from = arg.to;
        arg.type = arg.inType;
    }

    boolean isCodeInCCLength(int encLength, int code) {
        boolean found = encLength > 1 || code >= 256 ? (this.mbuf == null ? false : CodeRange.isInCodeRange(this.mbuf.getCodeRange(), code)) : this.bs.at(code);
        if (this.isNot()) {
            return !found;
        }
        return found;
    }

    public boolean isCodeInCC(Encoding enc, int code) {
        int len = enc.minLength() > 1 ? 2 : enc.codeToMbcLength(code);
        return this.isCodeInCCLength(len, code);
    }

    public void setNot() {
        this.flags |= 1;
    }

    public void clearNot() {
        this.flags &= 0xFFFFFFFE;
    }

    public boolean isNot() {
        return (this.flags & 1) != 0;
    }

    public static final class CCStateArg {
        public int from;
        public int to;
        public boolean fromIsRaw;
        public boolean toIsRaw;
        public CCVALTYPE inType;
        public CCVALTYPE type;
        public CCSTATE state;
    }

    public static enum CCSTATE {
        VALUE,
        RANGE,
        COMPLETE,
        START;

    }

    public static enum CCVALTYPE {
        SB,
        CODE_POINT,
        CLASS;

    }
}

