/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.core;

import java.util.function.Predicate;

public enum RestApiVersion {
    V_9(9),
    V_8(8);

    public final byte major;
    private static final RestApiVersion CURRENT;
    private static final RestApiVersion PREVIOUS;

    private RestApiVersion(int major) {
        this.major = (byte)major;
    }

    public boolean matches(Predicate<RestApiVersion> restApiVersionFunctions) {
        return restApiVersionFunctions.test(this);
    }

    public static RestApiVersion current() {
        return CURRENT;
    }

    public static RestApiVersion previous() {
        return PREVIOUS;
    }

    public static RestApiVersion minimumSupported() {
        return PREVIOUS;
    }

    public static Predicate<RestApiVersion> equalTo(RestApiVersion restApiVersion) {
        return switch (restApiVersion.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> r -> r.major == RestApiVersion.V_9.major;
            case 1 -> r -> r.major == RestApiVersion.V_8.major;
        };
    }

    public static Predicate<RestApiVersion> onOrAfter(RestApiVersion restApiVersion) {
        return switch (restApiVersion.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> r -> r.major >= RestApiVersion.V_9.major;
            case 1 -> r -> r.major >= RestApiVersion.V_8.major;
        };
    }

    public static RestApiVersion forMajor(int major) {
        switch (major) {
            case 8: {
                return V_8;
            }
            case 9: {
                return V_9;
            }
        }
        throw new IllegalArgumentException("Unknown REST API version " + major);
    }

    static {
        CURRENT = V_9;
        PREVIOUS = V_8;
    }
}

