/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.util;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.nio.ByteOrder;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.util.AbstractBigByteArray;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.BigLongArray;
import org.elasticsearch.common.util.IntArray;

final class BigIntArray
extends AbstractBigByteArray
implements IntArray {
    private static final BigIntArray ESTIMATOR = new BigIntArray(0L, BigArrays.NON_RECYCLING_INSTANCE, false);
    static final VarHandle VH_PLATFORM_NATIVE_INT = MethodHandles.byteArrayViewVarHandle(int[].class, ByteOrder.nativeOrder());
    private static final int PAGE_SHIFT = Integer.numberOfTrailingZeros(4096);

    BigIntArray(long size, BigArrays bigArrays, boolean clearOnResize) {
        super(4096, bigArrays, clearOnResize, size);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        BigLongArray.writePages(out, this.size, this.pages, 4);
    }

    @Override
    public int get(long index) {
        int pageIndex = BigIntArray.pageIdx(index);
        int indexInPage = BigIntArray.idxInPage(index);
        return VH_PLATFORM_NATIVE_INT.get(this.pages[pageIndex], indexInPage << 2);
    }

    @Override
    public int getAndSet(long index, int value) {
        int pageIndex = BigIntArray.pageIdx(index);
        int indexInPage = BigIntArray.idxInPage(index);
        byte[] page = this.getPageForWriting(pageIndex);
        int ret = VH_PLATFORM_NATIVE_INT.get(page, indexInPage << 2);
        VH_PLATFORM_NATIVE_INT.set(page, indexInPage << 2, value);
        return ret;
    }

    @Override
    public void set(long index, int value) {
        int pageIndex = BigIntArray.pageIdx(index);
        int indexInPage = BigIntArray.idxInPage(index);
        VH_PLATFORM_NATIVE_INT.set(this.getPageForWriting(pageIndex), indexInPage << 2, value);
    }

    @Override
    public int increment(long index, int inc) {
        int pageIndex = BigIntArray.pageIdx(index);
        int indexInPage = BigIntArray.idxInPage(index);
        byte[] page = this.getPageForWriting(pageIndex);
        int newVal = VH_PLATFORM_NATIVE_INT.get(page, indexInPage << 2) + inc;
        VH_PLATFORM_NATIVE_INT.set(page, indexInPage << 2, newVal);
        return newVal;
    }

    @Override
    public void fill(long fromIndex, long toIndex, int value) {
        int toPage;
        if (fromIndex > toIndex) {
            throw new IllegalArgumentException();
        }
        int fromPage = BigIntArray.pageIdx(fromIndex);
        if (fromPage == (toPage = BigIntArray.pageIdx(toIndex - 1L))) {
            BigIntArray.fill(this.getPageForWriting(fromPage), BigIntArray.idxInPage(fromIndex), BigIntArray.idxInPage(toIndex - 1L) + 1, value);
        } else {
            BigIntArray.fill(this.getPageForWriting(fromPage), BigIntArray.idxInPage(fromIndex), 4096, value);
            for (int i = fromPage + 1; i < toPage; ++i) {
                BigIntArray.fill(this.getPageForWriting(i), 0, 4096, value);
            }
            BigIntArray.fill(this.getPageForWriting(toPage), 0, BigIntArray.idxInPage(toIndex - 1L) + 1, value);
        }
    }

    @Override
    public void fillWith(StreamInput in) throws IOException {
        this.readPages(in);
    }

    public static void fill(byte[] page, int from, int to, int value) {
        if (from < to) {
            VH_PLATFORM_NATIVE_INT.set(page, from << 2, value);
            BigIntArray.fillBySelfCopy(page, from << 2, to << 2, 4);
        }
    }

    @Override
    protected int numBytesPerElement() {
        return 4;
    }

    public static long estimateRamBytes(long size) {
        return ESTIMATOR.ramBytesEstimated(size);
    }

    @Override
    public void set(long index, byte[] buf, int offset, int len) {
        this.set(index, buf, offset, len, 2);
    }

    private static int pageIdx(long index) {
        return (int)(index >>> PAGE_SHIFT);
    }

    private static int idxInPage(long index) {
        return (int)(index & 0xFFFL);
    }
}

