/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.settings;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.elasticsearch.common.hash.MessageDigests;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.settings.SecureSettings;
import org.elasticsearch.common.settings.SecureString;

public class SecureClusterStateSettings
implements SecureSettings {
    private final Map<String, Entry> secrets;

    public SecureClusterStateSettings(SecureSettings secureSettings) {
        this.secrets = new HashMap<String, Entry>();
        for (String key : secureSettings.getSettingNames()) {
            try {
                this.secrets.put(key, new Entry(SecureClusterStateSettings.getValueAsByteArray(secureSettings, key), SecureClusterStateSettings.getSHA256Digest(secureSettings, key)));
            }
            catch (IOException | GeneralSecurityException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public SecureClusterStateSettings(Map<String, byte[]> settings) {
        this.secrets = settings.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> new Entry((byte[])entry.getValue(), MessageDigests.sha256().digest((byte[])entry.getValue()))));
    }

    SecureClusterStateSettings(StreamInput in) throws IOException {
        this.secrets = in.readMap(StreamInput::readString, v -> new Entry(in.readByteArray(), in.readByteArray()));
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeMap(this.secrets, StreamOutput::writeString, (o, v) -> v.writeTo(o));
    }

    @Override
    public boolean isLoaded() {
        return true;
    }

    @Override
    public Set<String> getSettingNames() {
        return this.secrets.keySet();
    }

    @Override
    public SecureString getString(String setting) {
        Entry value = this.secrets.get(setting);
        if (value == null) {
            return null;
        }
        ByteBuffer byteBuffer = ByteBuffer.wrap(value.secret());
        CharBuffer charBuffer = StandardCharsets.UTF_8.decode(byteBuffer);
        return new SecureString(Arrays.copyOfRange(charBuffer.array(), charBuffer.position(), charBuffer.limit()));
    }

    @Override
    public InputStream getFile(String setting) {
        Entry value = this.secrets.get(setting);
        if (value == null) {
            return null;
        }
        return new ByteArrayInputStream(value.secret());
    }

    @Override
    public byte[] getSHA256Digest(String setting) {
        return this.secrets.get(setting).sha256Digest();
    }

    @Override
    public void close() {
        if (null != this.secrets && !this.secrets.isEmpty()) {
            for (Map.Entry<String, Entry> entry : this.secrets.entrySet()) {
                entry.setValue(null);
            }
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SecureClusterStateSettings secrets1 = (SecureClusterStateSettings)o;
        return Objects.equals(this.secrets, secrets1.secrets);
    }

    public int hashCode() {
        return Objects.hash(this.secrets);
    }

    private static byte[] getValueAsByteArray(SecureSettings secureSettings, String key) throws GeneralSecurityException, IOException {
        return secureSettings.getFile(key).readAllBytes();
    }

    private static byte[] getSHA256Digest(SecureSettings secureSettings, String key) {
        try {
            return secureSettings.getSHA256Digest(key);
        }
        catch (GeneralSecurityException e) {
            throw new RuntimeException(e);
        }
    }

    record Entry(byte[] secret, byte[] sha256Digest) implements Writeable
    {
        Entry(StreamInput in) throws IOException {
            this(in.readByteArray(), in.readByteArray());
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Entry entry = (Entry)o;
            return Arrays.equals(this.secret, entry.secret) && Arrays.equals(this.sha256Digest, entry.sha256Digest);
        }

        @Override
        public int hashCode() {
            int result = Arrays.hashCode(this.secret);
            result = 31 * result + Arrays.hashCode(this.sha256Digest);
            return result;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeByteArray(this.secret);
            out.writeByteArray(this.sha256Digest);
        }
    }
}

