/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.xcontent.XContentBuilder;

public final class FieldMemoryStats
implements Writeable,
Iterable<Map.Entry<String, Long>> {
    private final Map<String, Long> stats;

    public FieldMemoryStats(Map<String, Long> stats) {
        this.stats = Objects.requireNonNull(stats, "status must be non-null");
        assert (!stats.containsKey(null));
    }

    public FieldMemoryStats(StreamInput input) throws IOException {
        this.stats = input.readMap(StreamInput::readVLong);
    }

    public void add(FieldMemoryStats fieldMemoryStats) {
        for (Map.Entry<String, Long> entry : fieldMemoryStats.stats.entrySet()) {
            this.stats.merge(entry.getKey(), entry.getValue(), Long::sum);
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeMap(this.stats, StreamOutput::writeVLong);
    }

    public void toXContent(XContentBuilder builder, String key, String rawKey, String readableKey) throws IOException {
        builder.startObject(key);
        for (Map.Entry<String, Long> entry : this.stats.entrySet()) {
            builder.startObject(entry.getKey());
            builder.humanReadableField(rawKey, readableKey, ByteSizeValue.ofBytes(entry.getValue()));
            builder.endObject();
        }
        builder.endObject();
    }

    public FieldMemoryStats copy() {
        return new FieldMemoryStats(new HashMap<String, Long>(this.stats));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FieldMemoryStats that = (FieldMemoryStats)o;
        return Objects.equals(this.stats, that.stats);
    }

    public int hashCode() {
        return Objects.hash(this.stats);
    }

    @Override
    public Iterator<Map.Entry<String, Long>> iterator() {
        return this.stats.entrySet().iterator();
    }

    public long get(String field) {
        return this.stats.getOrDefault(field, 0L);
    }

    public boolean containsField(String field) {
        return this.stats.containsKey(field);
    }
}

