/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.internal.support;

import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionFuture;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.DocWriteResponse;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkRequestBuilder;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.bulk.TransportBulkAction;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.delete.DeleteRequestBuilder;
import org.elasticsearch.action.delete.DeleteResponse;
import org.elasticsearch.action.delete.TransportDeleteAction;
import org.elasticsearch.action.explain.ExplainRequest;
import org.elasticsearch.action.explain.ExplainRequestBuilder;
import org.elasticsearch.action.explain.ExplainResponse;
import org.elasticsearch.action.explain.TransportExplainAction;
import org.elasticsearch.action.fieldcaps.FieldCapabilitiesRequest;
import org.elasticsearch.action.fieldcaps.FieldCapabilitiesRequestBuilder;
import org.elasticsearch.action.fieldcaps.FieldCapabilitiesResponse;
import org.elasticsearch.action.fieldcaps.TransportFieldCapabilitiesAction;
import org.elasticsearch.action.get.GetRequest;
import org.elasticsearch.action.get.GetRequestBuilder;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.get.MultiGetRequest;
import org.elasticsearch.action.get.MultiGetRequestBuilder;
import org.elasticsearch.action.get.MultiGetResponse;
import org.elasticsearch.action.get.TransportGetAction;
import org.elasticsearch.action.get.TransportMultiGetAction;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.index.IndexRequestBuilder;
import org.elasticsearch.action.index.TransportIndexAction;
import org.elasticsearch.action.search.ClearScrollRequest;
import org.elasticsearch.action.search.ClearScrollRequestBuilder;
import org.elasticsearch.action.search.ClearScrollResponse;
import org.elasticsearch.action.search.MultiSearchRequest;
import org.elasticsearch.action.search.MultiSearchRequestBuilder;
import org.elasticsearch.action.search.MultiSearchResponse;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.SearchScrollRequest;
import org.elasticsearch.action.search.SearchScrollRequestBuilder;
import org.elasticsearch.action.search.TransportClearScrollAction;
import org.elasticsearch.action.search.TransportMultiSearchAction;
import org.elasticsearch.action.search.TransportSearchAction;
import org.elasticsearch.action.search.TransportSearchScrollAction;
import org.elasticsearch.action.support.UnsafePlainActionFuture;
import org.elasticsearch.action.termvectors.MultiTermVectorsAction;
import org.elasticsearch.action.termvectors.MultiTermVectorsRequest;
import org.elasticsearch.action.termvectors.MultiTermVectorsRequestBuilder;
import org.elasticsearch.action.termvectors.MultiTermVectorsResponse;
import org.elasticsearch.action.termvectors.TermVectorsAction;
import org.elasticsearch.action.termvectors.TermVectorsRequest;
import org.elasticsearch.action.termvectors.TermVectorsRequestBuilder;
import org.elasticsearch.action.termvectors.TermVectorsResponse;
import org.elasticsearch.action.update.TransportUpdateAction;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.action.update.UpdateRequestBuilder;
import org.elasticsearch.action.update.UpdateResponse;
import org.elasticsearch.client.internal.AdminClient;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.client.internal.ElasticsearchClient;
import org.elasticsearch.client.internal.FilterClient;
import org.elasticsearch.cluster.metadata.ProjectId;
import org.elasticsearch.cluster.project.ProjectResolver;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.RefCounted;
import org.elasticsearch.threadpool.ThreadPool;

public abstract class AbstractClient
implements Client {
    protected final Logger logger;
    protected final Settings settings;
    private final ThreadPool threadPool;
    private final ProjectResolver projectResolver;
    private final AdminClient admin;

    public AbstractClient(Settings settings, ThreadPool threadPool, ProjectResolver projectResolver) {
        this.settings = settings;
        this.threadPool = threadPool;
        this.projectResolver = projectResolver;
        this.admin = new AdminClient(this);
        this.logger = LogManager.getLogger(this.getClass());
    }

    @Override
    public final Settings settings() {
        return this.settings;
    }

    @Override
    public final ThreadPool threadPool() {
        return this.threadPool;
    }

    @Override
    public ProjectResolver projectResolver() {
        return this.projectResolver;
    }

    @Override
    public final AdminClient admin() {
        return this.admin;
    }

    @Override
    public final <Request extends ActionRequest, Response extends ActionResponse> ActionFuture<Response> execute(ActionType<Response> action, Request request) {
        RefCountedFuture actionFuture = new RefCountedFuture();
        this.execute(action, request, actionFuture);
        return actionFuture;
    }

    @Override
    public final <Request extends ActionRequest, Response extends ActionResponse> void execute(ActionType<Response> action, Request request, ActionListener<Response> listener) {
        try {
            this.doExecute(action, request, listener);
        }
        catch (Exception e) {
            assert (false) : new AssertionError((Object)e);
            listener.onFailure(e);
        }
    }

    protected abstract <Request extends ActionRequest, Response extends ActionResponse> void doExecute(ActionType<Response> var1, Request var2, ActionListener<Response> var3);

    @Override
    public ActionFuture<DocWriteResponse> index(IndexRequest request) {
        return this.execute(TransportIndexAction.TYPE, request);
    }

    @Override
    public void index(IndexRequest request, ActionListener<DocWriteResponse> listener) {
        this.execute(TransportIndexAction.TYPE, request, listener);
    }

    @Override
    public IndexRequestBuilder prepareIndex() {
        return new IndexRequestBuilder((ElasticsearchClient)this, null);
    }

    @Override
    public IndexRequestBuilder prepareIndex(String index) {
        return new IndexRequestBuilder((ElasticsearchClient)this, index);
    }

    @Override
    public ActionFuture<UpdateResponse> update(UpdateRequest request) {
        return this.execute(TransportUpdateAction.TYPE, request);
    }

    @Override
    public void update(UpdateRequest request, ActionListener<UpdateResponse> listener) {
        this.execute(TransportUpdateAction.TYPE, request, listener);
    }

    @Override
    public UpdateRequestBuilder prepareUpdate() {
        return new UpdateRequestBuilder(this, null, null);
    }

    @Override
    public UpdateRequestBuilder prepareUpdate(String index, String id) {
        return new UpdateRequestBuilder(this, index, id);
    }

    @Override
    public ActionFuture<DeleteResponse> delete(DeleteRequest request) {
        return this.execute(TransportDeleteAction.TYPE, request);
    }

    @Override
    public void delete(DeleteRequest request, ActionListener<DeleteResponse> listener) {
        this.execute(TransportDeleteAction.TYPE, request, listener);
    }

    @Override
    public DeleteRequestBuilder prepareDelete() {
        return new DeleteRequestBuilder((ElasticsearchClient)this, null);
    }

    @Override
    public DeleteRequestBuilder prepareDelete(String index, String id) {
        return ((DeleteRequestBuilder)this.prepareDelete().setIndex(index)).setId(id);
    }

    @Override
    public ActionFuture<BulkResponse> bulk(BulkRequest request) {
        return this.execute(TransportBulkAction.TYPE, request);
    }

    @Override
    public void bulk(BulkRequest request, ActionListener<BulkResponse> listener) {
        this.execute(TransportBulkAction.TYPE, request, listener);
    }

    @Override
    public BulkRequestBuilder prepareBulk() {
        return new BulkRequestBuilder(this);
    }

    @Override
    public BulkRequestBuilder prepareBulk(@Nullable String globalIndex) {
        return new BulkRequestBuilder((ElasticsearchClient)this, globalIndex);
    }

    @Override
    public ActionFuture<GetResponse> get(GetRequest request) {
        return this.execute(TransportGetAction.TYPE, request);
    }

    @Override
    public void get(GetRequest request, ActionListener<GetResponse> listener) {
        this.execute(TransportGetAction.TYPE, request, listener);
    }

    @Override
    public GetRequestBuilder prepareGet() {
        return new GetRequestBuilder(this, null);
    }

    @Override
    public GetRequestBuilder prepareGet(String index, String id) {
        return ((GetRequestBuilder)this.prepareGet().setIndex(index)).setId(id);
    }

    @Override
    public ActionFuture<MultiGetResponse> multiGet(MultiGetRequest request) {
        return this.execute(TransportMultiGetAction.TYPE, request);
    }

    @Override
    public void multiGet(MultiGetRequest request, ActionListener<MultiGetResponse> listener) {
        this.execute(TransportMultiGetAction.TYPE, request, listener);
    }

    @Override
    public MultiGetRequestBuilder prepareMultiGet() {
        return new MultiGetRequestBuilder(this);
    }

    @Override
    public ActionFuture<SearchResponse> search(SearchRequest request) {
        return this.execute(TransportSearchAction.TYPE, request);
    }

    @Override
    public void search(SearchRequest request, ActionListener<SearchResponse> listener) {
        this.execute(TransportSearchAction.TYPE, request, listener);
    }

    @Override
    public SearchRequestBuilder prepareSearch(String ... indices) {
        return new SearchRequestBuilder(this).setIndices(indices);
    }

    @Override
    public ActionFuture<SearchResponse> searchScroll(SearchScrollRequest request) {
        return this.execute(TransportSearchScrollAction.TYPE, request);
    }

    @Override
    public void searchScroll(SearchScrollRequest request, ActionListener<SearchResponse> listener) {
        this.execute(TransportSearchScrollAction.TYPE, request, listener);
    }

    @Override
    public SearchScrollRequestBuilder prepareSearchScroll(String scrollId) {
        return new SearchScrollRequestBuilder(this, scrollId);
    }

    @Override
    public ActionFuture<MultiSearchResponse> multiSearch(MultiSearchRequest request) {
        return this.execute(TransportMultiSearchAction.TYPE, request);
    }

    @Override
    public void multiSearch(MultiSearchRequest request, ActionListener<MultiSearchResponse> listener) {
        this.execute(TransportMultiSearchAction.TYPE, request, listener);
    }

    @Override
    public MultiSearchRequestBuilder prepareMultiSearch() {
        return new MultiSearchRequestBuilder(this);
    }

    @Override
    public ActionFuture<TermVectorsResponse> termVectors(TermVectorsRequest request) {
        return this.execute(TermVectorsAction.INSTANCE, request);
    }

    @Override
    public void termVectors(TermVectorsRequest request, ActionListener<TermVectorsResponse> listener) {
        this.execute(TermVectorsAction.INSTANCE, request, listener);
    }

    @Override
    public TermVectorsRequestBuilder prepareTermVectors() {
        return new TermVectorsRequestBuilder(this);
    }

    @Override
    public TermVectorsRequestBuilder prepareTermVectors(String index, String id) {
        return new TermVectorsRequestBuilder((ElasticsearchClient)this, index, id);
    }

    @Override
    public ActionFuture<MultiTermVectorsResponse> multiTermVectors(MultiTermVectorsRequest request) {
        return this.execute(MultiTermVectorsAction.INSTANCE, request);
    }

    @Override
    public void multiTermVectors(MultiTermVectorsRequest request, ActionListener<MultiTermVectorsResponse> listener) {
        this.execute(MultiTermVectorsAction.INSTANCE, request, listener);
    }

    @Override
    public MultiTermVectorsRequestBuilder prepareMultiTermVectors() {
        return new MultiTermVectorsRequestBuilder(this);
    }

    @Override
    public ExplainRequestBuilder prepareExplain(String index, String id) {
        return new ExplainRequestBuilder((ElasticsearchClient)this, index, id);
    }

    @Override
    public ActionFuture<ExplainResponse> explain(ExplainRequest request) {
        return this.execute(TransportExplainAction.TYPE, request);
    }

    @Override
    public void explain(ExplainRequest request, ActionListener<ExplainResponse> listener) {
        this.execute(TransportExplainAction.TYPE, request, listener);
    }

    @Override
    public void clearScroll(ClearScrollRequest request, ActionListener<ClearScrollResponse> listener) {
        this.execute(TransportClearScrollAction.TYPE, request, listener);
    }

    @Override
    public ActionFuture<ClearScrollResponse> clearScroll(ClearScrollRequest request) {
        return this.execute(TransportClearScrollAction.TYPE, request);
    }

    @Override
    public ClearScrollRequestBuilder prepareClearScroll() {
        return new ClearScrollRequestBuilder(this);
    }

    @Override
    public void fieldCaps(FieldCapabilitiesRequest request, ActionListener<FieldCapabilitiesResponse> listener) {
        this.execute(TransportFieldCapabilitiesAction.TYPE, request, listener);
    }

    @Override
    public ActionFuture<FieldCapabilitiesResponse> fieldCaps(FieldCapabilitiesRequest request) {
        return this.execute(TransportFieldCapabilitiesAction.TYPE, request);
    }

    @Override
    public FieldCapabilitiesRequestBuilder prepareFieldCaps(String ... indices) {
        return new FieldCapabilitiesRequestBuilder((ElasticsearchClient)this, indices);
    }

    @Override
    public Client filterWithHeader(final Map<String, String> headers) {
        return new FilterClient(this, this){

            @Override
            protected <Request extends ActionRequest, Response extends ActionResponse> void doExecute(ActionType<Response> action, Request request, ActionListener<Response> listener) {
                ThreadContext threadContext = this.threadPool().getThreadContext();
                try (ThreadContext.StoredContext ctx = threadContext.stashAndMergeHeaders(headers);){
                    super.doExecute(action, request, listener);
                }
            }
        };
    }

    @Override
    public Client projectClient(final ProjectId projectId) {
        if (!this.projectResolver.supportsMultipleProjects() && projectId.equals(this.projectResolver.getProjectId())) {
            return this;
        }
        return new FilterClient(this){

            @Override
            protected <Request extends ActionRequest, Response extends ActionResponse> void doExecute(ActionType<Response> action, Request request, ActionListener<Response> listener) {
                AbstractClient.this.projectResolver.executeOnProject(projectId, () -> super.doExecute(action, request, listener));
            }

            @Override
            public Client projectClient(ProjectId projectId2) {
                throw new IllegalStateException("Unable to create a project client for project [" + String.valueOf(projectId2) + "], nested project client creation is not supported");
            }
        };
    }

    private static class RefCountedFuture<R extends RefCounted>
    extends UnsafePlainActionFuture<R> {
        private final AtomicBoolean getCalled = new AtomicBoolean(false);

        private RefCountedFuture() {
            super("generic");
        }

        @Override
        public final void onResponse(R result) {
            result.mustIncRef();
            if (!this.set(result)) {
                result.decRef();
            }
        }

        @Override
        public R get() throws InterruptedException, ExecutionException {
            boolean firstCall = this.getCalled.compareAndSet(false, true);
            if (!firstCall) {
                IllegalStateException ise = new IllegalStateException("must only call .get() once per instance to avoid leaks");
                assert (false) : ise;
                throw ise;
            }
            return (R)((RefCounted)super.get());
        }
    }
}

