/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.support;

import java.io.IOException;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.ProjectMetadata;
import org.elasticsearch.cluster.routing.IndexRoutingTable;
import org.elasticsearch.cluster.routing.IndexShardRoutingTable;
import org.elasticsearch.cluster.routing.RoutingTable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.core.Nullable;

public record ActiveShardCount(int value) implements Writeable
{
    private static final int ACTIVE_SHARD_COUNT_DEFAULT = -2;
    private static final int ALL_ACTIVE_SHARDS = -1;
    public static final ActiveShardCount DEFAULT = new ActiveShardCount(-2);
    public static final ActiveShardCount ALL = new ActiveShardCount(-1);
    public static final ActiveShardCount NONE = new ActiveShardCount(0);
    public static final ActiveShardCount ONE = new ActiveShardCount(1);

    public static ActiveShardCount from(int value) {
        if (value < 0) {
            throw new IllegalArgumentException("shard count cannot be a negative value");
        }
        return ActiveShardCount.get(value);
    }

    public boolean validate(int numberOfReplicas) {
        assert (numberOfReplicas >= 0);
        return this.value <= numberOfReplicas + 1;
    }

    private static ActiveShardCount get(int value) {
        switch (value) {
            case -2: {
                return DEFAULT;
            }
            case -1: {
                return ALL;
            }
            case 1: {
                return ONE;
            }
            case 0: {
                return NONE;
            }
        }
        assert (value > 1);
        return new ActiveShardCount(value);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeInt(this.value);
    }

    public static ActiveShardCount readFrom(StreamInput in) throws IOException {
        return ActiveShardCount.get(in.readInt());
    }

    public static ActiveShardCount parseString(String str) {
        int val;
        if (str == null) {
            return DEFAULT;
        }
        if (str.equals("all")) {
            return ALL;
        }
        try {
            val = Integer.parseInt(str);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("cannot parse ActiveShardCount[" + str + "]", e);
        }
        return ActiveShardCount.from(val);
    }

    public boolean enoughShardsActive(int activeShardCount) {
        if (this.value < 0) {
            throw new IllegalStateException("not enough information to resolve to shard count");
        }
        if (activeShardCount < 0) {
            throw new IllegalArgumentException("activeShardCount cannot be negative");
        }
        return this.value <= activeShardCount;
    }

    public boolean enoughShardsActive(@Nullable ProjectMetadata projectMetadata, @Nullable RoutingTable routingTable, String ... indices) {
        if (this == NONE) {
            return true;
        }
        if (projectMetadata == null || routingTable == null) {
            return true;
        }
        for (String indexName : indices) {
            IndexRoutingTable indexRoutingTable;
            IndexMetadata indexMetadata = projectMetadata.index(indexName);
            if (indexMetadata == null || (indexRoutingTable = routingTable.index(indexName)) == null && indexMetadata.getState() == IndexMetadata.State.CLOSE) continue;
            assert (indexRoutingTable != null);
            if (!indexRoutingTable.allPrimaryShardsActive()) {
                return false;
            }
            ActiveShardCount waitForActiveShards = this;
            if (waitForActiveShards == DEFAULT) {
                waitForActiveShards = IndexMetadata.SETTING_WAIT_FOR_ACTIVE_SHARDS.get(indexMetadata.getSettings());
            }
            for (int i = 0; i < indexRoutingTable.size(); ++i) {
                if (waitForActiveShards.enoughShardsActive(indexRoutingTable.shard(i)).enoughShards()) continue;
                return false;
            }
        }
        return true;
    }

    public EnoughShards enoughShardsActive(IndexShardRoutingTable shardRoutingTable) {
        int activeShardCount = shardRoutingTable.activeShards().size();
        boolean enoughShards = false;
        int currentActiveShards = activeShardCount;
        if (this == ALL) {
            enoughShards = activeShardCount == shardRoutingTable.size();
        } else if (this.value == 0) {
            enoughShards = true;
        } else if (this.value == 1) {
            if (shardRoutingTable.hasSearchShards()) {
                enoughShards = shardRoutingTable.getActiveSearchShardCount() >= 1;
                currentActiveShards = shardRoutingTable.getActiveSearchShardCount();
            } else {
                enoughShards = activeShardCount >= 1;
            }
        } else {
            enoughShards = shardRoutingTable.getActiveSearchShardCount() >= this.value;
            currentActiveShards = shardRoutingTable.getActiveSearchShardCount();
        }
        return new EnoughShards(enoughShards, currentActiveShards);
    }

    @Override
    public String toString() {
        return switch (this.value) {
            case -1 -> "ALL";
            case -2 -> "DEFAULT";
            default -> Integer.toString(this.value);
        };
    }

    public record EnoughShards(boolean enoughShards, int currentActiveShards) {
    }
}

