/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.controls;

import com.unboundid.asn1.ASN1Element;
import com.unboundid.asn1.ASN1Sequence;
import com.unboundid.ldap.matchingrules.BooleanMatchingRule;
import com.unboundid.ldap.matchingrules.MatchingRule;
import com.unboundid.ldap.matchingrules.OctetStringMatchingRule;
import com.unboundid.ldap.sdk.AddRequest;
import com.unboundid.ldap.sdk.Attribute;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.Modification;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.unboundidds.controls.ControlMessages;
import com.unboundid.ldif.LDIFModifyChangeRecord;
import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.util.ArrayList;
import java.util.List;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class UndeleteRequestControl
extends Control {
    @NotNull
    public static final String UNDELETE_REQUEST_OID = "1.3.6.1.4.1.30221.2.5.23";
    @NotNull
    public static final String ATTR_CHANGES = "ds-undelete-changes";
    @NotNull
    public static final String ATTR_DISABLE_ACCOUNT = "ds-undelete-disable-account";
    @NotNull
    public static final String ATTR_MUST_CHANGE_PASSWORD = "ds-undelete-must-change-password";
    @NotNull
    public static final String ATTR_NEW_PASSWORD = "ds-undelete-new-password";
    @NotNull
    public static final String ATTR_OLD_PASSWORD = "ds-undelete-old-password";
    @NotNull
    public static final String ATTR_SOFT_DELETED_ENTRY_DN = "ds-undelete-from-dn";
    private static final long serialVersionUID = 5338045977962112876L;

    public UndeleteRequestControl() {
        super(UNDELETE_REQUEST_OID, true, null);
    }

    public UndeleteRequestControl(@NotNull Control control) throws LDAPException {
        super(control);
        if (control.hasValue()) {
            try {
                ASN1Sequence valueSequence = ASN1Sequence.decodeAsSequence(control.getValue().getValue());
                ASN1Element[] elements = valueSequence.elements();
                if (elements.length > 0) {
                    throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_UNDELETE_REQUEST_UNSUPPORTED_VALUE_ELEMENT_TYPE.get(StaticUtils.toHex(elements[0].getType())));
                }
            }
            catch (LDAPException le) {
                Debug.debugException(le);
                throw le;
            }
            catch (Exception e) {
                Debug.debugException(e);
                throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_UNDELETE_REQUEST_CANNOT_DECODE_VALUE.get(StaticUtils.getExceptionMessage(e)), e);
            }
        }
    }

    @NotNull
    public static AddRequest createUndeleteRequest(@NotNull String targetDN, @NotNull String softDeletedEntryDN) {
        return UndeleteRequestControl.createUndeleteRequest(targetDN, softDeletedEntryDN, null, null, null, null, null);
    }

    @NotNull
    public static AddRequest createUndeleteRequest(@NotNull String targetDN, @NotNull String softDeletedEntryDN, @Nullable List<Modification> changes, @Nullable String oldPassword, @Nullable String newPassword, @Nullable Boolean mustChangePassword, @Nullable Boolean disableAccount) {
        ArrayList<Attribute> attributes = new ArrayList<Attribute>(6);
        attributes.add(new Attribute(ATTR_SOFT_DELETED_ENTRY_DN, softDeletedEntryDN));
        if (changes != null && !changes.isEmpty()) {
            LDIFModifyChangeRecord changeRecord = new LDIFModifyChangeRecord(targetDN, changes);
            String[] modLdifLines = changeRecord.toLDIF(0);
            StringBuilder modLDIFBuffer = new StringBuilder();
            for (int i = 2; i < modLdifLines.length; ++i) {
                modLDIFBuffer.append(modLdifLines[i]);
                modLDIFBuffer.append(StaticUtils.EOL);
            }
            attributes.add(new Attribute(ATTR_CHANGES, (MatchingRule)OctetStringMatchingRule.getInstance(), modLDIFBuffer.toString()));
        }
        if (oldPassword != null) {
            attributes.add(new Attribute(ATTR_OLD_PASSWORD, (MatchingRule)OctetStringMatchingRule.getInstance(), oldPassword));
        }
        if (newPassword != null) {
            attributes.add(new Attribute(ATTR_NEW_PASSWORD, (MatchingRule)OctetStringMatchingRule.getInstance(), newPassword));
        }
        if (mustChangePassword != null) {
            attributes.add(new Attribute(ATTR_MUST_CHANGE_PASSWORD, (MatchingRule)BooleanMatchingRule.getInstance(), mustChangePassword != false ? "true" : "false"));
        }
        if (disableAccount != null) {
            attributes.add(new Attribute(ATTR_DISABLE_ACCOUNT, (MatchingRule)BooleanMatchingRule.getInstance(), disableAccount != false ? "true" : "false"));
        }
        Control[] controls = new Control[]{new UndeleteRequestControl()};
        return new AddRequest(targetDN, attributes, controls);
    }

    @Override
    @NotNull
    public String getControlName() {
        return ControlMessages.INFO_CONTROL_NAME_UNDELETE_REQUEST.get();
    }

    @Override
    public void toString(@NotNull StringBuilder buffer) {
        buffer.append("UndeleteRequestControl(isCritical=");
        buffer.append(this.isCritical());
        buffer.append(')');
    }
}

