/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.tools.optional;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import org.apache.derby.iapi.sql.dictionary.OptionalTool;

public class DBMDWrapper
implements OptionalTool {
    private static final int DEFAULT_PRECISION = 128;

    public void loadTool(String ... configurationParameters) throws SQLException {
        this.register(true);
    }

    public void unloadTool(String ... configurationParameters) throws SQLException {
        this.register(false);
    }

    private void register(boolean register) throws SQLException {
        Connection conn = DBMDWrapper.getDefaultConnection();
        for (Method method : this.getClass().getDeclaredMethods()) {
            int modifiers = method.getModifiers();
            if (!this.isSet(modifiers, 1) || !this.isSet(modifiers, 8)) continue;
            if (register) {
                this.registerFunction(conn, method);
                continue;
            }
            this.unregisterFunction(conn, method);
        }
    }

    public static boolean allProceduresAreCallable() throws SQLException {
        return DBMDWrapper.getDBMD().allProceduresAreCallable();
    }

    public static boolean allTablesAreSelectable() throws SQLException {
        return DBMDWrapper.getDBMD().allTablesAreSelectable();
    }

    public static boolean autoCommitFailureClosesAllResultSets() throws SQLException {
        return DBMDWrapper.getDBMD().autoCommitFailureClosesAllResultSets();
    }

    public static boolean dataDefinitionCausesTransactionCommit() throws SQLException {
        return DBMDWrapper.getDBMD().dataDefinitionCausesTransactionCommit();
    }

    public static boolean dataDefinitionIgnoredInTransactions() throws SQLException {
        return DBMDWrapper.getDBMD().dataDefinitionIgnoredInTransactions();
    }

    public static boolean deletesAreDetected(int type) throws SQLException {
        return DBMDWrapper.getDBMD().deletesAreDetected(type);
    }

    public static boolean doesMaxRowSizeIncludeBlobs() throws SQLException {
        return DBMDWrapper.getDBMD().doesMaxRowSizeIncludeBlobs();
    }

    public static ResultSet getAttributes(String catalog, String schemaPattern, String typeNamePattern, String attributeNamePattern) throws SQLException {
        return DBMDWrapper.getDBMD().getAttributes(catalog, schemaPattern, typeNamePattern, attributeNamePattern);
    }

    public static ResultSet getBestRowIdentifier(String catalog, String schema, String table, int scope, boolean nullable) throws SQLException {
        return DBMDWrapper.getDBMD().getBestRowIdentifier(catalog, schema, table, scope, nullable);
    }

    public static ResultSet getCatalogs() throws SQLException {
        return DBMDWrapper.getDBMD().getCatalogs();
    }

    public static String getCatalogSeparator() throws SQLException {
        return DBMDWrapper.getDBMD().getCatalogSeparator();
    }

    public static String getCatalogTerm() throws SQLException {
        return DBMDWrapper.getDBMD().getCatalogTerm();
    }

    public static ResultSet getClientInfoProperties() throws SQLException {
        return DBMDWrapper.getDBMD().getClientInfoProperties();
    }

    public static ResultSet getColumnPrivileges(String catalog, String schema, String table, String columnNamePattern) throws SQLException {
        return DBMDWrapper.getDBMD().getColumnPrivileges(catalog, schema, table, columnNamePattern);
    }

    public static ResultSet getColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        return DBMDWrapper.getDBMD().getColumns(catalog, schemaPattern, tableNamePattern, columnNamePattern);
    }

    public static ResultSet getCrossReference(String parentCatalog, String parentSchema, String parentTable, String foreignCatalog, String foreignSchema, String foreignTable) throws SQLException {
        return DBMDWrapper.getDBMD().getCrossReference(parentCatalog, parentSchema, parentTable, foreignCatalog, foreignSchema, foreignTable);
    }

    public static int getDatabaseMajorVersion() throws SQLException {
        return DBMDWrapper.getDBMD().getDatabaseMajorVersion();
    }

    public static int getDatabaseMinorVersion() throws SQLException {
        return DBMDWrapper.getDBMD().getDatabaseMinorVersion();
    }

    public static String getDatabaseProductName() throws SQLException {
        return DBMDWrapper.getDBMD().getDatabaseProductName();
    }

    public static String getDatabaseProductVersion() throws SQLException {
        return DBMDWrapper.getDBMD().getDatabaseProductVersion();
    }

    public static int getDefaultTransactionIsolation() throws SQLException {
        return DBMDWrapper.getDBMD().getDefaultTransactionIsolation();
    }

    public static int getDriverMajorVersion() throws SQLException {
        return DBMDWrapper.getDBMD().getDriverMajorVersion();
    }

    public static int getDriverMinorVersion() throws SQLException {
        return DBMDWrapper.getDBMD().getDriverMinorVersion();
    }

    public static String getDriverName() throws SQLException {
        return DBMDWrapper.getDBMD().getDriverName();
    }

    public static String getDriverVersion() throws SQLException {
        return DBMDWrapper.getDBMD().getDriverVersion();
    }

    public static ResultSet getExportedKeys(String catalog, String schema, String table) throws SQLException {
        return DBMDWrapper.getDBMD().getExportedKeys(catalog, schema, table);
    }

    public static String getExtraNameCharacters() throws SQLException {
        return DBMDWrapper.getDBMD().getExtraNameCharacters();
    }

    public static ResultSet getFunctionColumns(String catalog, String schemaPattern, String functionNamePattern, String columnNamePattern) throws SQLException {
        return DBMDWrapper.getDBMD().getFunctionColumns(catalog, schemaPattern, functionNamePattern, columnNamePattern);
    }

    public static ResultSet getFunctions(String catalog, String schemaPattern, String functionNamePattern) throws SQLException {
        return DBMDWrapper.getDBMD().getFunctions(catalog, schemaPattern, functionNamePattern);
    }

    public static String getIdentifierQuoteString() throws SQLException {
        return DBMDWrapper.getDBMD().getIdentifierQuoteString();
    }

    public static ResultSet getImportedKeys(String catalog, String schema, String table) throws SQLException {
        return DBMDWrapper.getDBMD().getImportedKeys(catalog, schema, table);
    }

    public static ResultSet getIndexInfo(String catalog, String schema, String table, boolean unique, boolean approximate) throws SQLException {
        return DBMDWrapper.getDBMD().getIndexInfo(catalog, schema, table, unique, approximate);
    }

    public static int getJDBCMajorVersion() throws SQLException {
        return DBMDWrapper.getDBMD().getJDBCMajorVersion();
    }

    public static int getJDBCMinorVersion() throws SQLException {
        return DBMDWrapper.getDBMD().getJDBCMinorVersion();
    }

    public static int getMaxBinaryLiteralLength() throws SQLException {
        return DBMDWrapper.getDBMD().getMaxBinaryLiteralLength();
    }

    public static int getMaxCatalogNameLength() throws SQLException {
        return DBMDWrapper.getDBMD().getMaxCatalogNameLength();
    }

    public static int getMaxCharLiteralLength() throws SQLException {
        return DBMDWrapper.getDBMD().getMaxCharLiteralLength();
    }

    public static int getMaxColumnNameLength() throws SQLException {
        return DBMDWrapper.getDBMD().getMaxColumnNameLength();
    }

    public static int getMaxColumnsInGroupBy() throws SQLException {
        return DBMDWrapper.getDBMD().getMaxColumnsInGroupBy();
    }

    public static int getMaxColumnsInIndex() throws SQLException {
        return DBMDWrapper.getDBMD().getMaxColumnsInIndex();
    }

    public static int getMaxColumnsInOrderBy() throws SQLException {
        return DBMDWrapper.getDBMD().getMaxColumnsInOrderBy();
    }

    public static int getMaxColumnsInSelect() throws SQLException {
        return DBMDWrapper.getDBMD().getMaxColumnsInSelect();
    }

    public static int getMaxColumnsInTable() throws SQLException {
        return DBMDWrapper.getDBMD().getMaxColumnsInTable();
    }

    public static int getMaxConnections() throws SQLException {
        return DBMDWrapper.getDBMD().getMaxConnections();
    }

    public static int getMaxCursorNameLength() throws SQLException {
        return DBMDWrapper.getDBMD().getMaxCursorNameLength();
    }

    public static int getMaxIndexLength() throws SQLException {
        return DBMDWrapper.getDBMD().getMaxIndexLength();
    }

    public static int getMaxProcedureNameLength() throws SQLException {
        return DBMDWrapper.getDBMD().getMaxProcedureNameLength();
    }

    public static int getMaxRowSize() throws SQLException {
        return DBMDWrapper.getDBMD().getMaxRowSize();
    }

    public static int getMaxSchemaNameLength() throws SQLException {
        return DBMDWrapper.getDBMD().getMaxSchemaNameLength();
    }

    public static int getMaxStatementLength() throws SQLException {
        return DBMDWrapper.getDBMD().getMaxStatementLength();
    }

    public static int getMaxStatements() throws SQLException {
        return DBMDWrapper.getDBMD().getMaxStatements();
    }

    public static int getMaxTableNameLength() throws SQLException {
        return DBMDWrapper.getDBMD().getMaxTableNameLength();
    }

    public static int getMaxTablesInSelect() throws SQLException {
        return DBMDWrapper.getDBMD().getMaxTablesInSelect();
    }

    public static int getMaxUserNameLength() throws SQLException {
        return DBMDWrapper.getDBMD().getMaxUserNameLength();
    }

    public static String getNumericFunctions() throws SQLException {
        return DBMDWrapper.getDBMD().getNumericFunctions();
    }

    public static ResultSet getPrimaryKeys(String catalog, String schema, String table) throws SQLException {
        return DBMDWrapper.getDBMD().getPrimaryKeys(catalog, schema, table);
    }

    public static ResultSet getProcedureColumns(String catalog, String schemaPattern, String procedureNamePattern, String columnNamePattern) throws SQLException {
        return DBMDWrapper.getDBMD().getProcedureColumns(catalog, schemaPattern, procedureNamePattern, columnNamePattern);
    }

    public static ResultSet getProcedures(String catalog, String schemaPattern, String procedureNamePattern) throws SQLException {
        return DBMDWrapper.getDBMD().getProcedures(catalog, schemaPattern, procedureNamePattern);
    }

    public static String getProcedureTerm() throws SQLException {
        return DBMDWrapper.getDBMD().getProcedureTerm();
    }

    public static int getResultSetHoldability() throws SQLException {
        return DBMDWrapper.getDBMD().getResultSetHoldability();
    }

    public static ResultSet getSchemas(String catalog, String schemaPattern) throws SQLException {
        return DBMDWrapper.getDBMD().getSchemas(catalog, schemaPattern);
    }

    public static String getSchemaTerm() throws SQLException {
        return DBMDWrapper.getDBMD().getSchemaTerm();
    }

    public static String getSearchStringEscape() throws SQLException {
        return DBMDWrapper.getDBMD().getSearchStringEscape();
    }

    public static String getSQLKeywords() throws SQLException {
        return DBMDWrapper.getDBMD().getSQLKeywords();
    }

    public static int getSQLStateType() throws SQLException {
        return DBMDWrapper.getDBMD().getSQLStateType();
    }

    public static String getStringFunctions() throws SQLException {
        return DBMDWrapper.getDBMD().getStringFunctions();
    }

    public static ResultSet getSuperTables(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        return DBMDWrapper.getDBMD().getSuperTables(catalog, schemaPattern, tableNamePattern);
    }

    public static ResultSet getSuperTypes(String catalog, String schemaPattern, String typeNamePattern) throws SQLException {
        return DBMDWrapper.getDBMD().getSuperTypes(catalog, schemaPattern, typeNamePattern);
    }

    public static String getSystemFunctions() throws SQLException {
        return DBMDWrapper.getDBMD().getSystemFunctions();
    }

    public static ResultSet getTablePrivileges(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        return DBMDWrapper.getDBMD().getTablePrivileges(catalog, schemaPattern, tableNamePattern);
    }

    public static ResultSet getTables(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        return DBMDWrapper.getDBMD().getTables(catalog, schemaPattern, tableNamePattern, null);
    }

    public static ResultSet getTableTypes() throws SQLException {
        return DBMDWrapper.getDBMD().getTableTypes();
    }

    public static String getTimeDateFunctions() throws SQLException {
        return DBMDWrapper.getDBMD().getTimeDateFunctions();
    }

    public static ResultSet getTypeInfo() throws SQLException {
        return DBMDWrapper.getDBMD().getTypeInfo();
    }

    public static ResultSet getUDTs(String catalog, String schemaPattern, String typeNamePattern) throws SQLException {
        return DBMDWrapper.getDBMD().getUDTs(catalog, schemaPattern, typeNamePattern, null);
    }

    public static String getURL() throws SQLException {
        return DBMDWrapper.getDBMD().getURL();
    }

    public static String getUserName() throws SQLException {
        return DBMDWrapper.getDBMD().getUserName();
    }

    public static ResultSet getVersionColumns(String catalog, String schema, String table) throws SQLException {
        return DBMDWrapper.getDBMD().getVersionColumns(catalog, schema, table);
    }

    public static boolean insertsAreDetected(int type) throws SQLException {
        return DBMDWrapper.getDBMD().insertsAreDetected(type);
    }

    public static boolean isCatalogAtStart() throws SQLException {
        return DBMDWrapper.getDBMD().isCatalogAtStart();
    }

    public static boolean isReadOnly() throws SQLException {
        return DBMDWrapper.getDBMD().isReadOnly();
    }

    public static boolean locatorsUpdateCopy() throws SQLException {
        return DBMDWrapper.getDBMD().locatorsUpdateCopy();
    }

    public static boolean nullPlusNonNullIsNull() throws SQLException {
        return DBMDWrapper.getDBMD().nullPlusNonNullIsNull();
    }

    public static boolean nullsAreSortedAtEnd() throws SQLException {
        return DBMDWrapper.getDBMD().nullsAreSortedAtEnd();
    }

    public static boolean nullsAreSortedAtStart() throws SQLException {
        return DBMDWrapper.getDBMD().nullsAreSortedAtStart();
    }

    public static boolean nullsAreSortedHigh() throws SQLException {
        return DBMDWrapper.getDBMD().nullsAreSortedHigh();
    }

    public static boolean nullsAreSortedLow() throws SQLException {
        return DBMDWrapper.getDBMD().nullsAreSortedLow();
    }

    public static boolean othersDeletesAreVisible(int type) throws SQLException {
        return DBMDWrapper.getDBMD().othersDeletesAreVisible(type);
    }

    public static boolean othersInsertsAreVisible(int type) throws SQLException {
        return DBMDWrapper.getDBMD().othersInsertsAreVisible(type);
    }

    public static boolean othersUpdatesAreVisible(int type) throws SQLException {
        return DBMDWrapper.getDBMD().othersUpdatesAreVisible(type);
    }

    public static boolean ownDeletesAreVisible(int type) throws SQLException {
        return DBMDWrapper.getDBMD().ownDeletesAreVisible(type);
    }

    public static boolean ownInsertsAreVisible(int type) throws SQLException {
        return DBMDWrapper.getDBMD().ownInsertsAreVisible(type);
    }

    public static boolean ownUpdatesAreVisible(int type) throws SQLException {
        return DBMDWrapper.getDBMD().ownUpdatesAreVisible(type);
    }

    public static boolean storesLowerCaseIdentifiers() throws SQLException {
        return DBMDWrapper.getDBMD().storesLowerCaseIdentifiers();
    }

    public static boolean storesLowerCaseQuotedIdentifiers() throws SQLException {
        return DBMDWrapper.getDBMD().storesLowerCaseQuotedIdentifiers();
    }

    public static boolean storesMixedCaseIdentifiers() throws SQLException {
        return DBMDWrapper.getDBMD().storesMixedCaseIdentifiers();
    }

    public static boolean storesMixedCaseQuotedIdentifiers() throws SQLException {
        return DBMDWrapper.getDBMD().storesMixedCaseQuotedIdentifiers();
    }

    public static boolean storesUpperCaseIdentifiers() throws SQLException {
        return DBMDWrapper.getDBMD().storesUpperCaseIdentifiers();
    }

    public static boolean storesUpperCaseQuotedIdentifiers() throws SQLException {
        return DBMDWrapper.getDBMD().storesUpperCaseQuotedIdentifiers();
    }

    public static boolean supportsAlterTableWithAddColumn() throws SQLException {
        return DBMDWrapper.getDBMD().supportsAlterTableWithAddColumn();
    }

    public static boolean supportsAlterTableWithDropColumn() throws SQLException {
        return DBMDWrapper.getDBMD().supportsAlterTableWithDropColumn();
    }

    public static boolean supportsANSI92EntryLevelSQL() throws SQLException {
        return DBMDWrapper.getDBMD().supportsANSI92EntryLevelSQL();
    }

    public static boolean supportsANSI92FullSQL() throws SQLException {
        return DBMDWrapper.getDBMD().supportsANSI92FullSQL();
    }

    public static boolean supportsANSI92IntermediateSQL() throws SQLException {
        return DBMDWrapper.getDBMD().supportsANSI92IntermediateSQL();
    }

    public static boolean supportsBatchUpdates() throws SQLException {
        return DBMDWrapper.getDBMD().supportsBatchUpdates();
    }

    public static boolean supportsCatalogsInDataManipulation() throws SQLException {
        return DBMDWrapper.getDBMD().supportsCatalogsInDataManipulation();
    }

    public static boolean supportsCatalogsInIndexDefinitions() throws SQLException {
        return DBMDWrapper.getDBMD().supportsCatalogsInIndexDefinitions();
    }

    public static boolean supportsCatalogsInPrivilegeDefinitions() throws SQLException {
        return DBMDWrapper.getDBMD().supportsCatalogsInPrivilegeDefinitions();
    }

    public static boolean supportsCatalogsInProcedureCalls() throws SQLException {
        return DBMDWrapper.getDBMD().supportsCatalogsInProcedureCalls();
    }

    public static boolean supportsCatalogsInTableDefinitions() throws SQLException {
        return DBMDWrapper.getDBMD().supportsCatalogsInTableDefinitions();
    }

    public static boolean supportsColumnAliasing() throws SQLException {
        return DBMDWrapper.getDBMD().supportsColumnAliasing();
    }

    public static boolean supportsConvert(int fromType, int toType) throws SQLException {
        return DBMDWrapper.getDBMD().supportsConvert(fromType, toType);
    }

    public static boolean supportsCoreSQLGrammar() throws SQLException {
        return DBMDWrapper.getDBMD().supportsCoreSQLGrammar();
    }

    public static boolean supportsCorrelatedSubqueries() throws SQLException {
        return DBMDWrapper.getDBMD().supportsCorrelatedSubqueries();
    }

    public static boolean supportsDataDefinitionAndDataManipulationTransactions() throws SQLException {
        return DBMDWrapper.getDBMD().supportsDataDefinitionAndDataManipulationTransactions();
    }

    public static boolean supportsDataManipulationTransactionsOnly() throws SQLException {
        return DBMDWrapper.getDBMD().supportsDataManipulationTransactionsOnly();
    }

    public static boolean supportsDifferentTableCorrelationNames() throws SQLException {
        return DBMDWrapper.getDBMD().supportsDifferentTableCorrelationNames();
    }

    public static boolean supportsExpressionsInOrderBy() throws SQLException {
        return DBMDWrapper.getDBMD().supportsExpressionsInOrderBy();
    }

    public static boolean supportsExtendedSQLGrammar() throws SQLException {
        return DBMDWrapper.getDBMD().supportsExtendedSQLGrammar();
    }

    public static boolean supportsFullOuterJoins() throws SQLException {
        return DBMDWrapper.getDBMD().supportsFullOuterJoins();
    }

    public static boolean supportsGetGeneratedKeys() throws SQLException {
        return DBMDWrapper.getDBMD().supportsGetGeneratedKeys();
    }

    public static boolean supportsGroupBy() throws SQLException {
        return DBMDWrapper.getDBMD().supportsGroupBy();
    }

    public static boolean supportsGroupByBeyondSelect() throws SQLException {
        return DBMDWrapper.getDBMD().supportsGroupByBeyondSelect();
    }

    public static boolean supportsGroupByUnrelated() throws SQLException {
        return DBMDWrapper.getDBMD().supportsGroupByUnrelated();
    }

    public static boolean supportsIntegrityEnhancementFacility() throws SQLException {
        return DBMDWrapper.getDBMD().supportsIntegrityEnhancementFacility();
    }

    public static boolean supportsLikeEscapeClause() throws SQLException {
        return DBMDWrapper.getDBMD().supportsLikeEscapeClause();
    }

    public static boolean supportsLimitedOuterJoins() throws SQLException {
        return DBMDWrapper.getDBMD().supportsLimitedOuterJoins();
    }

    public static boolean supportsMinimumSQLGrammar() throws SQLException {
        return DBMDWrapper.getDBMD().supportsMinimumSQLGrammar();
    }

    public static boolean supportsMixedCaseIdentifiers() throws SQLException {
        return DBMDWrapper.getDBMD().supportsMixedCaseIdentifiers();
    }

    public static boolean supportsMixedCaseQuotedIdentifiers() throws SQLException {
        return DBMDWrapper.getDBMD().supportsMixedCaseQuotedIdentifiers();
    }

    public static boolean supportsMultipleOpenResults() throws SQLException {
        return DBMDWrapper.getDBMD().supportsMultipleOpenResults();
    }

    public static boolean supportsMultipleResultSets() throws SQLException {
        return DBMDWrapper.getDBMD().supportsMultipleResultSets();
    }

    public static boolean supportsMultipleTransactions() throws SQLException {
        return DBMDWrapper.getDBMD().supportsMultipleTransactions();
    }

    public static boolean supportsNamedParameters() throws SQLException {
        return DBMDWrapper.getDBMD().supportsNamedParameters();
    }

    public static boolean supportsNonNullableColumns() throws SQLException {
        return DBMDWrapper.getDBMD().supportsNonNullableColumns();
    }

    public static boolean supportsOpenCursorsAcrossCommit() throws SQLException {
        return DBMDWrapper.getDBMD().supportsOpenCursorsAcrossCommit();
    }

    public static boolean supportsOpenCursorsAcrossRollback() throws SQLException {
        return DBMDWrapper.getDBMD().supportsOpenCursorsAcrossRollback();
    }

    public static boolean supportsOpenStatementsAcrossCommit() throws SQLException {
        return DBMDWrapper.getDBMD().supportsOpenStatementsAcrossCommit();
    }

    public static boolean supportsOpenStatementsAcrossRollback() throws SQLException {
        return DBMDWrapper.getDBMD().supportsOpenStatementsAcrossRollback();
    }

    public static boolean supportsOrderByUnrelated() throws SQLException {
        return DBMDWrapper.getDBMD().supportsOrderByUnrelated();
    }

    public static boolean supportsOuterJoins() throws SQLException {
        return DBMDWrapper.getDBMD().supportsOuterJoins();
    }

    public static boolean supportsPositionedDelete() throws SQLException {
        return DBMDWrapper.getDBMD().supportsPositionedDelete();
    }

    public static boolean supportsPositionedUpdate() throws SQLException {
        return DBMDWrapper.getDBMD().supportsPositionedUpdate();
    }

    public static boolean supportsResultSetConcurrency(int type, int concurrency) throws SQLException {
        return DBMDWrapper.getDBMD().supportsResultSetConcurrency(type, concurrency);
    }

    public static boolean supportsResultSetHoldability(int holdability) throws SQLException {
        return DBMDWrapper.getDBMD().supportsResultSetHoldability(holdability);
    }

    public static boolean supportsResultSetType(int type) throws SQLException {
        return DBMDWrapper.getDBMD().supportsResultSetType(type);
    }

    public static boolean supportsSavepoints() throws SQLException {
        return DBMDWrapper.getDBMD().supportsSavepoints();
    }

    public static boolean supportsSchemasInDataManipulation() throws SQLException {
        return DBMDWrapper.getDBMD().supportsSchemasInDataManipulation();
    }

    public static boolean supportsSchemasInIndexDefinitions() throws SQLException {
        return DBMDWrapper.getDBMD().supportsSchemasInIndexDefinitions();
    }

    public static boolean supportsSchemasInPrivilegeDefinitions() throws SQLException {
        return DBMDWrapper.getDBMD().supportsSchemasInPrivilegeDefinitions();
    }

    public static boolean supportsSchemasInProcedureCalls() throws SQLException {
        return DBMDWrapper.getDBMD().supportsSchemasInProcedureCalls();
    }

    public static boolean supportsSchemasInTableDefinitions() throws SQLException {
        return DBMDWrapper.getDBMD().supportsSchemasInTableDefinitions();
    }

    public static boolean supportsSelectForUpdate() throws SQLException {
        return DBMDWrapper.getDBMD().supportsSelectForUpdate();
    }

    public static boolean supportsStatementPooling() throws SQLException {
        return DBMDWrapper.getDBMD().supportsStatementPooling();
    }

    public static boolean supportsStoredFunctionsUsingCallSyntax() throws SQLException {
        return DBMDWrapper.getDBMD().supportsStoredFunctionsUsingCallSyntax();
    }

    public static boolean supportsStoredProcedures() throws SQLException {
        return DBMDWrapper.getDBMD().supportsStoredProcedures();
    }

    public static boolean supportsSubqueriesInComparisons() throws SQLException {
        return DBMDWrapper.getDBMD().supportsSubqueriesInComparisons();
    }

    public static boolean supportsSubqueriesInExists() throws SQLException {
        return DBMDWrapper.getDBMD().supportsSubqueriesInExists();
    }

    public static boolean supportsSubqueriesInIns() throws SQLException {
        return DBMDWrapper.getDBMD().supportsSubqueriesInIns();
    }

    public static boolean supportsSubqueriesInQuantifieds() throws SQLException {
        return DBMDWrapper.getDBMD().supportsSubqueriesInQuantifieds();
    }

    public static boolean supportsTableCorrelationNames() throws SQLException {
        return DBMDWrapper.getDBMD().supportsTableCorrelationNames();
    }

    public static boolean supportsTransactionIsolationLevel(int level) throws SQLException {
        return DBMDWrapper.getDBMD().supportsTransactionIsolationLevel(level);
    }

    public static boolean supportsTransactions() throws SQLException {
        return DBMDWrapper.getDBMD().supportsTransactions();
    }

    public static boolean supportsUnion() throws SQLException {
        return DBMDWrapper.getDBMD().supportsUnion();
    }

    public static boolean supportsUnionAll() throws SQLException {
        return DBMDWrapper.getDBMD().supportsUnionAll();
    }

    public static boolean updatesAreDetected(int type) throws SQLException {
        return DBMDWrapper.getDBMD().updatesAreDetected(type);
    }

    public static boolean usesLocalFilePerTable() throws SQLException {
        return DBMDWrapper.getDBMD().usesLocalFilePerTable();
    }

    public static boolean usesLocalFiles() throws SQLException {
        return DBMDWrapper.getDBMD().usesLocalFiles();
    }

    private boolean isSet(int allModifiers, int requestedModifier) {
        return (allModifiers & requestedModifier) != 0;
    }

    private void unregisterFunction(Connection conn, Method method) throws SQLException {
        try {
            DBMDWrapper.executeDDL(conn, "drop function " + method.getName());
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    private void registerFunction(Connection conn, Method method) throws SQLException {
        StringBuffer buffer = new StringBuffer();
        String name = method.getName();
        boolean isTableFunction = this.isTableFunction(method);
        buffer.append("create function " + name + "\n(");
        this.appendArgs(buffer, method);
        buffer.append("\n)\n");
        buffer.append("returns ");
        this.appendReturnType(buffer, conn, method);
        buffer.append("\nlanguage java\nreads sql data\nparameter style ");
        if (isTableFunction) {
            buffer.append("DERBY_JDBC_RESULT_SET");
        } else {
            buffer.append("java");
        }
        buffer.append("\nexternal name '" + this.getClass().getName() + "." + name + "'");
        DBMDWrapper.executeDDL(conn, buffer.toString());
    }

    private boolean isTableFunction(Method method) {
        Class<?> returnType = method.getReturnType();
        return returnType == ResultSet.class;
    }

    private void appendArgs(StringBuffer buffer, Method method) throws SQLException {
        Class<?>[] parameterTypes = method.getParameterTypes();
        int count = parameterTypes.length;
        String paramStub = "a_";
        for (int pidx = 0; pidx < count; ++pidx) {
            Class<?> paramType = parameterTypes[pidx];
            if (pidx > 0) {
                buffer.append(",");
            }
            buffer.append("\n\t");
            buffer.append(paramStub + pidx);
            buffer.append(' ');
            buffer.append(this.mapJavaToSQLType(paramType));
        }
    }

    private void appendReturnType(StringBuffer buffer, Connection conn, Method method) throws SQLException {
        Class<?> returnType = method.getReturnType();
        if (ResultSet.class == returnType) {
            this.appendTableFunctionSignature(buffer, conn, method);
        } else {
            buffer.append(this.mapJavaToSQLType(returnType));
        }
    }

    private void appendTableFunctionSignature(StringBuffer buffer, Connection conn, Method method) throws SQLException {
        ResultSet returnValue;
        buffer.append("table\n(");
        Class<?>[] parameterTypes = method.getParameterTypes();
        int argCount = parameterTypes.length;
        Object[] argValues = new Object[argCount];
        for (int i = 0; i < argCount; ++i) {
            argValues[i] = this.getDummyValue(parameterTypes[i]);
        }
        try {
            returnValue = (ResultSet)method.invoke(null, argValues);
        }
        catch (IllegalAccessException iae) {
            throw DBMDWrapper.wrap(iae);
        }
        catch (InvocationTargetException ite) {
            throw DBMDWrapper.wrap(ite);
        }
        ResultSetMetaData rsmd = returnValue.getMetaData();
        int columnCount = rsmd.getColumnCount();
        for (int i = 0; i < columnCount; ++i) {
            int columnNumber = i + 1;
            if (i > 0) {
                buffer.append(",");
            }
            buffer.append("\n\t");
            buffer.append(rsmd.getColumnName(columnNumber));
            buffer.append("\t");
            this.stringifyJDBCType(buffer, rsmd, columnNumber);
        }
        buffer.append("\n)");
    }

    private Object getDummyValue(Class type) {
        if (String.class == type) {
            return "";
        }
        if (Integer.TYPE == type) {
            return 1;
        }
        if (Short.TYPE == type) {
            return (short)1;
        }
        if (Boolean.TYPE == type) {
            return Boolean.TRUE;
        }
        return null;
    }

    private void stringifyJDBCType(StringBuffer buffer, ResultSetMetaData rsmd, int columnNumber) throws SQLException {
        switch (rsmd.getColumnType(columnNumber)) {
            case 1: 
            case 12: {
                buffer.append(rsmd.getColumnTypeName(columnNumber));
                buffer.append("( ");
                int precision = rsmd.getPrecision(columnNumber);
                if (precision <= 0) {
                    precision = 128;
                }
                buffer.append(precision);
                buffer.append(" )");
                break;
            }
            default: {
                buffer.append(rsmd.getColumnTypeName(columnNumber));
            }
        }
    }

    private String mapJavaToSQLType(Class javaType) throws SQLException {
        if (Short.TYPE == javaType) {
            return "smallint";
        }
        if (Integer.TYPE == javaType) {
            return "int";
        }
        if (Boolean.TYPE == javaType) {
            return "boolean";
        }
        if (String.class == javaType) {
            return "varchar( 32672 )";
        }
        throw new SQLException("Unsupported type: " + javaType.getName());
    }

    private static DatabaseMetaData getDBMD() throws SQLException {
        return DBMDWrapper.getDefaultConnection().getMetaData();
    }

    private static Connection getDefaultConnection() throws SQLException {
        return DriverManager.getConnection("jdbc:default:connection");
    }

    private static void executeDDL(Connection conn, String text) throws SQLException {
        try (PreparedStatement ps = null;){
            ps = DBMDWrapper.prepareStatement(conn, text);
            ps.execute();
        }
    }

    private static PreparedStatement prepareStatement(Connection conn, String text) throws SQLException {
        PreparedStatement ps = conn.prepareStatement(text);
        return ps;
    }

    private static SQLException wrap(Throwable t) {
        return new SQLException(t.getMessage(), t);
    }
}

