/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.builder;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jcodings.Encoding;
import org.jruby.ParseResult;
import org.jruby.Ruby;
import org.jruby.RubyBignum;
import org.jruby.RubyComplex;
import org.jruby.RubyFixnum;
import org.jruby.RubyRational;
import org.jruby.RubySymbol;
import org.jruby.ast.AliasNode;
import org.jruby.ast.AndNode;
import org.jruby.ast.ArgsCatNode;
import org.jruby.ast.ArgsNode;
import org.jruby.ast.ArgsPushNode;
import org.jruby.ast.ArgumentNode;
import org.jruby.ast.ArrayNode;
import org.jruby.ast.ArrayPatternNode;
import org.jruby.ast.AssignableNode;
import org.jruby.ast.AttrAssignNode;
import org.jruby.ast.BackRefNode;
import org.jruby.ast.BeginNode;
import org.jruby.ast.BignumNode;
import org.jruby.ast.BlockArgNode;
import org.jruby.ast.BlockNode;
import org.jruby.ast.BlockPassNode;
import org.jruby.ast.BreakNode;
import org.jruby.ast.CallNode;
import org.jruby.ast.CaseNode;
import org.jruby.ast.ClassNode;
import org.jruby.ast.ClassVarAsgnNode;
import org.jruby.ast.ClassVarNode;
import org.jruby.ast.Colon2Node;
import org.jruby.ast.Colon3Node;
import org.jruby.ast.ComplexNode;
import org.jruby.ast.ConstDeclNode;
import org.jruby.ast.ConstNode;
import org.jruby.ast.DAsgnNode;
import org.jruby.ast.DNode;
import org.jruby.ast.DRegexpNode;
import org.jruby.ast.DStrNode;
import org.jruby.ast.DSymbolNode;
import org.jruby.ast.DVarNode;
import org.jruby.ast.DXStrNode;
import org.jruby.ast.DefNode;
import org.jruby.ast.DefinedNode;
import org.jruby.ast.DefsNode;
import org.jruby.ast.DotNode;
import org.jruby.ast.EncodingNode;
import org.jruby.ast.EnsureNode;
import org.jruby.ast.EvStrNode;
import org.jruby.ast.FCallNode;
import org.jruby.ast.FileNode;
import org.jruby.ast.FindPatternNode;
import org.jruby.ast.FixnumNode;
import org.jruby.ast.FlipNode;
import org.jruby.ast.FloatNode;
import org.jruby.ast.ForNode;
import org.jruby.ast.GlobalAsgnNode;
import org.jruby.ast.GlobalVarNode;
import org.jruby.ast.HashNode;
import org.jruby.ast.HashPatternNode;
import org.jruby.ast.IScopedNode;
import org.jruby.ast.IfNode;
import org.jruby.ast.InNode;
import org.jruby.ast.InstAsgnNode;
import org.jruby.ast.InstVarNode;
import org.jruby.ast.IterNode;
import org.jruby.ast.KeywordArgNode;
import org.jruby.ast.KeywordRestArgNode;
import org.jruby.ast.LambdaNode;
import org.jruby.ast.ListNode;
import org.jruby.ast.LiteralNode;
import org.jruby.ast.LocalAsgnNode;
import org.jruby.ast.LocalVarNode;
import org.jruby.ast.Match2CaptureNode;
import org.jruby.ast.Match2Node;
import org.jruby.ast.Match3Node;
import org.jruby.ast.MatchNode;
import org.jruby.ast.MethodDefNode;
import org.jruby.ast.ModuleNode;
import org.jruby.ast.MultipleAsgnNode;
import org.jruby.ast.NextNode;
import org.jruby.ast.NilImplicitNode;
import org.jruby.ast.NilRestArgNode;
import org.jruby.ast.Node;
import org.jruby.ast.NodeType;
import org.jruby.ast.NthRefNode;
import org.jruby.ast.OpAsgnAndNode;
import org.jruby.ast.OpAsgnConstDeclNode;
import org.jruby.ast.OpAsgnNode;
import org.jruby.ast.OpAsgnOrNode;
import org.jruby.ast.OpElementAsgnNode;
import org.jruby.ast.OptArgNode;
import org.jruby.ast.OrNode;
import org.jruby.ast.PatternCaseNode;
import org.jruby.ast.PostExeNode;
import org.jruby.ast.PreExeNode;
import org.jruby.ast.RationalNode;
import org.jruby.ast.RedoNode;
import org.jruby.ast.RegexpNode;
import org.jruby.ast.RescueBodyNode;
import org.jruby.ast.RescueModNode;
import org.jruby.ast.RescueNode;
import org.jruby.ast.RestArgNode;
import org.jruby.ast.RetryNode;
import org.jruby.ast.ReturnNode;
import org.jruby.ast.RootNode;
import org.jruby.ast.SClassNode;
import org.jruby.ast.SValueNode;
import org.jruby.ast.SelfNode;
import org.jruby.ast.SideEffectFree;
import org.jruby.ast.SplatNode;
import org.jruby.ast.StarNode;
import org.jruby.ast.StrNode;
import org.jruby.ast.SuperNode;
import org.jruby.ast.SymbolNode;
import org.jruby.ast.TwoValueNode;
import org.jruby.ast.UndefNode;
import org.jruby.ast.UntilNode;
import org.jruby.ast.VAliasNode;
import org.jruby.ast.VCallNode;
import org.jruby.ast.WhenNode;
import org.jruby.ast.WhileNode;
import org.jruby.ast.XStrNode;
import org.jruby.ast.YieldNode;
import org.jruby.ast.ZArrayNode;
import org.jruby.ast.ZSuperNode;
import org.jruby.ast.types.ILiteralNode;
import org.jruby.ast.types.INameNode;
import org.jruby.common.IRubyWarnings;
import org.jruby.compiler.NotCompilableException;
import org.jruby.ir.IRClosure;
import org.jruby.ir.IRFlags;
import org.jruby.ir.IRFor;
import org.jruby.ir.IRManager;
import org.jruby.ir.IRMethod;
import org.jruby.ir.IRModuleBody;
import org.jruby.ir.IRScope;
import org.jruby.ir.IRScriptBody;
import org.jruby.ir.Tuple;
import org.jruby.ir.builder.IRBuilder;
import org.jruby.ir.builder.LazyMethodDefinitionAST;
import org.jruby.ir.instructions.ArrayDerefInstr;
import org.jruby.ir.instructions.AsStringInstr;
import org.jruby.ir.instructions.AttrAssignInstr;
import org.jruby.ir.instructions.BNEInstr;
import org.jruby.ir.instructions.BNilInstr;
import org.jruby.ir.instructions.BSwitchInstr;
import org.jruby.ir.instructions.BlockGivenInstr;
import org.jruby.ir.instructions.BuildBackrefInstr;
import org.jruby.ir.instructions.BuildCompoundArrayInstr;
import org.jruby.ir.instructions.BuildSplatInstr;
import org.jruby.ir.instructions.CheckArityInstr;
import org.jruby.ir.instructions.CopyInstr;
import org.jruby.ir.instructions.DebugOutputInstr;
import org.jruby.ir.instructions.EQQInstr;
import org.jruby.ir.instructions.Instr;
import org.jruby.ir.instructions.JumpInstr;
import org.jruby.ir.instructions.LabelInstr;
import org.jruby.ir.instructions.LoadImplicitClosureInstr;
import org.jruby.ir.instructions.MatchInstr;
import org.jruby.ir.instructions.PutClassVariableInstr;
import org.jruby.ir.instructions.PutFieldInstr;
import org.jruby.ir.instructions.PutGlobalVarInstr;
import org.jruby.ir.instructions.RaiseRequiredKeywordArgumentError;
import org.jruby.ir.instructions.ReceiveKeywordArgInstr;
import org.jruby.ir.instructions.ReceiveKeywordRestArgInstr;
import org.jruby.ir.instructions.ReceiveKeywordsInstr;
import org.jruby.ir.instructions.ReceiveOptArgInstr;
import org.jruby.ir.instructions.ReceivePostReqdArgInstr;
import org.jruby.ir.instructions.ReceivePreReqdArgInstr;
import org.jruby.ir.instructions.ReceiveRestArgInstr;
import org.jruby.ir.instructions.RecordEndBlockInstr;
import org.jruby.ir.instructions.ReifyClosureInstr;
import org.jruby.ir.instructions.ReqdArgMultipleAsgnInstr;
import org.jruby.ir.instructions.RestArgMultipleAsgnInstr;
import org.jruby.ir.instructions.ResultInstr;
import org.jruby.ir.instructions.ReturnInstr;
import org.jruby.ir.instructions.RuntimeHelperCall;
import org.jruby.ir.instructions.SearchModuleForConstInstr;
import org.jruby.ir.instructions.SetCapturedVarInstr;
import org.jruby.ir.instructions.ToAryInstr;
import org.jruby.ir.instructions.YieldInstr;
import org.jruby.ir.instructions.defined.GetErrorInfoInstr;
import org.jruby.ir.instructions.defined.RestoreErrorInfoInstr;
import org.jruby.ir.interpreter.InterpreterContext;
import org.jruby.ir.operands.Array;
import org.jruby.ir.operands.Bignum;
import org.jruby.ir.operands.Boolean;
import org.jruby.ir.operands.Complex;
import org.jruby.ir.operands.Filename;
import org.jruby.ir.operands.Float;
import org.jruby.ir.operands.FrozenString;
import org.jruby.ir.operands.Hash;
import org.jruby.ir.operands.ImmutableLiteral;
import org.jruby.ir.operands.Label;
import org.jruby.ir.operands.LocalVariable;
import org.jruby.ir.operands.MutableString;
import org.jruby.ir.operands.Nil;
import org.jruby.ir.operands.NullBlock;
import org.jruby.ir.operands.Operand;
import org.jruby.ir.operands.Regexp;
import org.jruby.ir.operands.SValue;
import org.jruby.ir.operands.ScopeModule;
import org.jruby.ir.operands.Splat;
import org.jruby.ir.operands.Symbol;
import org.jruby.ir.operands.SymbolProc;
import org.jruby.ir.operands.UndefinedValue;
import org.jruby.ir.operands.Variable;
import org.jruby.ir.operands.WrappedIRClosure;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.ArgumentType;
import org.jruby.runtime.CallType;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.Signature;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;
import org.jruby.util.CommonByteLists;
import org.jruby.util.DefinedMessage;
import org.jruby.util.KeyValuePair;
import org.jruby.util.cli.Options;

public class IRBuilderAST
extends IRBuilder<Node, DefNode, WhenNode, RescueBodyNode, Colon3Node, HashNode> {
    @Deprecated
    public static Node buildAST(boolean isCommandLineScript, String arg2) {
        Ruby ruby = Ruby.getGlobalRuntime();
        if (isCommandLineScript) {
            return ruby.parse(ByteList.create(arg2), "-e", null, 0, false);
        }
        FileInputStream fis = null;
        try {
            File file2 = new File(arg2);
            fis = new FileInputStream(file2);
            long size2 = file2.length();
            byte[] bytes2 = new byte[(int)size2];
            fis.read(bytes2);
            System.out.println("-- processing " + arg2 + " --");
            Node node = ruby.parse(new ByteList(bytes2), arg2, null, 0, false);
            return node;
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        finally {
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (Exception exception2) {}
        }
    }

    public IRBuilderAST(IRManager manager, IRScope scope, IRBuilder parent, IRBuilder variableBuilder, Encoding encoding2) {
        super(manager, scope, parent, variableBuilder, encoding2);
    }

    @Override
    public Operand build(ParseResult result2) {
        return this.build(((RootNode)result2).getBodyNode());
    }

    public IRBuilderAST(IRManager manager, IRScope scope, IRBuilder parent) {
        this(manager, scope, parent, null, null);
    }

    private NotCompilableException notCompilable(String message2, Node node) {
        int line = node != null ? node.getLine() : this.scope.getLine();
        String loc = this.scope.getFile() + ":" + line;
        String what = node != null ? node.getClass().getSimpleName() + " - " + loc : loc;
        return new NotCompilableException(message2 + " (" + what + ").");
    }

    private Operand buildOperand(Variable result2, Node node) throws NotCompilableException {
        if (node.isNewline()) {
            this.determineIfWeNeedLineNumber(node.getLine(), true, node instanceof NilImplicitNode, node instanceof DefNode);
        }
        switch (node.getNodeType()) {
            case ALIASNODE: {
                return this.buildAlias((AliasNode)node);
            }
            case ANDNODE: {
                return this.buildAnd((AndNode)node);
            }
            case ARGSCATNODE: {
                return this.buildArgsCat(result2, (ArgsCatNode)node);
            }
            case ARGSPUSHNODE: {
                return this.buildArgsPush(result2, (ArgsPushNode)node);
            }
            case ARRAYNODE: {
                return this.buildArray((ArrayNode)node, false);
            }
            case ATTRASSIGNNODE: {
                return this.buildAttrAssign(result2, (AttrAssignNode)node);
            }
            case BACKREFNODE: {
                return this.buildBackref(result2, (BackRefNode)node);
            }
            case BEGINNODE: {
                return this.buildBegin((BeginNode)node);
            }
            case BIGNUMNODE: {
                return this.buildBignum((BignumNode)node);
            }
            case BLOCKNODE: {
                return this.buildBlock((BlockNode)node);
            }
            case BREAKNODE: {
                return this.buildBreak((BreakNode)node);
            }
            case CALLNODE: {
                return this.buildCall(result2, (CallNode)node, null, null);
            }
            case CASENODE: {
                return this.buildCase((CaseNode)node);
            }
            case CLASSNODE: {
                return this.buildClass((ClassNode)node);
            }
            case CLASSVARNODE: {
                return this.buildClassVar(result2, (ClassVarNode)node);
            }
            case CLASSVARASGNNODE: {
                return this.buildClassVarAsgn((ClassVarAsgnNode)node);
            }
            case COLON2NODE: {
                return this.buildColon2(result2, (Colon2Node)node);
            }
            case COLON3NODE: {
                return this.buildColon3(result2, (Colon3Node)node);
            }
            case COMPLEXNODE: {
                return this.buildComplex((ComplexNode)node);
            }
            case CONSTDECLNODE: {
                return this.buildConstDecl((ConstDeclNode)node);
            }
            case CONSTNODE: {
                return this.searchConst(result2, ((ConstNode)node).getName());
            }
            case DASGNNODE: {
                return this.buildDAsgn((DAsgnNode)node);
            }
            case DEFINEDNODE: {
                return this.buildGetDefinition(((DefinedNode)node).getExpressionNode());
            }
            case DEFNNODE: {
                return this.buildDefn((MethodDefNode)node);
            }
            case DEFSNODE: {
                return this.buildDefs((DefsNode)node);
            }
            case DOTNODE: {
                return this.buildDot((DotNode)node);
            }
            case DREGEXPNODE: {
                return this.buildDRegexp(result2, (DRegexpNode)node);
            }
            case DSTRNODE: {
                return this.buildDStr(result2, (DStrNode)node);
            }
            case DSYMBOLNODE: {
                return this.buildDSymbol(result2, (DSymbolNode)node);
            }
            case DVARNODE: {
                return this.buildDVar((DVarNode)node);
            }
            case DXSTRNODE: {
                return this.buildDXStr(result2, (DXStrNode)node);
            }
            case ENCODINGNODE: {
                return this.buildEncoding((EncodingNode)node);
            }
            case ENSURENODE: {
                return this.buildEnsureNode((EnsureNode)node);
            }
            case FALSENODE: {
                return this.fals();
            }
            case FCALLNODE: {
                return this.buildFCall(result2, (FCallNode)node);
            }
            case FIXNUMNODE: {
                return this.buildFixnum((FixnumNode)node);
            }
            case FLIPNODE: {
                return this.buildFlip((FlipNode)node);
            }
            case FLOATNODE: {
                return this.buildFloat((FloatNode)node);
            }
            case FORNODE: {
                return this.buildFor((ForNode)node);
            }
            case GLOBALASGNNODE: {
                return this.buildGlobalAsgn((GlobalAsgnNode)node);
            }
            case GLOBALVARNODE: {
                return this.buildGlobalVar(result2, (GlobalVarNode)node);
            }
            case HASHNODE: {
                return this.buildHash((HashNode)node);
            }
            case IFNODE: {
                return this.buildIf(result2, (IfNode)node);
            }
            case INSTASGNNODE: {
                return this.buildInstAsgn((InstAsgnNode)node);
            }
            case INSTVARNODE: {
                return this.buildInstVar((InstVarNode)node);
            }
            case ITERNODE: {
                return this.buildIter((IterNode)node);
            }
            case LAMBDANODE: {
                return this.buildLambda((LambdaNode)node);
            }
            case LITERALNODE: {
                return this.buildLiteral((LiteralNode)node);
            }
            case LOCALASGNNODE: {
                return this.buildLocalAsgn((LocalAsgnNode)node);
            }
            case LOCALVARNODE: {
                return this.buildLocalVar((LocalVarNode)node);
            }
            case MATCH2NODE: {
                return this.buildMatch2(result2, (Match2Node)node);
            }
            case MATCH3NODE: {
                return this.buildMatch3(result2, (Match3Node)node);
            }
            case MATCHNODE: {
                return this.buildMatch(result2, (MatchNode)node);
            }
            case MODULENODE: {
                return this.buildModule((ModuleNode)node);
            }
            case MULTIPLEASGNNODE: {
                return this.buildMultipleAsgn((MultipleAsgnNode)node);
            }
            case NEXTNODE: {
                return this.buildNext((NextNode)node);
            }
            case NTHREFNODE: {
                return this.buildNthRef((NthRefNode)node);
            }
            case NILNODE: {
                return this.buildNil();
            }
            case OPASGNANDNODE: {
                return this.buildOpAsgnAnd((OpAsgnAndNode)node);
            }
            case OPASGNCONSTDECLNODE: {
                return this.buildOpAsgnConstDeclNode((OpAsgnConstDeclNode)node);
            }
            case OPASGNNODE: {
                return this.buildOpAsgn((OpAsgnNode)node);
            }
            case OPASGNORNODE: {
                return this.buildOpAsgnOr((OpAsgnOrNode)node);
            }
            case OPELEMENTASGNNODE: {
                return this.buildOpElementAsgn((OpElementAsgnNode)node);
            }
            case ORNODE: {
                return this.buildOr((OrNode)node);
            }
            case PATTERNCASENODE: {
                return this.buildPatternCase((PatternCaseNode)node);
            }
            case PREEXENODE: {
                return this.buildPreExe((PreExeNode)node);
            }
            case POSTEXENODE: {
                return this.buildPostExe((PostExeNode)node);
            }
            case RATIONALNODE: {
                return this.buildRational((RationalNode)node);
            }
            case REDONODE: {
                return this.buildRedo((RedoNode)node);
            }
            case REGEXPNODE: {
                return this.buildRegexp((RegexpNode)node);
            }
            case RESCUEBODYNODE: {
                throw this.notCompilable("handled by rescue compilation", node);
            }
            case RESCUENODE: {
                return this.buildRescue((RescueNode)node);
            }
            case RETRYNODE: {
                return this.buildRetry((RetryNode)node);
            }
            case RETURNNODE: {
                return this.buildReturn((ReturnNode)node);
            }
            case ROOTNODE: {
                throw this.notCompilable("Use buildRoot()", node);
            }
            case SCLASSNODE: {
                return this.buildSClass((SClassNode)node);
            }
            case SELFNODE: {
                return this.buildSelf();
            }
            case SPLATNODE: {
                return this.buildSplat(result2, (SplatNode)node);
            }
            case STRNODE: {
                return this.buildStr((StrNode)node);
            }
            case SUPERNODE: {
                return this.buildSuper(result2, (SuperNode)node);
            }
            case SVALUENODE: {
                return this.buildSValue(result2, (SValueNode)node);
            }
            case SYMBOLNODE: {
                return this.buildSymbol((SymbolNode)node);
            }
            case TRUENODE: {
                return this.tru();
            }
            case UNDEFNODE: {
                return this.buildUndef((UndefNode)node);
            }
            case UNTILNODE: {
                return this.buildUntil((UntilNode)node);
            }
            case VALIASNODE: {
                return this.buildVAlias((VAliasNode)node);
            }
            case VCALLNODE: {
                return this.buildVCall(result2, (VCallNode)node);
            }
            case WHILENODE: {
                return this.buildWhile((WhileNode)node);
            }
            case WHENNODE: {
                assert (false) : "When nodes are handled by case node compilation.";
                return null;
            }
            case XSTRNODE: {
                return this.buildXStr(result2, (XStrNode)node);
            }
            case YIELDNODE: {
                return this.buildYield(result2, (YieldNode)node);
            }
            case ZARRAYNODE: {
                return this.buildZArray(result2);
            }
            case ZSUPERNODE: {
                return this.buildZSuper(result2, (ZSuperNode)node);
            }
        }
        throw this.notCompilable("Unknown node encountered in builder", node);
    }

    public IRBuilderAST newIRBuilder(IRManager manager, IRScope newScope) {
        return new IRBuilderAST(manager, newScope, this);
    }

    @Override
    public Operand build(Node node) {
        return this.build((Variable)null, node);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Operand build(Variable result2, Node node) {
        if (node == null) {
            return null;
        }
        boolean savedExecuteOnce = this.executesOnce;
        try {
            if (this.executesOnce) {
                this.executesOnce = node.executesOnce();
            }
            if (this.hasListener()) {
                this.getManager().getIRScopeListener().startBuildOperand(node, this.scope);
            }
            Operand operand = this.buildOperand(result2, node);
            if (this.hasListener()) {
                this.getManager().getIRScopeListener().endBuildOperand(node, this.scope, operand);
            }
            Operand operand2 = operand;
            return operand2;
        }
        finally {
            this.executesOnce = savedExecuteOnce;
        }
    }

    public Operand buildLambda(LambdaNode node) {
        return this.buildLambda(node.getArgs(), node.getBody(), node.getScope(), Signature.from(node), node.getLine());
    }

    public Operand buildEncoding(EncodingNode node) {
        return this.buildEncoding(node.getEncoding());
    }

    public Operand buildMultipleAsgn(MultipleAsgnNode multipleAsgnNode) {
        Node valueNode = multipleAsgnNode.getValueNode();
        HashMap<Node, Operand> reads = new HashMap<Node, Operand>();
        ArrayList<Tuple<Node, ResultInstr>> assigns = new ArrayList<Tuple<Node, ResultInstr>>();
        Variable values2 = this.temp();
        this.buildMultipleAssignment2(multipleAsgnNode, assigns, reads, values2);
        Variable ret = this.getValueInTemporaryVariable(this.build(valueNode));
        if (valueNode instanceof ArrayNode || valueNode instanceof ZArrayNode) {
            this.copy(values2, ret);
        } else if (valueNode instanceof ILiteralNode) {
            this.copy(values2, new Array(new Operand[]{ret}));
        } else {
            this.addResultInstr(new ToAryInstr(values2, (Operand)ret));
        }
        for (Tuple tuple : assigns) {
            this.addInstr((Instr)tuple.b);
        }
        this.buildAssignment(assigns, reads);
        return ret;
    }

    protected void buildAssignment(List<Tuple<Node, ResultInstr>> assigns, Map<Node, Operand> reads) {
        for (Tuple<Node, ResultInstr> assign : assigns) {
            Node node = (Node)assign.a;
            Variable rhs = ((ResultInstr)assign.b).getResult();
            switch (node.getNodeType()) {
                case ATTRASSIGNNODE: {
                    AttrAssignNode attrAssignNode = (AttrAssignNode)node;
                    Operand receiver2 = reads.get(attrAssignNode.getReceiverNode());
                    Array holders = (Array)reads.get(attrAssignNode.getArgsNode());
                    int flags2 = ((org.jruby.ir.operands.Integer)holders.get((int)(holders.size() - 1))).value;
                    Operand[] args2 = new Operand[holders.size() - 1];
                    System.arraycopy(holders.getElts(), 0, args2, 0, args2.length);
                    args2 = IRBuilderAST.addArg(args2, rhs);
                    this.addInstr(AttrAssignInstr.create(this.scope, receiver2, attrAssignNode.getName(), args2, flags2, this.scope.maybeUsingRefinements()));
                    break;
                }
                case CLASSVARASGNNODE: {
                    this.addInstr(new PutClassVariableInstr(this.classVarDefinitionContainer(), ((ClassVarAsgnNode)node).getName(), (Operand)rhs));
                    break;
                }
                case CONSTDECLNODE: {
                    ConstDeclNode constDeclNode = (ConstDeclNode)node;
                    Operand receiver2 = reads.get(node);
                    if (receiver2 == null) {
                        this.putConstant(constDeclNode.getName(), (Operand)rhs);
                        break;
                    }
                    this.putConstant(receiver2, constDeclNode.getName(), rhs);
                    break;
                }
                case DASGNNODE: {
                    DAsgnNode variable = (DAsgnNode)node;
                    this.copy(this.getLocalVariable(variable.getName(), variable.getDepth()), rhs);
                    break;
                }
                case GLOBALASGNNODE: {
                    this.addInstr(new PutGlobalVarInstr(((GlobalAsgnNode)node).getName(), (Operand)rhs));
                    break;
                }
                case INSTASGNNODE: {
                    this.addInstr(new PutFieldInstr(this.buildSelf(), ((InstAsgnNode)node).getName(), (Operand)rhs));
                    break;
                }
                case LOCALASGNNODE: {
                    LocalAsgnNode localVariable = (LocalAsgnNode)node;
                    this.copy(this.getLocalVariable(localVariable.getName(), localVariable.getDepth()), rhs);
                    break;
                }
            }
        }
    }

    public void buildMultipleAssignment2(MultipleAsgnNode multipleAsgnNode, List<Tuple<Node, ResultInstr>> assigns, Map<Node, Operand> reads, Variable values2) {
        ListNode masgnPost;
        ListNode masgnPre = multipleAsgnNode.getPre();
        int i2 = 0;
        if (masgnPre != null) {
            for (Node an : masgnPre.children()) {
                ReqdArgMultipleAsgnInstr get2 = new ReqdArgMultipleAsgnInstr(this.temp(), (Operand)values2, i2);
                assigns.add(new Tuple<Node, ReqdArgMultipleAsgnInstr>(an, get2));
                this.processReads(get2.getResult(), assigns, reads, an);
                ++i2;
            }
        }
        Node restNode = multipleAsgnNode.getRest();
        int postCount = multipleAsgnNode.getPostCount();
        if (restNode != null && !(restNode instanceof StarNode)) {
            RestArgMultipleAsgnInstr get3 = new RestArgMultipleAsgnInstr(this.temp(), values2, 0, i2, postCount);
            assigns.add(new Tuple<Node, RestArgMultipleAsgnInstr>(restNode, get3));
            this.processReads(get3.getResult(), assigns, reads, restNode);
        }
        if ((masgnPost = multipleAsgnNode.getPost()) != null) {
            int j = 0;
            for (Node an : masgnPost.children()) {
                ReqdArgMultipleAsgnInstr get4 = new ReqdArgMultipleAsgnInstr(this.temp(), values2, j, i2, postCount);
                assigns.add(new Tuple<Node, ReqdArgMultipleAsgnInstr>(an, get4));
                this.processReads(get4.getResult(), assigns, reads, an);
                ++j;
            }
        }
    }

    private void processReads(Variable rhsVal, List<Tuple<Node, ResultInstr>> assigns, Map<Node, Operand> reads, Node node) {
        switch (node.getNodeType()) {
            case ATTRASSIGNNODE: {
                AttrAssignNode attrAssignNode = (AttrAssignNode)node;
                reads.put(attrAssignNode.getReceiverNode(), this.build(attrAssignNode.getReceiverNode()));
                int[] flags2 = new int[]{0};
                Operand[] args2 = this.setupCallArgs(attrAssignNode.getArgsNode(), flags2);
                Operand[] hackyArgs = new Operand[args2.length + 1];
                System.arraycopy(args2, 0, hackyArgs, 0, args2.length);
                hackyArgs[args2.length] = new org.jruby.ir.operands.Integer(flags2[0]);
                reads.put(attrAssignNode.getArgsNode(), new Array(hackyArgs));
                break;
            }
            case CLASSVARASGNNODE: {
                reads.put(node, this.classVarDefinitionContainer());
                break;
            }
            case CONSTDECLNODE: {
                ConstDeclNode constDeclNode = (ConstDeclNode)node;
                Node constNode = constDeclNode.getConstNode();
                if (constNode == null) {
                    reads.put(node, null);
                    break;
                }
                if (constNode instanceof Colon2Node) {
                    reads.put(node, this.build(((Colon2Node)constNode).getLeftNode()));
                    break;
                }
                if (constNode instanceof Colon3Node) {
                    reads.put(node, this.getManager().getObjectClass());
                    break;
                }
                reads.put(node, this.build(constNode));
                break;
            }
            case MULTIPLEASGNNODE: {
                Variable subRet = this.temp();
                assigns.add(new Tuple<Node, ToAryInstr>(node, new ToAryInstr(subRet, (Operand)rhsVal)));
                this.buildMultipleAssignment2((MultipleAsgnNode)node, assigns, reads, subRet);
            }
        }
    }

    protected Operand buildLazyWithOrder(CallNode node, Label lazyLabel, Label endLabel, boolean preserveOrder) {
        Operand value2 = this.buildCall(null, node, lazyLabel, endLabel);
        return preserveOrder && !(value2 instanceof ImmutableLiteral) ? this.copy(value2) : value2;
    }

    @Override
    protected Operand[] buildAttrAssignCallArgs(Node args2, Operand[] outValue, boolean containsAssignment) {
        if (args2 == null) {
            return ScopeModule.EMPTY_ARRAY;
        }
        switch (args2.getNodeType()) {
            case ARRAYNODE: {
                Node[] children2 = ((ListNode)args2).children();
                Operand[] operands = new Operand[children2.length];
                for (int i2 = 0; i2 < children2.length; ++i2) {
                    operands[i2] = this.buildWithOrder(children2[i2], containsAssignment);
                    outValue[0] = operands[i2];
                }
                return operands;
            }
            case ARGSCATNODE: {
                Operand rhs;
                ArgsCatNode argsCatNode = (ArgsCatNode)args2;
                Operand lhs = this.build(argsCatNode.getFirstNode());
                outValue[0] = rhs = this.build(argsCatNode.getSecondNode());
                Variable res = this.addResultInstr(new BuildCompoundArrayInstr(this.temp(), lhs, rhs, false, false));
                return new Operand[]{new Splat(res)};
            }
            case ARGSPUSHNODE: {
                Operand rhs;
                ArgsPushNode argsPushNode = (ArgsPushNode)args2;
                Operand lhs = this.build(argsPushNode.getFirstNode());
                outValue[0] = rhs = this.build(argsPushNode.getSecondNode());
                Variable res = this.addResultInstr(new BuildCompoundArrayInstr(this.temp(), lhs, rhs, true, false));
                return new Operand[]{new Splat(res)};
            }
            case SPLATNODE: {
                outValue[0] = new Splat(this.buildSplat(this.temp(), (SplatNode)args2));
                return new Operand[]{outValue[0]};
            }
        }
        throw this.notCompilable("Invalid node for attrassign call args", args2);
    }

    private Operand buildRestKeywordArgs(HashNode keywordArgs, int[] flags2) {
        flags2[0] = flags2[0] | 4;
        List<KeyValuePair<Node, Node>> pairs = keywordArgs.getPairs();
        if (pairs.size() == 1) {
            Operand splat = this.buildWithOrder(pairs.get(0).getValue(), keywordArgs.containsVariableAssignment());
            return this.addResultInstr(new RuntimeHelperCall(this.temp(), RuntimeHelperCall.Methods.HASH_CHECK, new Operand[]{splat}));
        }
        Variable splatValue = this.copy(new Hash(new ArrayList<KeyValuePair<Operand, Operand>>()));
        for (KeyValuePair<Node, Node> pair : pairs) {
            Operand splat = this.buildWithOrder(pair.getValue(), keywordArgs.containsVariableAssignment());
            this.addInstr(new RuntimeHelperCall(splatValue, RuntimeHelperCall.Methods.MERGE_KWARGS, new Operand[]{splatValue, splat, this.fals()}));
        }
        return splatValue;
    }

    protected Operand buildCallKeywordArguments(HashNode keywords, int[] flags2) {
        flags2[0] = flags2[0] | 2;
        if (keywords.hasOnlyRestKwargs()) {
            return this.buildRestKeywordArgs(keywords, flags2);
        }
        return this.buildHash(keywords);
    }

    protected Operand buildCallArgsArrayForSplat(ListNode args2, int[] flags2) {
        Node[] nodes = args2.children();
        Operand[] elts = new Operand[nodes.length];
        boolean containsAssignments = args2.containsVariableAssignment();
        Operand keywordRestSplat = null;
        for (int i2 = 0; i2 < nodes.length; ++i2) {
            elts[i2] = this.buildWithOrder(nodes[i2], containsAssignments);
            if (i2 != nodes.length - 1 || !(nodes[i2] instanceof HashNode) || ((HashNode)nodes[i2]).isLiteral()) continue;
            flags2[0] = flags2[0] | 2;
            if (!((HashNode)nodes[i2]).hasOnlyRestKwargs()) continue;
            keywordRestSplat = elts[i2];
        }
        if (keywordRestSplat != null) {
            Variable test2 = this.addResultInstr(new RuntimeHelperCall(this.temp(), RuntimeHelperCall.Methods.IS_HASH_EMPTY, new Operand[]{keywordRestSplat}));
            Variable result2 = this.temp();
            this.if_else(test2, this.tru(), () -> this.copy(result2, new Array(IRBuilderAST.removeArg(elts))), () -> this.copy(result2, new Array(elts)));
            return result2;
        }
        return new Array(elts);
    }

    protected Operand[] buildCallArgsArray(ListNode args2, int[] flags2) {
        Node[] children2 = args2.children();
        int numberOfArgs = children2.length;
        Operand[] builtArgs = new Operand[numberOfArgs];
        boolean hasAssignments = args2.containsVariableAssignment();
        for (int i2 = 0; i2 < numberOfArgs; ++i2) {
            if (i2 == numberOfArgs - 1 && children2[i2] instanceof HashNode && !((HashNode)children2[i2]).isLiteral()) {
                HashNode hash2 = (HashNode)children2[i2];
                builtArgs[i2] = this.buildCallKeywordArguments(hash2, flags2);
                continue;
            }
            builtArgs[i2] = this.buildWithOrder(children2[i2], hasAssignments);
        }
        return builtArgs;
    }

    @Override
    protected Operand[] buildCallArgs(Node args2, int[] flags2) {
        switch (args2.getNodeType()) {
            case ARGSCATNODE: 
            case ARGSPUSHNODE: {
                Operand lhs = this.build(((TwoValueNode)((Object)args2)).getFirstNode());
                Node secondNode = ((TwoValueNode)((Object)args2)).getSecondNode();
                flags2[0] = flags2[0] | 1;
                Operand valueToSplat = secondNode instanceof ListNode && !(secondNode instanceof DNode) ? this.buildCallArgsArrayForSplat((ListNode)secondNode, flags2) : (secondNode instanceof HashNode && !((HashNode)secondNode).isLiteral() ? this.buildCallKeywordArguments((HashNode)secondNode, flags2) : this.build(secondNode));
                Variable array2 = this.addResultInstr(new BuildCompoundArrayInstr(this.temp(), lhs, valueToSplat, args2.getNodeType() == NodeType.ARGSPUSHNODE, (flags2[0] & 4) != 0));
                return new Operand[]{new Splat(this.addResultInstr(new BuildSplatInstr(this.temp(), (Operand)array2, false)))};
            }
            case ARRAYNODE: {
                return this.buildCallArgsArray((ListNode)args2, flags2);
            }
            case SPLATNODE: {
                flags2[0] = flags2[0] | 1;
                return new Operand[]{new Splat(this.addResultInstr(new BuildSplatInstr(this.temp(), this.build(((SplatNode)args2).getValue()), true)))};
            }
        }
        throw this.notCompilable("Invalid node for call args: ", args2);
    }

    Operand buildYieldArgs(Node args2, int[] flags2) {
        if (args2 == null) {
            return UndefinedValue.UNDEFINED;
        }
        switch (args2.getNodeType()) {
            case ARGSCATNODE: 
            case ARGSPUSHNODE: {
                Operand lhs = this.build(((TwoValueNode)((Object)args2)).getFirstNode());
                Node secondNode = ((TwoValueNode)((Object)args2)).getSecondNode();
                flags2[0] = flags2[0] | 1;
                Operand valueToSplat = secondNode instanceof ListNode ? this.buildCallArgsArrayForSplat((ListNode)secondNode, flags2) : (secondNode instanceof HashNode && !((HashNode)secondNode).isLiteral() ? this.buildCallKeywordArguments((HashNode)secondNode, flags2) : this.build(secondNode));
                Variable array2 = this.addResultInstr(new BuildCompoundArrayInstr(this.temp(), lhs, valueToSplat, args2.getNodeType() == NodeType.ARGSPUSHNODE, (flags2[0] & 4) != 0));
                return new Splat(this.addResultInstr(new BuildSplatInstr(this.temp(), (Operand)array2, false)));
            }
            case ARRAYNODE: {
                return new Array(this.buildCallArgsArray((ListNode)args2, flags2));
            }
            case SPLATNODE: {
                flags2[0] = flags2[0] | 1;
                return new Splat(this.addResultInstr(new BuildSplatInstr(this.temp(), this.build(args2), false)));
            }
        }
        return this.build(args2);
    }

    @Override
    protected void buildAssignment(Node node, Operand rhsVal) {
        switch (node.getNodeType()) {
            case ATTRASSIGNNODE: {
                this.buildAttrAssignAssignment(node, rhsVal);
                break;
            }
            case CLASSVARASGNNODE: {
                this.addInstr(new PutClassVariableInstr(this.classVarDefinitionContainer(), ((ClassVarAsgnNode)node).getName(), rhsVal));
                break;
            }
            case CONSTDECLNODE: {
                this.buildConstDeclAssignment((ConstDeclNode)node, rhsVal);
                break;
            }
            case DASGNNODE: {
                DAsgnNode variable = (DAsgnNode)node;
                this.copy(this.getLocalVariable(variable.getName(), variable.getDepth()), rhsVal);
                break;
            }
            case GLOBALASGNNODE: {
                this.addInstr(new PutGlobalVarInstr(((GlobalAsgnNode)node).getName(), rhsVal));
                break;
            }
            case INSTASGNNODE: {
                this.addInstr(new PutFieldInstr(this.buildSelf(), ((InstAsgnNode)node).getName(), rhsVal));
                break;
            }
            case LOCALASGNNODE: {
                LocalAsgnNode localVariable = (LocalAsgnNode)node;
                this.copy(this.getLocalVariable(localVariable.getName(), localVariable.getDepth()), rhsVal);
                break;
            }
            case ZEROARGNODE: {
                throw this.notCompilable("Shouldn't get here; zeroarg does not do assignment", node);
            }
            case MULTIPLEASGNNODE: {
                this.buildMultipleAssignment((MultipleAsgnNode)node, this.addResultInstr(new ToAryInstr(this.temp(), rhsVal)));
                break;
            }
            default: {
                throw this.notCompilable("Can't build assignment node", node);
            }
        }
    }

    protected LocalVariable getBlockArgVariable(RubySymbol name2, int depth) {
        if (!(this.scope instanceof IRFor)) {
            throw this.notCompilable("Cannot ask for block-arg variable in 1.9 mode", null);
        }
        return this.getLocalVariable(name2, depth);
    }

    protected Variable receiveBlockArg(Variable v, Operand argsArray, int argIndex, boolean isSplat) {
        if (argsArray != null) {
            if (isSplat) {
                this.addInstr(new RestArgMultipleAsgnInstr(v, argsArray, argIndex));
            } else {
                this.addInstr(new ReqdArgMultipleAsgnInstr(v, argsArray, argIndex));
            }
        } else {
            Variable keywords = this.copy(UndefinedValue.UNDEFINED);
            this.addInstr(isSplat ? new ReceiveRestArgInstr(v, keywords, argIndex, argIndex) : new ReceivePreReqdArgInstr(v, keywords, argIndex));
        }
        return v;
    }

    public void buildBlockArgsAssignment(Node node, Operand argsArray, int argIndex, boolean isSplat) {
        switch (node.getNodeType()) {
            case ATTRASSIGNNODE: {
                this.buildAttrAssignAssignment(node, this.receiveBlockArg(this.temp(), argsArray, argIndex, isSplat));
                break;
            }
            case DASGNNODE: 
            case LOCALASGNNODE: {
                this.receiveBlockArg(this.getBlockArgVariable(((INameNode)((Object)node)).getName(), ((IScopedNode)((Object)node)).getDepth()), argsArray, argIndex, isSplat);
                break;
            }
            case CLASSVARASGNNODE: {
                this.addInstr(new PutClassVariableInstr(this.classVarDefinitionContainer(), ((ClassVarAsgnNode)node).getName(), (Operand)this.receiveBlockArg(this.temp(), argsArray, argIndex, isSplat)));
                break;
            }
            case CONSTDECLNODE: {
                this.buildConstDeclAssignment((ConstDeclNode)node, this.receiveBlockArg(this.temp(), argsArray, argIndex, isSplat));
                break;
            }
            case GLOBALASGNNODE: {
                this.addInstr(new PutGlobalVarInstr(((GlobalAsgnNode)node).getName(), (Operand)this.receiveBlockArg(this.temp(), argsArray, argIndex, isSplat)));
                break;
            }
            case INSTASGNNODE: {
                this.addInstr(new PutFieldInstr(this.buildSelf(), ((InstAsgnNode)node).getName(), (Operand)this.receiveBlockArg(this.temp(), argsArray, argIndex, isSplat)));
                break;
            }
            case ZEROARGNODE: {
                throw this.notCompilable("Shouldn't get here; zeroarg does not do assignment", node);
            }
            case MULTIPLEASGNNODE: {
                ListNode sourceArray = ((MultipleAsgnNode)node).getPre();
                int i2 = 0;
                for (Node an : sourceArray.children()) {
                    this.buildBlockArgsAssignment(an, null, i2, false);
                    ++i2;
                }
                break;
            }
            default: {
                throw this.notCompilable("Can't build assignment node", node);
            }
        }
    }

    public Operand buildAlias(AliasNode alias) {
        return this.buildAlias(this.build(alias.getNewName()), this.build(alias.getOldName()));
    }

    public Operand buildAnd(AndNode node) {
        return this.buildAnd(this.build(node.getFirstNode()), () -> this.build(node.getSecondNode()), this.binaryType(node.getFirstNode()));
    }

    public Operand buildArray(ArrayNode node, boolean operandOnly) {
        Node[] nodes = node.children();
        Operand[] elts = new Operand[nodes.length];
        boolean containsAssignments = node.containsVariableAssignment();
        Operand keywordRestSplat = null;
        for (int i2 = 0; i2 < nodes.length; ++i2) {
            elts[i2] = this.buildWithOrder(nodes[i2], containsAssignments);
            if (!(nodes[i2] instanceof HashNode) || !((HashNode)nodes[i2]).hasOnlyRestKwargs()) continue;
            keywordRestSplat = elts[i2];
        }
        if (keywordRestSplat != null) {
            Variable test2 = this.addResultInstr(new RuntimeHelperCall(this.temp(), RuntimeHelperCall.Methods.IS_HASH_EMPTY, new Operand[]{keywordRestSplat}));
            Variable result2 = this.temp();
            this.if_else(test2, this.tru(), () -> this.copy(result2, new Array(IRBuilderAST.removeArg(elts))), () -> this.copy(result2, new Array(elts)));
            return result2;
        }
        Array array2 = new Array(elts);
        return operandOnly ? array2 : this.copy(array2);
    }

    public Operand buildArgsCat(Variable result2, ArgsCatNode argsCatNode) {
        if (result2 == null) {
            result2 = this.temp();
        }
        Operand lhs = this.build(argsCatNode.getFirstNode());
        Operand rhs = this.build(argsCatNode.getSecondNode());
        return this.addResultInstr(new BuildCompoundArrayInstr(result2, lhs, rhs, false, false));
    }

    public Operand buildArgsPush(Variable result2, ArgsPushNode node) {
        if (result2 == null) {
            result2 = this.temp();
        }
        Operand lhs = this.build(node.getFirstNode());
        Operand rhs = this.build(node.getSecondNode());
        return this.addResultInstr(new BuildCompoundArrayInstr(result2, lhs, rhs, true, false));
    }

    private Operand buildAttrAssign(Variable result2, AttrAssignNode node) {
        return this.buildAttrAssign(result2, node.getReceiverNode(), node.getArgsNode(), node.getBlockNode(), node.getName(), node.isLazy(), node.containsVariableAssignment());
    }

    public Operand buildAttrAssignAssignment(Node node, Operand value2) {
        AttrAssignNode attrAssignNode = (AttrAssignNode)node;
        Operand obj = this.build(attrAssignNode.getReceiverNode());
        int[] flags2 = new int[]{0};
        Operand[] args2 = this.setupCallArgs(attrAssignNode.getArgsNode(), flags2);
        args2 = IRBuilderAST.addArg(args2, value2);
        this.addInstr(AttrAssignInstr.create(this.scope, obj, attrAssignNode.getName(), args2, flags2[0], this.scope.maybeUsingRefinements()));
        return value2;
    }

    public Operand buildBackref(Variable result2, BackRefNode node) {
        if (result2 == null) {
            result2 = this.temp();
        }
        return this.addResultInstr(new BuildBackrefInstr(result2, node.getType()));
    }

    public Operand buildBegin(BeginNode beginNode) {
        return this.build(beginNode.getBodyNode());
    }

    public Operand buildBignum(BignumNode node) {
        return new Bignum(node.getValue());
    }

    public Operand buildBlock(BlockNode node) {
        Operand retVal = null;
        for (Node child : node.children()) {
            retVal = this.build(child);
        }
        return retVal;
    }

    public Operand buildBreak(BreakNode node) {
        return this.buildBreak(() -> this.build(node.getValueNode()), node.getLine());
    }

    public Operand buildCall(Variable aResult, CallNode callNode, Label lazyLabel, Label endLabel) {
        Node arg0;
        ArrayNode argsAry;
        Variable result2;
        RubySymbol name2 = this.methodName = callNode.getName();
        Node receiverNode = callNode.getReceiverNode();
        if (receiverNode instanceof SelfNode) {
            FCallNode fcall = new FCallNode(callNode.getLine(), callNode.getName(), callNode.getArgsNode(), callNode.getIterNode());
            return this.buildFCall(aResult, fcall);
        }
        String id2 = name2.idString();
        if (Options.IR_STRING_FREEZE.load().booleanValue() && receiverNode instanceof StrNode && (id2.equals("freeze") || id2.equals("-@"))) {
            StrNode asString = (StrNode)receiverNode;
            return new FrozenString(asString.getValue(), asString.getCodeRange(), this.scope.getFile(), asString.getLine());
        }
        boolean compileLazyLabel = false;
        if (callNode.isLazy() && lazyLabel == null) {
            compileLazyLabel = true;
            lazyLabel = this.getNewLabel();
            endLabel = this.getNewLabel();
        }
        Operand receiver2 = receiverNode instanceof CallNode && ((CallNode)receiverNode).isLazy() ? this.buildLazyWithOrder((CallNode)receiverNode, lazyLabel, endLabel, callNode.containsVariableAssignment()) : this.buildWithOrder(receiverNode, callNode.containsVariableAssignment());
        Variable variable = result2 = aResult == null ? this.temp() : aResult;
        if (!callNode.isLazy() && id2.equals("[]") && callNode.getArgsNode() instanceof ArrayNode && (argsAry = (ArrayNode)callNode.getArgsNode()).size() == 1 && (arg0 = argsAry.get(0)) instanceof StrNode && !((StrNode)arg0).isFrozen() && !this.scope.maybeUsingRefinements() && callNode.getIterNode() == null) {
            StrNode keyNode = (StrNode)argsAry.get(0);
            FrozenString key2 = new FrozenString(keyNode.getValue(), keyNode.getCodeRange(), this.scope.getFile(), keyNode.getLine());
            this.addInstr(ArrayDerefInstr.create(this.scope, result2, receiver2, key2, 0));
            return result2;
        }
        if (callNode.isLazy()) {
            this.addInstr(new BNilInstr(lazyLabel, receiver2));
        }
        this.createCall(result2, receiver2, CallType.NORMAL, name2, callNode.getArgsNode(), callNode.getIterNode(), callNode.getLine(), callNode.isNewline());
        if (compileLazyLabel) {
            this.addInstr(new JumpInstr(endLabel));
            this.addInstr(new LabelInstr(lazyLabel));
            this.addInstr(new CopyInstr(result2, this.nil()));
            this.addInstr(new LabelInstr(endLabel));
        }
        return result2;
    }

    @Override
    protected boolean isNilRest(Node rest) {
        return rest instanceof NilRestArgNode;
    }

    @Override
    protected void buildAssocs(Label testEnd, Operand original, Variable result2, HashNode assocs, boolean inAlteration, boolean isSinglePattern, Variable errorString, boolean hasRest, Variable d) {
        List<KeyValuePair<Node, Node>> kwargs = assocs.getPairs();
        for (KeyValuePair<Node, Node> pair : kwargs) {
            Operand key2 = this.build(pair.getKey());
            this.call(result2, (Operand)d, "key?", key2);
            this.copy(errorString, key2);
            this.cond_ne(testEnd, result2, this.tru());
            String method2 = hasRest ? "delete" : "[]";
            Variable value2 = this.call(this.temp(), (Operand)d, method2, key2);
            this.buildPatternEach(testEnd, result2, original, this.copy(this.nil()), (Operand)value2, pair.getValue(), inAlteration, isSinglePattern, errorString);
            this.cond_ne(testEnd, result2, this.tru());
        }
    }

    @Override
    protected Variable buildPatternEach(Label testEnd, Variable result2, Operand original, Variable deconstructed, Operand value2, Node exprNodes, boolean inAlternation, boolean isSinglePattern, Variable errorString) {
        if (exprNodes instanceof ArrayPatternNode) {
            ArrayPatternNode node = (ArrayPatternNode)exprNodes;
            this.buildArrayPattern(testEnd, result2, deconstructed, node.getConstant(), node.getPre(), node.getRestArg(), node.getPost(), value2, inAlternation, isSinglePattern, errorString);
        } else if (exprNodes instanceof HashPatternNode) {
            HashPatternNode node = (HashPatternNode)exprNodes;
            this.buildHashPattern(testEnd, result2, deconstructed, node.getConstant(), node.getKeywordArgs(), node.getKeys(), node.getRestArg(), value2, inAlternation, isSinglePattern, errorString);
        } else if (exprNodes instanceof FindPatternNode) {
            FindPatternNode node = (FindPatternNode)exprNodes;
            this.buildFindPattern(testEnd, result2, deconstructed, node.getConstant(), node.getPreRestArg(), node.getArgs(), node.getPostRestArg(), value2, inAlternation, isSinglePattern, errorString);
        } else if (exprNodes instanceof HashNode) {
            KeyValuePair<Node, Node> pair = ((HashNode)exprNodes).getPairs().get(0);
            this.buildPatternEachHash(testEnd, result2, original, deconstructed, value2, pair.getKey(), pair.getValue(), inAlternation, isSinglePattern, errorString);
        } else if (exprNodes instanceof IfNode) {
            IfNode node = (IfNode)exprNodes;
            this.buildPatternEachIf(result2, original, deconstructed, value2, node.getCondition(), node.getThenBody(), node.getElseBody(), inAlternation, isSinglePattern, errorString);
        } else if (exprNodes instanceof LocalAsgnNode) {
            LocalAsgnNode node = (LocalAsgnNode)exprNodes;
            this.buildPatternLocal(value2, node.getName(), node.getLine(), node.getDepth(), inAlternation);
        } else if (!(exprNodes instanceof StarNode)) {
            if (exprNodes instanceof DAsgnNode) {
                DAsgnNode node = (DAsgnNode)exprNodes;
                this.buildPatternLocal(value2, node.getName(), node.getLine(), node.getDepth(), inAlternation);
            } else if (exprNodes instanceof OrNode) {
                this.buildPatternOr(testEnd, original, result2, deconstructed, value2, ((OrNode)exprNodes).getFirstNode(), ((OrNode)exprNodes).getSecondNode(), isSinglePattern, errorString);
            } else {
                Operand expression = this.build(exprNodes);
                boolean needsSplat = exprNodes instanceof ArgsPushNode || exprNodes instanceof SplatNode || exprNodes instanceof ArgsCatNode;
                this.addInstr(new EQQInstr(this.scope, result2, expression, value2, needsSplat, true, this.scope.maybeUsingRefinements()));
                if (isSinglePattern) {
                    this.buildPatternSetEQQError(errorString, result2, original, expression, value2);
                }
            }
        }
        return result2;
    }

    @Override
    protected Node getInExpression(Node node) {
        return ((InNode)node).getExpression();
    }

    @Override
    protected Node getInBody(Node node) {
        return ((InNode)node).getBody();
    }

    @Override
    protected boolean isBareStar(Node node) {
        return node instanceof StarNode;
    }

    public Operand buildPatternCase(PatternCaseNode node) {
        return this.buildPatternCase(node.getCaseNode(), node.getCases(), node.getElseNode());
    }

    public Operand buildCase(CaseNode caseNode) {
        if (caseNode.getCaseNode() != null && !this.scope.maybeUsingRefinements()) {
            Enum seenType = null;
            for (Node aCase : caseNode.getCases().children()) {
                WhenNode whenNode = (WhenNode)aCase;
                NodeType exprNodeType = whenNode.getExpressionNodes().getNodeType();
                if (seenType == null) {
                    seenType = exprNodeType;
                    continue;
                }
                if (seenType == exprNodeType) continue;
                seenType = null;
                break;
            }
            if (seenType != null) {
                switch (6.$SwitchMap$org$jruby$ast$NodeType[seenType.ordinal()]) {
                    case 36: {
                        return this.buildOptimizedCaseWhen(caseNode, RubyFixnum.class, n -> ((FixnumNode)n).getValue());
                    }
                    case 82: {
                        return this.buildOptimizedCaseWhen(caseNode, RubySymbol.class, n -> ((SymbolNode)n).getName().getId());
                    }
                }
            }
        }
        return this.buildCase(caseNode.getCaseNode(), caseNode.getCases().children(), caseNode.getElseNode());
    }

    @Override
    protected Node whenBody(WhenNode when) {
        return when.getBodyNode();
    }

    @Override
    protected boolean containsVariableAssignment(Node node) {
        return node.containsVariableAssignment();
    }

    @Override
    protected Operand frozen_string(Node node) {
        ((StrNode)node).setFrozen(true);
        return this.buildStrRaw((StrNode)node);
    }

    @Override
    protected int getLine(Node node) {
        return node.getLine();
    }

    private void buildWhenSplatValues(Variable eqqResult, Node node, Operand testValue, Label bodyLabel, Set<IRubyObject> seenLiterals, Map<IRubyObject, Integer> origLocs) {
        if (node instanceof ListNode && !(node instanceof DNode) && !(node instanceof ArrayNode)) {
            this.buildWhenValues(eqqResult, ((ListNode)node).children(), testValue, bodyLabel, seenLiterals, origLocs);
        } else if (node instanceof SplatNode) {
            this.buildWhenValue(eqqResult, testValue, bodyLabel, node, seenLiterals, origLocs, true);
        } else if (node instanceof ArgsCatNode) {
            ArgsCatNode catNode = (ArgsCatNode)node;
            this.buildWhenSplatValues(eqqResult, catNode.getFirstNode(), testValue, bodyLabel, seenLiterals, origLocs);
            this.buildWhenSplatValues(eqqResult, catNode.getSecondNode(), testValue, bodyLabel, seenLiterals, origLocs);
        } else if (node instanceof ArgsPushNode) {
            ArgsPushNode pushNode = (ArgsPushNode)node;
            this.buildWhenSplatValues(eqqResult, pushNode.getFirstNode(), testValue, bodyLabel, seenLiterals, origLocs);
            this.buildWhenValue(eqqResult, testValue, bodyLabel, pushNode.getSecondNode(), seenLiterals, origLocs, false);
        } else {
            this.buildWhenValue(eqqResult, testValue, bodyLabel, node, seenLiterals, origLocs, true);
        }
    }

    @Override
    protected void buildWhenArgs(WhenNode whenNode, Operand testValue, Label bodyLabel, Set<IRubyObject> seenLiterals, Map<IRubyObject, Integer> origLocs) {
        Variable eqqResult = this.temp();
        Node exprNodes = whenNode.getExpressionNodes();
        if (exprNodes instanceof ListNode && !(exprNodes instanceof DNode) && !(exprNodes instanceof ArrayNode) && !(exprNodes instanceof ZArrayNode)) {
            this.buildWhenValues(eqqResult, ((ListNode)exprNodes).children(), testValue, bodyLabel, seenLiterals, origLocs);
        } else if (exprNodes instanceof ArgsPushNode || exprNodes instanceof SplatNode || exprNodes instanceof ArgsCatNode) {
            this.buildWhenSplatValues(eqqResult, exprNodes, testValue, bodyLabel, seenLiterals, origLocs);
        } else {
            this.buildWhenValue(eqqResult, testValue, bodyLabel, exprNodes, seenLiterals, origLocs, false);
        }
    }

    @Override
    protected IRubyObject getWhenLiteral(Node node) {
        Ruby runtime2 = this.scope.getManager().getRuntime();
        switch (node.getNodeType()) {
            case FIXNUMNODE: {
                return runtime2.newFixnum(((FixnumNode)node).getValue());
            }
            case FLOATNODE: {
                return runtime2.newFloat(((FloatNode)node).getValue());
            }
            case BIGNUMNODE: {
                return new RubyBignum(runtime2, ((BignumNode)node).getValue());
            }
            case COMPLEXNODE: {
                return RubyComplex.newComplexRaw(runtime2, this.getWhenLiteral(((ComplexNode)node).getNumber()));
            }
            case RATIONALNODE: {
                return RubyRational.newRationalRaw(runtime2, this.getWhenLiteral(((RationalNode)node).getDenominator()), this.getWhenLiteral(((RationalNode)node).getNumerator()));
            }
            case NILNODE: {
                return runtime2.getNil();
            }
            case TRUENODE: {
                return runtime2.getTrue();
            }
            case FALSENODE: {
                return runtime2.getFalse();
            }
            case SYMBOLNODE: {
                return ((SymbolNode)node).getName();
            }
            case STRNODE: {
                return runtime2.newString(((StrNode)node).getValue());
            }
        }
        return null;
    }

    @Override
    protected boolean isLiteralString(Node node) {
        return node instanceof StrNode;
    }

    private <T extends Node> Variable buildOptimizedCaseWhen(CaseNode caseNode, Class caseClass, Function<T, Long> caseFunction) {
        Operand value2 = this.build(caseNode.getCaseNode());
        HashMap<Node, Label> nodeBodies = new HashMap<Node, Label>();
        Map<Integer, Tuple<Operand, Label>> jumpTable = this.gatherLiteralWhenBodies(caseNode, nodeBodies, caseFunction);
        Map.Entry<Integer, Tuple<Operand, Label>>[] jumpEntries = IRBuilderAST.sortJumpEntries(jumpTable);
        Label endLabel = this.getNewLabel();
        boolean hasElse = caseNode.getElseNode() != null;
        Label elseLabel = this.getNewLabel();
        Variable result2 = this.temp();
        this.buildOptimizedSwitch(jumpTable, jumpEntries, elseLabel, value2, caseClass);
        return this.buildStandardCaseWhen(caseNode, nodeBodies, endLabel, hasElse, elseLabel, value2, result2);
    }

    private Operand buildOptimizedWhenOperand(Node node) {
        if (node instanceof SymbolNode) {
            return this.buildSymbol((SymbolNode)node);
        }
        if (node instanceof FixnumNode) {
            return this.buildFixnum((FixnumNode)node);
        }
        throw new NotCompilableException("unexpected optimized when value encountered: " + node);
    }

    private <T extends Node> Map<Integer, Tuple<Operand, Label>> gatherLiteralWhenBodies(CaseNode caseNode, Map<Node, Label> nodeBodies, Function<T, Long> caseFunction) {
        HashMap<Integer, Tuple<Operand, Label>> jumpTable = new HashMap<Integer, Tuple<Operand, Label>>();
        HashMap<Integer, WhenNode> origTable = new HashMap<Integer, WhenNode>();
        for (Node aCase : caseNode.getCases().children()) {
            WhenNode whenNode = (WhenNode)aCase;
            Label bodyLabel = this.getNewLabel();
            Node expr = whenNode.getExpressionNodes();
            long exprLong = caseFunction.apply(expr);
            if (exprLong > Integer.MAX_VALUE) {
                throw this.notCompilable("optimized case has long-ranged value", caseNode);
            }
            if (jumpTable.get((int)exprLong) == null) {
                jumpTable.put((int)exprLong, new Tuple<Operand, Label>(this.buildOptimizedWhenOperand(expr), bodyLabel));
                origTable.put((int)exprLong, whenNode);
                nodeBodies.put(whenNode, bodyLabel);
                continue;
            }
            this.getManager().getRuntime().getWarnings().warning(IRubyWarnings.ID.MISCELLANEOUS, this.getFileName(), expr.getLine() + 1, "duplicated 'when' clause with line " + (((Node)origTable.get((int)exprLong)).getLine() + 1) + " is ignored");
        }
        return jumpTable;
    }

    private static Map.Entry<Integer, Tuple<Operand, Label>>[] sortJumpEntries(Map<Integer, Tuple<Operand, Label>> jumpTable) {
        Map.Entry[] jumpEntries = jumpTable.entrySet().toArray(new Map.Entry[jumpTable.size()]);
        Arrays.sort(jumpEntries, Comparator.comparingInt(Map.Entry::getKey));
        return jumpEntries;
    }

    private void buildOptimizedSwitch(Map<Integer, Tuple<Operand, Label>> jumpTable, Map.Entry<Integer, Tuple<Operand, Label>>[] jumpEntries, Label elseLabel, Operand value2, Class valueClass) {
        Label eqqPath = this.getNewLabel();
        int[] jumps = new int[jumpTable.size()];
        Operand[] operands = new Operand[jumpTable.size()];
        Label[] targets = new Label[jumps.length];
        int i2 = 0;
        for (Map.Entry<Integer, Tuple<Operand, Label>> jumpEntry : jumpEntries) {
            jumps[i2] = jumpEntry.getKey();
            Tuple<Operand, Label> tuple = jumpEntry.getValue();
            operands[i2] = (Operand)tuple.a;
            targets[i2] = (Label)tuple.b;
            ++i2;
        }
        this.addInstr(new BSwitchInstr(jumps, operands, value2, eqqPath, targets, elseLabel, valueClass));
        this.addInstr(new LabelInstr(eqqPath));
    }

    private Variable buildStandardCaseWhen(CaseNode caseNode, Map<Node, Label> nodeBodies, Label endLabel, boolean hasElse, Label elseLabel, Operand value2, Variable result2) {
        ArrayList<Label> labels = new ArrayList<Label>();
        HashMap<Label, Node> bodies = new HashMap<Label, Node>();
        for (Node aCase : caseNode.getCases().children()) {
            WhenNode whenNode = (WhenNode)aCase;
            Label bodyLabel = nodeBodies.get(whenNode);
            if (bodyLabel == null) {
                bodyLabel = this.getNewLabel();
            }
            Variable eqqResult = this.temp();
            labels.add(bodyLabel);
            Operand expression = this.build(whenNode.getExpressionNodes());
            if (expression instanceof MutableString) {
                expression = ((MutableString)expression).frozenString;
            }
            this.addInstr(new EQQInstr(this.scope, eqqResult, expression, value2, false, false, this.scope.maybeUsingRefinements()));
            this.addInstr(IRBuilderAST.createBranch(eqqResult, this.tru(), bodyLabel));
            bodies.put(bodyLabel, whenNode.getBodyNode());
        }
        this.addInstr(new JumpInstr(elseLabel));
        if (hasElse) {
            labels.add(elseLabel);
            bodies.put(elseLabel, caseNode.getElseNode());
        }
        for (Label whenLabel : labels) {
            this.addInstr(new LabelInstr(whenLabel));
            Operand bodyValue = this.build((Node)bodies.get(whenLabel));
            if (bodyValue == null) continue;
            this.addInstr(new CopyInstr(result2, bodyValue));
            this.addInstr(new JumpInstr(endLabel));
        }
        if (!hasElse) {
            this.addInstr(new LabelInstr(elseLabel));
            this.addInstr(new CopyInstr(result2, this.nil()));
            this.addInstr(new JumpInstr(endLabel));
        }
        this.addInstr(new LabelInstr(endLabel));
        return result2;
    }

    public Operand buildClass(ClassNode node) {
        return this.buildClass(node.getCPath().getName().getBytes(), node.getSuperNode(), node.getCPath(), node.getBodyNode(), node.getScope(), node.getLine(), node.getEndLine());
    }

    public Operand buildSClass(SClassNode node) {
        return this.buildSClass(node.getReceiverNode(), node.getBodyNode(), node.getScope(), node.getLine(), node.getEndLine());
    }

    public Operand buildClassVar(Variable result2, ClassVarNode node) {
        return this.buildClassVar(result2, node.getName());
    }

    public Operand buildClassVarAsgn(ClassVarAsgnNode node) {
        return this.buildClassVarAsgn(node.getName(), node.getValueNode());
    }

    public Operand buildConstDecl(ConstDeclNode node) {
        return this.buildConstDeclAssignment(node, this.build(node.getValueNode()));
    }

    public Operand buildConstDeclAssignment(ConstDeclNode constDeclNode, Operand value2) {
        Node constNode = constDeclNode.getConstNode();
        if (constNode == null) {
            return this.putConstant(constDeclNode.getName(), value2);
        }
        return this.putConstant((Colon3Node)constNode, value2);
    }

    @Override
    protected Operand putConstant(Colon3Node colonNode, Operand value2) {
        if (colonNode.getNodeType() == NodeType.COLON2NODE) {
            Colon2Node colon2Node = (Colon2Node)colonNode;
            return this.putConstant(this.build(colon2Node.getLeftNode()), colon2Node.getName(), value2);
        }
        return this.putConstant(this.getManager().getObjectClass(), colonNode.getName(), value2);
    }

    public Operand buildColon2(Variable result2, Colon2Node colon2) {
        Node lhs = colon2.getLeftNode();
        if (lhs == null) {
            return this.searchConst(result2, colon2.getName());
        }
        return this.searchModuleForConst(result2, this.build(lhs), colon2.getName());
    }

    public Operand buildColon3(Variable result2, Colon3Node node) {
        return this.searchModuleForConst(result2, this.getManager().getObjectClass(), node.getName());
    }

    public Operand buildComplex(ComplexNode node) {
        return new Complex((ImmutableLiteral)this.build(node.getNumber()));
    }

    @Override
    protected boolean needsDefinitionCheck(Node node) {
        return node.needsDefinitionCheck();
    }

    @Override
    protected Operand buildGetDefinition(Node node) {
        if (node == null) {
            return new FrozenString("expression");
        }
        switch (node.getNodeType()) {
            case CLASSVARASGNNODE: 
            case CONSTDECLNODE: 
            case DASGNNODE: 
            case GLOBALASGNNODE: 
            case INSTASGNNODE: 
            case LOCALASGNNODE: 
            case MULTIPLEASGNNODE: 
            case OPASGNANDNODE: 
            case OPASGNNODE: 
            case OPASGNORNODE: 
            case OPELEMENTASGNNODE: 
            case CLASSVARDECLNODE: {
                return new FrozenString(DefinedMessage.ASSIGNMENT.getText());
            }
            case ANDNODE: 
            case DREGEXPNODE: 
            case DSTRNODE: 
            case ORNODE: {
                return new FrozenString(DefinedMessage.EXPRESSION.getText());
            }
            case FALSENODE: {
                return new FrozenString(DefinedMessage.FALSE.getText());
            }
            case DVARNODE: 
            case LOCALVARNODE: {
                return new FrozenString(DefinedMessage.LOCAL_VARIABLE.getText());
            }
            case MATCH2NODE: 
            case MATCH3NODE: {
                return new FrozenString(DefinedMessage.METHOD.getText());
            }
            case NILNODE: {
                return new FrozenString(DefinedMessage.NIL.getText());
            }
            case SELFNODE: {
                return new FrozenString(DefinedMessage.SELF.getText());
            }
            case TRUENODE: {
                return new FrozenString(DefinedMessage.TRUE.getText());
            }
            case ARRAYNODE: {
                ArrayNode array2 = (ArrayNode)node;
                Label undefLabel = this.getNewLabel();
                Label doneLabel = this.getNewLabel();
                Variable tmpVar = this.temp();
                for (Node elt : array2.children()) {
                    Operand result2 = this.buildGetDefinition(elt);
                    this.addInstr(IRBuilderAST.createBranch(result2, this.nil(), undefLabel));
                }
                this.addInstr(new CopyInstr(tmpVar, new FrozenString(DefinedMessage.EXPRESSION.getText())));
                this.addInstr(new JumpInstr(doneLabel));
                this.addInstr(new LabelInstr(undefLabel));
                this.addInstr(new CopyInstr(tmpVar, this.nil()));
                this.addInstr(new LabelInstr(doneLabel));
                return tmpVar;
            }
            case BACKREFNODE: {
                return this.addResultInstr(new RuntimeHelperCall(this.temp(), RuntimeHelperCall.Methods.IS_DEFINED_BACKREF, new Operand[]{new FrozenString(DefinedMessage.GLOBAL_VARIABLE.getText())}));
            }
            case GLOBALVARNODE: {
                return this.buildGlobalVarGetDefinition(((GlobalVarNode)node).getName());
            }
            case NTHREFNODE: {
                return this.addResultInstr(new RuntimeHelperCall(this.temp(), RuntimeHelperCall.Methods.IS_DEFINED_NTH_REF, new Operand[]{this.getManager().newFixnum(((NthRefNode)node).getMatchNumber()), new FrozenString(DefinedMessage.GLOBAL_VARIABLE.getText())}));
            }
            case INSTVARNODE: {
                return this.buildInstVarGetDefinition(((InstVarNode)node).getName());
            }
            case CLASSVARNODE: {
                return this.buildClassVarGetDefinition(((ClassVarNode)node).getName());
            }
            case SUPERNODE: {
                Label undefLabel = this.getNewLabel();
                Variable tmpVar = this.addResultInstr(new RuntimeHelperCall(this.temp(), RuntimeHelperCall.Methods.IS_DEFINED_SUPER, new Operand[]{this.buildSelf(), new FrozenString(DefinedMessage.SUPER.getText())}));
                this.addInstr(IRBuilderAST.createBranch(tmpVar, this.nil(), undefLabel));
                Operand superDefnVal = this.buildGetArgumentDefinition(((SuperNode)node).getArgsNode(), DefinedMessage.SUPER.getText());
                return this.buildDefnCheckIfThenPaths(undefLabel, superDefnVal);
            }
            case VCALLNODE: {
                return this.addResultInstr(new RuntimeHelperCall(this.temp(), RuntimeHelperCall.Methods.IS_DEFINED_METHOD, new Operand[]{this.buildSelf(), new FrozenString(((VCallNode)node).getName()), this.fals(), new FrozenString(DefinedMessage.METHOD.getText())}));
            }
            case YIELDNODE: {
                return this.buildDefinitionCheck(new BlockGivenInstr(this.temp(), (Operand)this.getYieldClosureVariable()), DefinedMessage.YIELD.getText());
            }
            case ZSUPERNODE: {
                return this.addResultInstr(new RuntimeHelperCall(this.temp(), RuntimeHelperCall.Methods.IS_DEFINED_SUPER, new Operand[]{this.buildSelf(), new FrozenString(DefinedMessage.SUPER.getText())}));
            }
            case CONSTNODE: {
                return this.buildConstantGetDefinition(((ConstNode)node).getName());
            }
            case COLON2NODE: 
            case COLON3NODE: {
                final Colon3Node colon = (Colon3Node)node;
                final RubySymbol name2 = colon.getName();
                final Variable errInfo = this.temp();
                this.addInstr(new GetErrorInfoInstr(errInfo));
                IRBuilder.CodeBlock protectedCode = new IRBuilder.CodeBlock(){

                    @Override
                    public Operand run() {
                        if (!(colon instanceof Colon2Node)) {
                            return IRBuilderAST.this.addResultInstr(new RuntimeHelperCall(IRBuilderAST.this.temp(), RuntimeHelperCall.Methods.IS_DEFINED_CONSTANT_OR_METHOD, new Operand[]{IRBuilderAST.this.getManager().getObjectClass(), new FrozenString(name2), new FrozenString(DefinedMessage.CONSTANT.getText()), new FrozenString(DefinedMessage.METHOD.getText())}));
                        }
                        Label bad = IRBuilderAST.this.getNewLabel();
                        Label done = IRBuilderAST.this.getNewLabel();
                        Variable result2 = IRBuilderAST.this.temp();
                        Operand test2 = IRBuilderAST.this.buildGetDefinition(((Colon2Node)colon).getLeftNode());
                        IRBuilderAST.this.addInstr(IRBuilder.createBranch(test2, IRBuilderAST.this.nil(), bad));
                        Operand lhs = IRBuilderAST.this.build(((Colon2Node)colon).getLeftNode());
                        IRBuilderAST.this.addInstr(new RuntimeHelperCall(result2, RuntimeHelperCall.Methods.IS_DEFINED_CONSTANT_OR_METHOD, new Operand[]{lhs, new FrozenString(name2), new FrozenString(DefinedMessage.CONSTANT.getText()), new FrozenString(DefinedMessage.METHOD.getText())}));
                        IRBuilderAST.this.addInstr(new JumpInstr(done));
                        IRBuilderAST.this.addInstr(new LabelInstr(bad));
                        IRBuilderAST.this.addInstr(new CopyInstr(result2, IRBuilderAST.this.nil()));
                        IRBuilderAST.this.addInstr(new LabelInstr(done));
                        return result2;
                    }
                };
                IRBuilder.CodeBlock rescueBlock = new IRBuilder.CodeBlock(){

                    @Override
                    public Operand run() {
                        IRBuilderAST.this.addInstr(new RestoreErrorInfoInstr(errInfo));
                        return IRBuilderAST.this.nil();
                    }
                };
                return this.protectCodeWithRescue(protectedCode, rescueBlock);
            }
            case FCALLNODE: {
                Label undefLabel = this.getNewLabel();
                Variable tmpVar = this.addResultInstr(new RuntimeHelperCall(this.temp(), RuntimeHelperCall.Methods.IS_DEFINED_METHOD, new Operand[]{this.buildSelf(), new Symbol(((FCallNode)node).getName()), this.fals(), new FrozenString(DefinedMessage.METHOD.getText())}));
                this.addInstr(IRBuilderAST.createBranch(tmpVar, this.nil(), undefLabel));
                Operand argsCheckDefn = this.buildGetArgumentDefinition(((FCallNode)node).getArgsNode(), "method");
                return this.buildDefnCheckIfThenPaths(undefLabel, argsCheckDefn);
            }
            case CALLNODE: {
                final CallNode callNode = (CallNode)node;
                IRBuilder.CodeBlock protectedCode = new IRBuilder.CodeBlock(){

                    @Override
                    public Operand run() {
                        Label undefLabel = IRBuilderAST.this.getNewLabel();
                        Operand receiverDefn = IRBuilderAST.this.buildGetDefinition(callNode.getReceiverNode());
                        IRBuilderAST.this.addInstr(IRBuilder.createBranch(receiverDefn, IRBuilderAST.this.nil(), undefLabel));
                        Variable tmpVar = IRBuilderAST.this.temp();
                        IRBuilderAST.this.addInstr(new RuntimeHelperCall(tmpVar, RuntimeHelperCall.Methods.IS_DEFINED_CALL, new Operand[]{IRBuilderAST.this.build(callNode.getReceiverNode()), new Symbol(callNode.getName()), new FrozenString(DefinedMessage.METHOD.getText())}));
                        return IRBuilderAST.this.buildDefnCheckIfThenPaths(undefLabel, tmpVar);
                    }
                };
                IRBuilder.CodeBlock rescueBlock = new IRBuilder.CodeBlock(){

                    @Override
                    public Operand run() {
                        return IRBuilderAST.this.nil();
                    }
                };
                return this.protectCodeWithRescue(protectedCode, rescueBlock);
            }
            case ATTRASSIGNNODE: {
                final AttrAssignNode attrAssign = (AttrAssignNode)node;
                IRBuilder.CodeBlock protectedCode = new IRBuilder.CodeBlock(){

                    @Override
                    public Operand run() {
                        Label undefLabel = IRBuilderAST.this.getNewLabel();
                        Operand receiverDefn = IRBuilderAST.this.buildGetDefinition(attrAssign.getReceiverNode());
                        IRBuilderAST.this.addInstr(IRBuilder.createBranch(receiverDefn, IRBuilderAST.this.nil(), undefLabel));
                        Operand receiver2 = IRBuilderAST.this.build(attrAssign.getReceiverNode());
                        Variable tmpVar = IRBuilderAST.this.addResultInstr(new RuntimeHelperCall(IRBuilderAST.this.temp(), RuntimeHelperCall.Methods.IS_DEFINED_METHOD, new Operand[]{receiver2, new Symbol(attrAssign.getName()), IRBuilderAST.this.tru(), new FrozenString(DefinedMessage.METHOD.getText())}));
                        IRBuilderAST.this.addInstr(IRBuilder.createBranch(tmpVar, IRBuilderAST.this.nil(), undefLabel));
                        return IRBuilderAST.this.buildDefnCheckIfThenPaths(undefLabel, tmpVar);
                    }
                };
                IRBuilder.CodeBlock rescueBlock = () -> this.nil();
                return this.protectCodeWithRescue(protectedCode, rescueBlock);
            }
        }
        return new FrozenString("expression");
    }

    public Operand buildGetArgumentDefinition(Node node, String type2) {
        if (node == null) {
            return new MutableString(type2);
        }
        ImmutableLiteral rv = new FrozenString(type2);
        boolean failPathReqd = false;
        Label failLabel = this.getNewLabel();
        if (node instanceof ArrayNode) {
            for (int i2 = 0; i2 < ((ArrayNode)node).size(); ++i2) {
                Operand def = this.buildGetDefinition(((ArrayNode)node).get(i2));
                if (def == this.nil()) {
                    rv = this.nil();
                    break;
                }
                if (def.hasKnownValue()) continue;
                failPathReqd = true;
                this.addInstr(IRBuilderAST.createBranch(def, this.nil(), failLabel));
            }
        } else {
            Operand def = this.buildGetDefinition(node);
            if (def == this.nil()) {
                rv = this.nil();
            } else if (!def.hasKnownValue()) {
                failPathReqd = true;
                this.addInstr(IRBuilderAST.createBranch(def, this.nil(), failLabel));
            }
        }
        return failPathReqd ? this.buildDefnCheckIfThenPaths(failLabel, rv) : rv;
    }

    public Operand buildDAsgn(DAsgnNode dasgnNode) {
        Operand value2;
        int depth = dasgnNode.getDepth();
        LocalVariable arg2 = this.getLocalVariable(dasgnNode.getName(), depth);
        if (arg2 == (value2 = this.build(dasgnNode.getValueNode()))) {
            return value2;
        }
        this.addInstr(new CopyInstr(arg2, value2));
        return value2;
    }

    @Override
    protected boolean canBeLazyMethod(DefNode node) {
        return !((MethodDefNode)node).containsBreakNext();
    }

    @Override
    public void receiveMethodArgs(DefNode defNode) {
        this.receiveMethodArgs(defNode.getArgsNode());
    }

    public Operand buildDefn(MethodDefNode node) {
        LazyMethodDefinitionAST def = new LazyMethodDefinitionAST(node);
        return this.buildDefn(this.defineNewMethod(def, node.getName().getBytes(), node.getLine(), node.getScope(), true));
    }

    public Operand buildDefs(DefsNode node) {
        LazyMethodDefinitionAST def = new LazyMethodDefinitionAST(node);
        return this.buildDefs(node.getReceiverNode(), this.defineNewMethod(def, node.getName().getBytes(), node.getLine(), node.getScope(), false));
    }

    protected LocalVariable getArgVariable(RubySymbol name2, int depth) {
        return this.scope instanceof IRFor ? this.getLocalVariable(name2, depth) : this.getNewLocalVariable(name2, 0);
    }

    private void addArgReceiveInstr(Variable v, Variable keywords, int argIndex, Signature signature) {
        boolean post;
        boolean bl = post = signature != null;
        if (post) {
            this.addInstr(new ReceivePostReqdArgInstr(v, keywords, argIndex, signature.pre(), signature.opt(), signature.hasRest(), signature.post()));
        } else {
            this.addInstr(new ReceivePreReqdArgInstr(v, keywords, argIndex));
        }
    }

    public void receiveRequiredArg(Node node, Variable keywords, int argIndex, Signature signature) {
        switch (node.getNodeType()) {
            case ARGUMENTNODE: {
                RubySymbol argName = ((ArgumentNode)node).getName();
                if (this.scope instanceof IRMethod) {
                    this.addArgumentDescription(ArgumentType.req, argName);
                }
                this.addArgReceiveInstr(this.argumentResult(argName), keywords, argIndex, signature);
                break;
            }
            case MULTIPLEASGNNODE: {
                MultipleAsgnNode childNode = (MultipleAsgnNode)node;
                Variable v = this.temp();
                this.addArgReceiveInstr(v, keywords, argIndex, signature);
                if (this.scope instanceof IRMethod) {
                    this.addArgumentDescription(ArgumentType.anonreq, null);
                }
                Variable tmp = this.addResultInstr(new ToAryInstr(this.temp(), (Operand)v));
                this.buildMultipleAssignmentArgs(childNode, tmp);
                break;
            }
            default: {
                throw this.notCompilable("Can't build assignment node", node);
            }
        }
    }

    protected void receiveNonBlockArgs(ArgsNode argsNode, Variable keywords) {
        int opt;
        Signature signature = this.scope.getStaticScope().getSignature();
        if (this.scope instanceof IRMethod) {
            this.addInstr(new CheckArityInstr(signature.required(), signature.opt(), signature.hasRest(), signature.keyRest(), keywords));
        } else if (this.scope instanceof IRClosure && argsNode.hasKwargs()) {
            this.addInstr(new CheckArityInstr(signature.required(), signature.opt(), signature.hasRest(), signature.keyRest(), keywords));
        }
        int argIndex = 0;
        Node[] args2 = argsNode.getArgs();
        int preCount = signature.pre();
        int i2 = 0;
        while (i2 < preCount) {
            this.receiveRequiredArg(args2[i2], keywords, argIndex, null);
            ++i2;
            ++argIndex;
        }
        int n = opt = signature.opt() > 0 ? signature.opt() : 0;
        if (opt > 0) {
            int optIndex = argsNode.getOptArgIndex();
            int j = 0;
            while (j < opt) {
                Label variableAssigned = this.getNewLabel();
                OptArgNode optArg = (OptArgNode)args2[optIndex + j];
                RubySymbol argName = optArg.getName();
                Variable argVar = this.argumentResult(argName);
                if (this.scope instanceof IRMethod) {
                    this.addArgumentDescription(ArgumentType.opt, argName);
                }
                this.addInstr(new ReceiveOptArgInstr(argVar, keywords, j, signature.required(), signature.pre()));
                this.addInstr(BNEInstr.create(variableAssigned, argVar, UndefinedValue.UNDEFINED));
                this.addInstr(new CopyInstr(argVar, this.nil()));
                this.build(optArg.getValue());
                this.addInstr(new LabelInstr(variableAssigned));
                ++j;
                ++argIndex;
            }
        }
        if (signature.hasRest()) {
            RestArgNode restArgNode = argsNode.getRestArgNode();
            if (this.scope instanceof IRMethod) {
                this.addArgumentDescription(restArgNode.isAnonymous() ? ArgumentType.anonrest : ArgumentType.rest, restArgNode.getName());
            }
            RubySymbol argName = restArgNode.isAnonymous() ? this.scope.getManager().getRuntime().newSymbol(CommonByteLists.STAR) : restArgNode.getName();
            this.addInstr(new ReceiveRestArgInstr(this.argumentResult(argName), keywords, argIndex, signature.required() + opt));
        }
        int postCount = argsNode.getPostCount();
        int postIndex = argsNode.getPostIndex();
        for (int i3 = 0; i3 < postCount; ++i3) {
            this.receiveRequiredArg(args2[postIndex + i3], keywords, i3, signature);
        }
    }

    protected void receiveBlockArg(ArgsNode argsNode) {
        BlockArgNode blockArg = argsNode.getBlock();
        if (blockArg != null) {
            RubySymbol argName = blockArg.getName();
            Variable blockVar = this.argumentResult(argName);
            if (this.scope instanceof IRMethod) {
                this.addArgumentDescription(ArgumentType.block, argName);
            }
            Variable tmp = this.temp();
            this.addInstr(new LoadImplicitClosureInstr(tmp));
            this.addInstr(new ReifyClosureInstr(blockVar, tmp));
        }
    }

    public void receiveArgs(ArgsNode argsNode) {
        RubySymbol restName;
        Signature signature = this.scope.getStaticScope().getSignature();
        Variable keywords = this.addResultInstr(new ReceiveKeywordsInstr(this.temp(), signature.hasRest(), argsNode.hasKwargs()));
        KeywordRestArgNode keyRest = argsNode.getKeyRest();
        RubySymbol rubySymbol = restName = keyRest == null ? null : keyRest.getName();
        if (restName != null && "nil".equals(restName.idString())) {
            this.if_not(keywords, UndefinedValue.UNDEFINED, () -> this.addRaiseError("ArgumentError", "no keywords accepted"));
        }
        this.receiveNonBlockArgs(argsNode, keywords);
        Node[] args2 = argsNode.getArgs();
        if (argsNode.hasKwargs()) {
            int keywordIndex = argsNode.getKeywordsIndex();
            int keywordsCount = argsNode.getKeywordCount();
            for (int i2 = 0; i2 < keywordsCount; ++i2) {
                KeywordArgNode kwarg = (KeywordArgNode)args2[keywordIndex + i2];
                AssignableNode kasgn = kwarg.getAssignable();
                RubySymbol key2 = ((INameNode)((Object)kasgn)).getName();
                LocalVariable av = this.getNewLocalVariable(key2, 0);
                Label l = this.getNewLabel();
                if (this.scope instanceof IRMethod) {
                    this.addKeyArgDesc(kasgn, key2);
                }
                this.addInstr(new ReceiveKeywordArgInstr(av, keywords, key2));
                this.addInstr(BNEInstr.create(l, av, UndefinedValue.UNDEFINED));
                if (!this.isRequiredKeywordArgumentValue(kasgn)) {
                    this.addInstr(new CopyInstr(av, this.buildNil()));
                    this.build(kasgn);
                } else {
                    this.addInstr(new RaiseRequiredKeywordArgumentError(key2));
                }
                this.addInstr(new LabelInstr(l));
            }
        }
        if (keyRest != null) {
            ArgumentType type2 = restName == null || restName.getBytes().realSize() == 0 ? ArgumentType.anonkeyrest : (restName.getBytes().equals(CommonByteLists.NIL) ? ArgumentType.nokey : ArgumentType.keyrest);
            LocalVariable av = this.getNewLocalVariable(restName, 0);
            if (this.scope instanceof IRMethod) {
                this.addArgumentDescription(type2, restName);
            }
            this.addInstr(new ReceiveKeywordRestArgInstr(av, keywords));
        }
        this.receiveBlockArg(argsNode);
    }

    private void addKeyArgDesc(AssignableNode kasgn, RubySymbol key2) {
        if (this.isRequiredKeywordArgumentValue(kasgn)) {
            this.addArgumentDescription(ArgumentType.keyreq, key2);
        } else {
            this.addArgumentDescription(ArgumentType.key, key2);
        }
    }

    private boolean isRequiredKeywordArgumentValue(AssignableNode kasgn) {
        return kasgn.getValueNode().getNodeType() == NodeType.REQUIRED_KEYWORD_ARGUMENT_VALUE;
    }

    public void buildArgsMasgn(Node node, Operand argsArray, boolean isMasgnRoot, int preArgsCount, int postArgsCount, int index2, boolean isSplat) {
        switch (node.getNodeType()) {
            case DASGNNODE: {
                DAsgnNode dynamicAsgn = (DAsgnNode)node;
                LocalVariable v = this.getArgVariable(dynamicAsgn.getName(), dynamicAsgn.getDepth());
                this.buildSplatForMultiAssign(v, argsArray, preArgsCount, postArgsCount, index2, isSplat);
                break;
            }
            case LOCALASGNNODE: {
                LocalAsgnNode localVariable = (LocalAsgnNode)node;
                LocalVariable v = this.getArgVariable(localVariable.getName(), localVariable.getDepth());
                this.buildSplatForMultiAssign(v, argsArray, preArgsCount, postArgsCount, index2, isSplat);
                break;
            }
            case MULTIPLEASGNNODE: {
                MultipleAsgnNode childNode = (MultipleAsgnNode)node;
                if (!isMasgnRoot) {
                    Variable v = this.buildSplatForMultiAssign(this.temp(), argsArray, preArgsCount, postArgsCount, index2, isSplat);
                    argsArray = this.addResultInstr(new ToAryInstr(this.temp(), (Operand)v));
                }
                this.buildMultipleAssignmentArgs(childNode, argsArray);
                break;
            }
            default: {
                throw this.notCompilable("Shouldn't get here", node);
            }
        }
    }

    private Variable buildSplatForMultiAssign(Variable result2, Operand argsArray, int preArgsCount, int postArgsCount, int index2, boolean isSplat) {
        return isSplat ? this.addResultInstr(new RestArgMultipleAsgnInstr(result2, argsArray, index2, preArgsCount, postArgsCount)) : this.addResultInstr(new ReqdArgMultipleAsgnInstr(result2, argsArray, index2, preArgsCount, postArgsCount));
    }

    public void buildMultipleAssignment(MultipleAsgnNode multipleAsgnNode, Operand values2) {
        ListNode masgnPost;
        ListNode masgnPre = multipleAsgnNode.getPre();
        ArrayList<Tuple<Node, Variable>> assigns = new ArrayList<Tuple<Node, Variable>>();
        int i2 = 0;
        if (masgnPre != null) {
            for (Node an : masgnPre.children()) {
                assigns.add(new Tuple<Node, Variable>(an, this.addResultInstr(new ReqdArgMultipleAsgnInstr(this.temp(), values2, i2))));
                ++i2;
            }
        }
        Node restNode = multipleAsgnNode.getRest();
        int postCount = multipleAsgnNode.getPostCount();
        if (restNode != null && !(restNode instanceof StarNode)) {
            assigns.add(new Tuple<Node, Variable>(restNode, this.addResultInstr(new RestArgMultipleAsgnInstr(this.temp(), values2, 0, i2, postCount))));
        }
        if ((masgnPost = multipleAsgnNode.getPost()) != null) {
            int j = 0;
            for (Node an : masgnPost.children()) {
                assigns.add(new Tuple<Node, Variable>(an, this.addResultInstr(new ReqdArgMultipleAsgnInstr(this.temp(), values2, j, i2, postCount))));
                ++j;
            }
        }
        for (Tuple tuple : assigns) {
            this.buildAssignment((Node)tuple.a, (Operand)tuple.b);
        }
    }

    public void buildMultipleAssignmentArgs(MultipleAsgnNode multipleAsgnNode, Operand argsArray) {
        ListNode masgnPost;
        ArrayList assigns = new ArrayList();
        int i2 = 0;
        ListNode masgnPre = multipleAsgnNode.getPre();
        if (masgnPre != null) {
            for (Node an : masgnPre.children()) {
                this.buildArgsMasgn(an, argsArray, false, -1, -1, i2++, false);
            }
        }
        Node restNode = multipleAsgnNode.getRest();
        int postArgsCount = multipleAsgnNode.getPostCount();
        if (restNode != null && !(restNode instanceof StarNode)) {
            this.buildArgsMasgn(restNode, argsArray, false, i2, postArgsCount, 0, true);
        }
        if ((masgnPost = multipleAsgnNode.getPost()) != null) {
            int j = 0;
            for (Node an : masgnPost.children()) {
                this.buildArgsMasgn(an, argsArray, false, i2, postArgsCount, j, false);
                ++j;
            }
        }
        for (Tuple assign : assigns) {
            this.buildAssignment((Node)assign.a, (Operand)assign.b);
        }
    }

    @Override
    public void receiveMethodArgs(ArgsNode argsNode) {
        this.receiveArgs(argsNode);
    }

    @Override
    protected void receiveForArgs(Node node) {
        this.receiveBlockArgs(node);
    }

    @Override
    protected void receiveBlockArgs(Node args2) {
        if (args2 instanceof ArgsNode) {
            ((IRClosure)this.scope).setArgumentDescriptors(Helpers.argsNodeToArgumentDescriptors((ArgsNode)args2));
            this.receiveArgs((ArgsNode)args2);
        } else {
            this.buildBlockArgsAssignment(args2, null, 0, false);
        }
    }

    public Operand buildDot(DotNode node) {
        return this.buildRange(node.getBeginNode(), node.getEndNode(), node.isExclusive());
    }

    @Override
    protected int dynamicPiece(Operand[] pieces, int i2, Node pieceNode, Encoding _unused) {
        Operand piece;
        int estimatedSize;
        block4: {
            estimatedSize = 4;
            while (true) {
                if (pieceNode instanceof StrNode) {
                    piece = this.buildStrRaw((StrNode)pieceNode);
                    estimatedSize = ((StrNode)pieceNode).getValue().realSize();
                    break block4;
                }
                if (!(pieceNode instanceof EvStrNode)) break;
                if (this.scope.maybeUsingRefinements()) {
                    Variable result2 = this.temp();
                    this.addInstr(new AsStringInstr(this.scope, result2, this.build(((EvStrNode)pieceNode).getBody()), this.scope.maybeUsingRefinements()));
                    piece = result2;
                    break block4;
                }
                pieceNode = ((EvStrNode)pieceNode).getBody();
            }
            piece = this.build(pieceNode);
        }
        if (piece instanceof MutableString) {
            piece = ((MutableString)piece).frozenString;
        }
        pieces[i2] = piece == null ? this.nil() : piece;
        return estimatedSize;
    }

    public Operand buildDRegexp(Variable result2, DRegexpNode node) {
        return this.buildDRegex(result2, node.children(), node.getOptions());
    }

    public Operand buildDStr(Variable result2, DStrNode node) {
        return this.buildDStr(result2, node.children(), node.getEncoding(), node.isFrozen(), node.getLine());
    }

    public Operand buildDSymbol(Variable result2, DSymbolNode node) {
        return this.buildDSymbol(result2, node.children(), node.getEncoding(), node.getLine());
    }

    public Operand buildDVar(DVarNode node) {
        return this.getLocalVariable(node.getName(), node.getDepth());
    }

    public Operand buildDXStr(Variable result2, DXStrNode node) {
        return this.buildDXStr(result2, node.children(), node.getEncoding(), node.getLine());
    }

    public Operand buildEnsureNode(EnsureNode ensureNode) {
        return this.buildEnsureInternal(ensureNode.getBodyNode(), null, null, null, null, false, ensureNode.getEnsureNode(), false, null);
    }

    public Operand buildFCall(Variable result2, FCallNode node) {
        if (result2 == null) {
            result2 = this.temp();
        }
        RubySymbol name2 = this.methodName = node.getName();
        return this.createCall(result2, this.buildSelf(), CallType.FUNCTIONAL, name2, node.getArgsNode(), node.getIterNode(), node.getLine(), node.isNewline());
    }

    @Override
    protected Operand setupCallClosure(Node _unused, Node node) {
        if (node == null) {
            return NullBlock.INSTANCE;
        }
        switch (node.getNodeType()) {
            case ITERNODE: {
                return this.build(node);
            }
            case BLOCKPASSNODE: {
                Node bodyNode = ((BlockPassNode)node).getBodyNode();
                if (bodyNode instanceof SymbolNode && !this.scope.maybeUsingRefinements()) {
                    return new SymbolProc(((SymbolNode)bodyNode).getName());
                }
                if (bodyNode instanceof ArgumentNode && ((ArgumentNode)bodyNode).getName().idString().equals("&")) {
                    return this.getYieldClosureVariable();
                }
                return this.build(bodyNode);
            }
        }
        throw this.notCompilable("ERROR: Encountered a method with a non-block, non-blockpass iter node", node);
    }

    public Operand buildFixnum(FixnumNode node) {
        return this.fix(node.getValue());
    }

    public Operand buildFlip(FlipNode node) {
        return this.buildFlip(node.getBeginNode(), node.getEndNode(), node.isExclusive());
    }

    public Operand buildFloat(FloatNode node) {
        return new Float(node.getValue());
    }

    public Operand buildFor(ForNode node) {
        return this.buildFor(node.getIterNode(), node.getVarNode(), node.getBodyNode(), node.getScope(), Signature.from(node), node.getLine(), node.getEndLine());
    }

    public Operand buildGlobalAsgn(GlobalAsgnNode node) {
        return this.buildGlobalAsgn(node.getName(), node.getValueNode());
    }

    Operand buildGlobalVar(Variable result2, GlobalVarNode node) {
        return this.buildGlobalVar(result2, node.getName());
    }

    public Operand buildHash(HashNode hashNode) {
        ArrayList<KeyValuePair<Operand, Operand>> args2 = new ArrayList<KeyValuePair<Operand, Operand>>();
        boolean hasAssignments = hashNode.containsVariableAssignment();
        Variable hash2 = null;
        Boolean duplicateCheck = this.fals();
        for (KeyValuePair<Node, Node> pair : hashNode.getPairs()) {
            Node key2 = pair.getKey();
            if (key2 == null) {
                Node value2 = pair.getValue();
                Boolean boolean_ = duplicateCheck = value2 instanceof HashNode && ((HashNode)value2).isLiteral() ? this.tru() : this.fals();
                if (hash2 == null) {
                    hash2 = this.copy(new Hash(args2));
                    args2 = new ArrayList();
                } else if (!args2.isEmpty()) {
                    this.addInstr(new RuntimeHelperCall(hash2, RuntimeHelperCall.Methods.MERGE_KWARGS, new Operand[]{hash2, new Hash(args2), duplicateCheck}));
                    args2 = new ArrayList();
                }
                Operand splat = this.buildWithOrder(value2, hasAssignments);
                this.addInstr(new RuntimeHelperCall(hash2, RuntimeHelperCall.Methods.MERGE_KWARGS, new Operand[]{hash2, splat, duplicateCheck}));
                continue;
            }
            Operand keyOperand = this.buildWithOrder(key2, hasAssignments);
            args2.add(new KeyValuePair<Operand, Operand>(keyOperand, this.buildWithOrder(pair.getValue(), hasAssignments)));
        }
        if (hash2 == null) {
            hash2 = this.copy(new Hash(args2));
        } else if (!args2.isEmpty()) {
            this.addInstr(new RuntimeHelperCall(hash2, RuntimeHelperCall.Methods.MERGE_KWARGS, new Operand[]{hash2, new Hash(args2), duplicateCheck}));
        }
        return hash2;
    }

    public Operand buildIf(Variable result2, IfNode ifNode) {
        return this.buildConditional(result2, ifNode.getCondition(), ifNode.getThenBody(), ifNode.getElseBody());
    }

    public Operand buildInstAsgn(InstAsgnNode node) {
        return this.buildInstAsgn(node.getName(), node.getValueNode());
    }

    public Operand buildInstVar(InstVarNode node) {
        return this.buildInstVar(node.getName());
    }

    public Operand buildIter(IterNode iter) {
        return this.buildIter(iter.getVarNode(), iter.getBodyNode(), iter.getScope(), Signature.from(iter), iter.getLine(), iter.getEndLine());
    }

    public Operand buildLiteral(LiteralNode literalNode) {
        return new MutableString(literalNode.getSymbolName());
    }

    public Operand buildLocalAsgn(LocalAsgnNode localAsgnNode) {
        Operand value2;
        LocalVariable variable = this.getLocalVariable(localAsgnNode.getName(), localAsgnNode.getDepth());
        if (variable != (value2 = this.build((Variable)variable, localAsgnNode.getValueNode()))) {
            this.copy(variable, value2);
        }
        return value2;
    }

    public Operand buildLocalVar(LocalVarNode node) {
        return this.getLocalVariable(node.getName(), node.getDepth());
    }

    public Operand buildMatch(Variable result2, MatchNode matchNode) {
        return this.buildMatch(result2, this.build(matchNode.getRegexpNode()));
    }

    public Operand buildMatch2(Variable result2, Match2Node matchNode) {
        Operand receiver2 = this.build(matchNode.getReceiverNode());
        Operand value2 = this.build(matchNode.getValueNode());
        if (result2 == null) {
            result2 = this.temp();
        }
        this.addInstr(new MatchInstr(this.scope, result2, receiver2, value2));
        if (matchNode instanceof Match2CaptureNode) {
            Match2CaptureNode m2c = (Match2CaptureNode)matchNode;
            for (int slot : m2c.getScopeOffsets()) {
                int depth = slot >> 16;
                int offset2 = slot & 0xFFFF;
                RubySymbol var = this.getManager().runtime.newSymbol(this.getVarNameFromScopeTree(this.scope, depth, offset2));
                this.addInstr(new SetCapturedVarInstr(this.getLocalVariable(var, depth), (Operand)result2, var));
            }
        }
        return result2;
    }

    private String getVarNameFromScopeTree(IRScope scope, int depth, int offset2) {
        if (depth == 0) {
            return scope.getStaticScope().getVariables()[offset2];
        }
        return this.getVarNameFromScopeTree(scope.getLexicalParent(), depth - 1, offset2);
    }

    public Operand buildMatch3(Variable result2, Match3Node matchNode) {
        Operand receiver2 = this.build(matchNode.getReceiverNode());
        Operand value2 = this.build(matchNode.getValueNode());
        if (result2 == null) {
            result2 = this.temp();
        }
        return this.addResultInstr(new MatchInstr(this.scope, result2, receiver2, value2));
    }

    @Override
    protected Operand getContainerFromCPath(Node cpath) {
        Node leftNode;
        Operand container = cpath instanceof Colon2Node ? ((leftNode = ((Colon2Node)cpath).getLeftNode()) != null ? this.build(leftNode) : this.findContainerModule()) : this.getManager().getObjectClass();
        return container;
    }

    Operand buildModule(ModuleNode node) {
        return this.buildModule(node.getCPath().getName().getBytes(), node.getCPath(), node.getBodyNode(), node.getScope(), node.getLine(), node.getEndLine());
    }

    public Operand buildNext(NextNode nextNode) {
        return this.buildNext(this.build(nextNode.getValueNode()), nextNode.getLine());
    }

    public Operand buildNthRef(NthRefNode node) {
        return this.buildNthRef(node.getMatchNumber());
    }

    public Operand buildNil() {
        return this.nil();
    }

    public Operand buildOpAsgn(OpAsgnNode node) {
        return this.buildOpAsgn(node.getReceiverNode(), node.getValueNode(), node.getVariableSymbolName(), node.getVariableSymbolNameAsgn(), node.getOperatorSymbolName(), node.isLazy());
    }

    @Override
    protected Operand buildColon2ForConstAsgnDeclNode(Node lhs, Variable valueResult, boolean constMissing) {
        RubySymbol name2 = ((INameNode)((Object)lhs)).getName();
        Variable leftModule = this.copy(lhs instanceof Colon2Node ? this.build(((Colon2Node)lhs).getLeftNode()) : this.getManager().getObjectClass());
        this.addInstr(new SearchModuleForConstInstr(valueResult, leftModule, name2, false, constMissing));
        return leftModule;
    }

    public Operand buildOpAsgnConstDeclNode(OpAsgnConstDeclNode node) {
        if (node.isOr()) {
            return this.buildOpAsgnConstDeclOr(node.getFirstNode(), node.getSecondNode(), ((Colon3Node)node.getFirstNode()).getName());
        }
        if (node.isAnd()) {
            return this.buildOpAsgnConstDeclAnd(node.getFirstNode(), node.getSecondNode(), ((Colon3Node)node.getFirstNode()).getName());
        }
        return this.buildOpAsgnConstDecl((Colon3Node)node.getFirstNode(), ((Colon3Node)node.getFirstNode()).getName(), node.getSecondNode(), node.getSymbolOperator());
    }

    public Operand buildOpAsgnAnd(OpAsgnAndNode node) {
        return this.buildOpAsgnAnd(() -> this.build(node.getFirstNode()), () -> this.build(node.getSecondNode()));
    }

    public Operand buildOpAsgnOr(OpAsgnOrNode orNode) {
        if (!orNode.getFirstNode().needsDefinitionCheck()) {
            return this.buildOpAsgnOr(() -> this.build(orNode.getFirstNode()), () -> this.build(orNode.getSecondNode()));
        }
        return this.buildOpAsgnOrWithDefined(orNode.getFirstNode(), orNode.getSecondNode());
    }

    public Operand buildOpElementAsgn(OpElementAsgnNode node) {
        if (node.isOr()) {
            return this.buildOpElementAsgnWith(node.getReceiverNode(), node.getArgsNode(), node.getBlockNode(), node.getValueNode(), this.tru());
        }
        if (node.isAnd()) {
            return this.buildOpElementAsgnWith(node.getReceiverNode(), node.getArgsNode(), node.getBlockNode(), node.getValueNode(), this.fals());
        }
        return this.buildOpElementAsgnWithMethod(node.getReceiverNode(), node.getArgsNode(), node.getBlockNode(), node.getValueNode(), node.getOperatorSymbolName());
    }

    public Operand buildOr(OrNode node) {
        return this.buildOr(this.build(node.getFirstNode()), () -> this.build(node.getSecondNode()), this.binaryType(node.getFirstNode()));
    }

    private InterpreterContext buildPrePostExeInner(Node body) {
        this.addInstr(new CopyInstr(this.getCurrentModuleVariable(), ScopeModule.SCOPE_MODULE[0]));
        this.build(body);
        this.addInstr(new ReturnInstr(new Nil()));
        this.computeScopeFlagsFrom(this.instructions);
        return this.scope.allocateInterpreterContext(this.instructions, this.temporaryVariableIndex + 1, (EnumSet<IRFlags>)this.flags);
    }

    public Operand buildPostExe(PostExeNode postExeNode) {
        IRScope topLevel = this.scope.getRootLexicalScope();
        IRScope nearestLVarScope = this.scope.getNearestTopLocalVariableScope();
        StaticScope parentScope = nearestLVarScope.getStaticScope();
        StaticScope staticScope = parentScope.duplicate();
        staticScope.setEnclosingScope(parentScope);
        IRClosure endClosure = new IRClosure(this.getManager(), this.scope, postExeNode.getLine(), staticScope, Signature.from(postExeNode), CommonByteLists._END_, true);
        staticScope.setIRScope(endClosure);
        endClosure.setIsEND();
        this.newIRBuilder(this.getManager(), endClosure).buildPrePostExeInner(postExeNode.getBodyNode());
        this.addInstr(new RecordEndBlockInstr(topLevel, new WrappedIRClosure(this.buildSelf(), endClosure)));
        return this.nil();
    }

    @Override
    public Operand buildPreExe(PreExeNode preExeNode) {
        return super.buildPreExe(preExeNode.getBodyNode());
    }

    public Operand buildRational(RationalNode node) {
        return this.buildRational(node.getNumerator(), node.getDenominator());
    }

    public Operand buildRedo(RedoNode redoNode) {
        return this.buildRedo(redoNode.getLine());
    }

    public Operand buildRegexp(RegexpNode reNode) {
        return this.copy(new Regexp(reNode.getValue(), reNode.getOptions()));
    }

    public Operand buildRescue(RescueNode node) {
        RescueBodyNode clause = node.getRescueNode();
        return this.buildEnsureInternal(node.getBodyNode(), node.getElseNode(), this.exceptionNodesFor(clause), this.bodyFor(clause), this.optRescueFor(clause), node instanceof RescueModNode, null, true, null);
    }

    @Override
    protected boolean isSideEffectFree(Node node) {
        return node instanceof SideEffectFree;
    }

    @Override
    protected boolean isErrorInfoGlobal(Node body) {
        String id2;
        if (!(body instanceof GlobalVarNode)) {
            return false;
        }
        switch (id2 = ((GlobalVarNode)body).getName().idString()) {
            case "$!": 
            case "$ERROR_INFO": 
            case "$@": 
            case "$ERROR_POSITION": {
                return true;
            }
        }
        return false;
    }

    private Node[] asList(Node node) {
        if (node == null) {
            return null;
        }
        if (node instanceof ListNode) {
            return ((ListNode)node).children();
        }
        return new Node[]{node};
    }

    protected Node[] exceptionNodesFor(RescueBodyNode node) {
        return this.asList(node.getExceptionNodes());
    }

    @Override
    protected Node bodyFor(RescueBodyNode node) {
        return node.getBodyNode();
    }

    @Override
    protected RescueBodyNode optRescueFor(RescueBodyNode node) {
        return node.getOptRescueNode();
    }

    @Override
    protected Node referenceFor(RescueBodyNode node) {
        return null;
    }

    public Operand buildRetry(RetryNode node) {
        return this.buildRetry(node.getLine());
    }

    public Operand buildReturn(ReturnNode returnNode) {
        Node valueNode = returnNode.getValueNode();
        if (this.isTopLevel() && valueNode != null && !(valueNode instanceof NilImplicitNode)) {
            this.scope.getManager().getRuntime().getWarnings().warn(this.getFileName(), valueNode.getLine() + 1, "argument of top-level return is ignored");
        }
        return this.buildReturn(this.build(valueNode), returnNode.getLine());
    }

    public Operand buildSplat(Variable result2, SplatNode splatNode) {
        if (result2 == null) {
            result2 = this.temp();
        }
        return this.addResultInstr(new BuildSplatInstr(result2, this.build(splatNode.getValue()), true));
    }

    public Operand buildStr(StrNode strNode) {
        Operand literal = this.buildStrRaw(strNode);
        return literal instanceof FrozenString ? literal : this.copy(literal);
    }

    public Operand buildStrRaw(StrNode strNode) {
        if (strNode instanceof FileNode) {
            return new Filename();
        }
        int line = strNode.getLine();
        if (strNode.isFrozen()) {
            return new FrozenString(strNode.getValue(), strNode.getCodeRange(), this.scope.getFile(), line);
        }
        return new MutableString(strNode.getValue(), strNode.getCodeRange(), this.scope.getFile(), line);
    }

    public Operand buildSuper(Variable result2, SuperNode node) {
        return this.buildSuper(result2, node.getIterNode(), node.getArgsNode(), node.getLine(), node.isNewline());
    }

    public Operand buildSValue(Variable result2, SValueNode node) {
        return this.copy(result2, new SValue(this.build(node.getValue())));
    }

    public Operand buildSymbol(SymbolNode node) {
        return new Symbol(node.getName());
    }

    public Operand buildUndef(UndefNode node) {
        return this.buildUndef(this.build(node.getName()));
    }

    public Operand buildUntil(UntilNode node) {
        return this.buildConditionalLoop(node.getConditionNode(), node.getBodyNode(), false, node.evaluateAtStart());
    }

    public Operand buildVAlias(VAliasNode valiasNode) {
        return this.buildVAlias(valiasNode.getNewName(), valiasNode.getOldName());
    }

    public Operand buildVCall(Variable result2, VCallNode node) {
        return this._call(result2, CallType.VARIABLE, this.buildSelf(), node.getName(), new Operand[0]);
    }

    public Operand buildWhile(WhileNode node) {
        return this.buildConditionalLoop(node.getConditionNode(), node.getBodyNode(), true, node.evaluateAtStart());
    }

    public Operand buildXStr(Variable result2, XStrNode node) {
        return this.fcall(result2, (Operand)this.buildSelf(), "`", new FrozenString(node.getValue(), node.getCodeRange(), this.scope.getFile(), node.getLine()));
    }

    public Operand buildYield(Variable result2, YieldNode node) {
        Node onlyArg;
        IRScope hardScope = this.scope.getNearestNonClosurelikeScope();
        if (hardScope instanceof IRScriptBody || hardScope instanceof IRModuleBody) {
            this.throwSyntaxError(node.getLine(), "Invalid yield");
        }
        if (result2 == null) {
            result2 = this.temp();
        }
        boolean unwrap = true;
        Node argNode = node.getArgsNode();
        if (argNode != null && argNode instanceof ArrayNode && ((ArrayNode)argNode).size() == 1 && (!((onlyArg = ((ArrayNode)argNode).getLast()) instanceof HashNode) || ((HashNode)onlyArg).isLiteral())) {
            argNode = onlyArg;
            unwrap = false;
        }
        int[] flags2 = new int[]{0};
        Operand value2 = this.buildYieldArgs(argNode, flags2);
        this.addInstr(new YieldInstr(result2, this.getYieldClosureVariable(), value2, flags2[0], unwrap));
        return result2;
    }

    public Operand buildZArray(Variable result2) {
        return this.copy(result2, new Array());
    }

    @Override
    public Operand buildZSuper(Variable result2, ZSuperNode node) {
        return this.buildZSuper(result2, node.getIterNode());
    }

    private void debug(String message2, Operand ... operands) {
        this.addInstr(new DebugOutputInstr(message2, operands));
    }

    @Override
    protected boolean alwaysFalse(Node node) {
        return node.getNodeType().alwaysFalse();
    }

    @Override
    protected boolean alwaysTrue(Node node) {
        return node.getNodeType().alwaysTrue();
    }

    @Override
    public LocalVariable getLocalVariable(RubySymbol name2, int scopeDepth) {
        return this.scope.getLocalVariable(name2, scopeDepth);
    }

    @Override
    protected void createPrefixFromArgs(ByteList prefix, Node args2) {
        if (args2 instanceof ArgsNode) {
            ArgsNode argsNode = (ArgsNode)args2;
            prefix.append(Stream.of(argsNode.getArgs()).filter(n -> n instanceof INameNode).map(n -> {
                RubySymbol name2 = ((INameNode)((Object)n)).getName();
                return name2 == null ? "(null)" : name2.idString();
            }).collect(Collectors.joining(",")).getBytes());
        }
    }
}

