/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.beats;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.PooledByteBufAllocator;
import java.util.Iterator;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.logstash.beats.Batch;
import org.logstash.beats.Message;

public class V2Batch
implements Batch {
    private static final Logger logger = LogManager.getLogger(V2Batch.class);
    private static volatile int LAST_NOTIFIED_MAX_ORDER = -1;
    private static final int NETTY_MAXIMUM_ORDER = 14;
    private ByteBuf internalBuffer = PooledByteBufAllocator.DEFAULT.buffer();
    private int written = 0;
    private int read = 0;
    private static final int SIZE_OF_INT = 4;
    private int batchSize;
    private int highestSequence = -1;

    public void setProtocol(byte protocol) {
        if (protocol != 50) {
            throw new IllegalArgumentException("Only version 2 protocol is supported");
        }
    }

    @Override
    public byte getProtocol() {
        return 50;
    }

    @Override
    public Iterator<Message> iterator() {
        this.internalBuffer.resetReaderIndex();
        return new Iterator<Message>(){

            @Override
            public boolean hasNext() {
                return V2Batch.this.read < V2Batch.this.written;
            }

            @Override
            public Message next() {
                int sequenceNumber = V2Batch.this.internalBuffer.readInt();
                int readableBytes = V2Batch.this.internalBuffer.readInt();
                Message message = new Message(sequenceNumber, V2Batch.this.internalBuffer.slice(V2Batch.this.internalBuffer.readerIndex(), readableBytes));
                V2Batch.this.internalBuffer.readerIndex(V2Batch.this.internalBuffer.readerIndex() + readableBytes);
                message.setBatch(V2Batch.this);
                V2Batch.this.read++;
                return message;
            }
        };
    }

    @Override
    public int getBatchSize() {
        return this.batchSize;
    }

    @Override
    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    @Override
    public int size() {
        return this.written;
    }

    @Override
    public boolean isEmpty() {
        return this.written == 0;
    }

    @Override
    public boolean isComplete() {
        return this.written == this.batchSize;
    }

    @Override
    public int getHighestSequence() {
        return this.highestSequence;
    }

    void addMessage(int sequenceNumber, ByteBuf buffer, int size) {
        ++this.written;
        if (this.internalBuffer.writableBytes() < size + 8) {
            int requiredSize = this.internalBuffer.capacity() + size + 8;
            this.eventuallyLogIdealMaxOrder(requiredSize, logger);
            this.internalBuffer.capacity(requiredSize);
        }
        this.internalBuffer.writeInt(sequenceNumber);
        this.internalBuffer.writeInt(size);
        buffer.readBytes(this.internalBuffer, size);
        if (sequenceNumber > this.highestSequence) {
            this.highestSequence = sequenceNumber;
        }
    }

    void eventuallyLogIdealMaxOrder(int requiredSize, Logger logger) {
        int idealMaxOrder = this.idealMaxOrder(requiredSize);
        if (idealMaxOrder <= PooledByteBufAllocator.defaultMaxOrder()) {
            return;
        }
        if (!this.needsToBeLogged(idealMaxOrder)) {
            return;
        }
        if (idealMaxOrder > 14) {
            logger.error("Received batch of size {} bytes that is too large to fit into the pre-allocated memory pool. Reduce the size of the batch to improve performance and avoid data loss.", (Object)requiredSize);
        } else {
            logger.warn("Received batch of size {} bytes that is too large to fit into the pre-allocated memory pool. This will cause a performance degradation. Set 'io.netty.allocator.maxOrder' JVM property to {} to accommodate batches bigger than {} bytes.", (Object)requiredSize, (Object)idealMaxOrder, (Object)PooledByteBufAllocator.DEFAULT.metric().chunkSize());
        }
        this.trackAsAlreadyLogged(idealMaxOrder);
    }

    private void trackAsAlreadyLogged(int maxOrder) {
        LAST_NOTIFIED_MAX_ORDER = V2Batch.capMaxOrder(maxOrder);
    }

    private boolean needsToBeLogged(int maxOrder) {
        return V2Batch.capMaxOrder(maxOrder) > LAST_NOTIFIED_MAX_ORDER;
    }

    private static int capMaxOrder(int maxOrder) {
        return maxOrder > 14 ? Integer.MAX_VALUE : maxOrder;
    }

    private int idealMaxOrder(int requiredSize) {
        int chunkSize = PooledByteBufAllocator.DEFAULT.metric().chunkSize();
        int defaultMaxOrder = PooledByteBufAllocator.defaultMaxOrder();
        int defaultPageSize = PooledByteBufAllocator.defaultPageSize();
        if (requiredSize > chunkSize) {
            int nextMaxOrder = defaultMaxOrder;
            while (requiredSize > defaultPageSize << ++nextMaxOrder) {
            }
            return nextMaxOrder;
        }
        return defaultMaxOrder;
    }

    @Override
    public void release() {
        this.internalBuffer.release();
    }

    static void resetReportedOrders() {
        LAST_NOTIFIED_MAX_ORDER = -1;
    }
}

