/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.wildcard.mapper;

import java.io.IOException;
import java.util.Objects;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.ConstantScoreScorer;
import org.apache.lucene.search.ConstantScoreWeight;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryVisitor;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.ScorerSupplier;
import org.apache.lucene.search.TwoPhaseIterator;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.automaton.Automaton;
import org.apache.lucene.util.automaton.ByteRunAutomaton;
import org.elasticsearch.common.io.stream.ByteArrayStreamInput;

public class BinaryDvConfirmedAutomatonQuery
extends Query {
    private final String field;
    private final String matchPattern;
    private final ByteRunAutomaton bytesMatcher;
    private final Query approxQuery;

    public BinaryDvConfirmedAutomatonQuery(Query approximation, String field, String matchPattern, Automaton automaton) {
        this.approxQuery = approximation;
        this.field = field;
        this.matchPattern = matchPattern;
        this.bytesMatcher = new ByteRunAutomaton(automaton);
    }

    private BinaryDvConfirmedAutomatonQuery(Query approximation, String field, String matchPattern, ByteRunAutomaton bytesMatcher) {
        this.approxQuery = approximation;
        this.field = field;
        this.matchPattern = matchPattern;
        this.bytesMatcher = bytesMatcher;
    }

    @Override
    public Query rewrite(IndexSearcher searcher) throws IOException {
        Query approxRewrite = this.approxQuery.rewrite(searcher);
        if (this.approxQuery != approxRewrite) {
            return new BinaryDvConfirmedAutomatonQuery(approxRewrite, this.field, this.matchPattern, this.bytesMatcher);
        }
        return this;
    }

    @Override
    public Weight createWeight(IndexSearcher searcher, final ScoreMode scoreMode, float boost) throws IOException {
        final Weight approxWeight = this.approxQuery.createWeight(searcher, scoreMode, boost);
        return new ConstantScoreWeight(this, boost){

            @Override
            public ScorerSupplier scorerSupplier(LeafReaderContext context) throws IOException {
                final ByteArrayStreamInput bytes = new ByteArrayStreamInput();
                final BinaryDocValues values = DocValues.getBinary(context.reader(), BinaryDvConfirmedAutomatonQuery.this.field);
                final ScorerSupplier approxScorerSupplier = approxWeight.scorerSupplier(context);
                if (approxScorerSupplier == null) {
                    return null;
                }
                return new ScorerSupplier(){

                    @Override
                    public Scorer get(long leadCost) throws IOException {
                        Scorer approxScorer = approxScorerSupplier.get(leadCost);
                        final DocIdSetIterator approxDisi = approxScorer.iterator();
                        TwoPhaseIterator twoPhase = new TwoPhaseIterator(approxDisi){

                            @Override
                            public boolean matches() throws IOException {
                                if (!values.advanceExact(approxDisi.docID())) {
                                    return false;
                                }
                                BytesRef arrayOfValues = values.binaryValue();
                                bytes.reset(arrayOfValues.bytes);
                                bytes.setPosition(arrayOfValues.offset);
                                int size = bytes.readVInt();
                                for (int i = 0; i < size; ++i) {
                                    int valLength = bytes.readVInt();
                                    if (BinaryDvConfirmedAutomatonQuery.this.bytesMatcher.run(arrayOfValues.bytes, bytes.getPosition(), valLength)) {
                                        return true;
                                    }
                                    bytes.skipBytes(valLength);
                                }
                                return false;
                            }

                            @Override
                            public float matchCost() {
                                return 1000.0f;
                            }
                        };
                        return new ConstantScoreScorer(this.score(), scoreMode, twoPhase);
                    }

                    @Override
                    public long cost() {
                        return approxScorerSupplier.cost();
                    }
                };
            }

            @Override
            public boolean isCacheable(LeafReaderContext ctx) {
                return true;
            }
        };
    }

    @Override
    public String toString(String field) {
        return field + ":" + this.matchPattern;
    }

    @Override
    public boolean equals(Object obj) {
        if (!this.sameClassAs(obj)) {
            return false;
        }
        BinaryDvConfirmedAutomatonQuery other = (BinaryDvConfirmedAutomatonQuery)obj;
        return Objects.equals(this.field, other.field) && Objects.equals(this.matchPattern, other.matchPattern) && Objects.equals(this.bytesMatcher, other.bytesMatcher) && Objects.equals(this.approxQuery, other.approxQuery);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.classHash(), this.field, this.matchPattern, this.bytesMatcher, this.approxQuery);
    }

    Query getApproximationQuery() {
        return this.approxQuery;
    }

    @Override
    public void visit(QueryVisitor visitor) {
        if (visitor.acceptField(this.field)) {
            visitor.visitLeaf(this);
        }
    }
}

