/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.watcher.transport.actions.stats;

import java.io.IOException;
import org.elasticsearch.action.support.nodes.BaseNodesRequest;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.transport.TransportRequest;

public class WatcherStatsRequest
extends BaseNodesRequest {
    private boolean includeCurrentWatches;
    private boolean includeQueuedWatches;
    private boolean includeStats;

    public WatcherStatsRequest() {
        super((String[])null);
    }

    public boolean includeCurrentWatches() {
        return this.includeCurrentWatches;
    }

    public void includeCurrentWatches(boolean currentWatches) {
        this.includeCurrentWatches = currentWatches;
    }

    public boolean includeQueuedWatches() {
        return this.includeQueuedWatches;
    }

    public void includeQueuedWatches(boolean includeQueuedWatches) {
        this.includeQueuedWatches = includeQueuedWatches;
    }

    public boolean includeStats() {
        return this.includeStats;
    }

    public void includeStats(boolean includeStats) {
        this.includeStats = includeStats;
    }

    @Override
    public String toString() {
        return "watcher_stats";
    }

    public static class Node
    extends TransportRequest {
        private boolean includeCurrentWatches;
        private boolean includeQueuedWatches;
        private boolean includeStats;

        public Node(StreamInput in) throws IOException {
            super(in);
            this.includeCurrentWatches = in.readBoolean();
            this.includeQueuedWatches = in.readBoolean();
            this.includeStats = in.readBoolean();
        }

        public Node(WatcherStatsRequest request) {
            this.includeCurrentWatches = request.includeCurrentWatches();
            this.includeQueuedWatches = request.includeQueuedWatches();
            this.includeStats = request.includeStats();
        }

        public boolean includeCurrentWatches() {
            return this.includeCurrentWatches;
        }

        public boolean includeQueuedWatches() {
            return this.includeQueuedWatches;
        }

        public boolean includeStats() {
            return this.includeStats;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeBoolean(this.includeCurrentWatches);
            out.writeBoolean(this.includeQueuedWatches);
            out.writeBoolean(this.includeStats);
        }
    }
}

