/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.authc.ldap;

import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.xpack.core.security.authc.RealmSettings;
import org.elasticsearch.xpack.core.security.authc.ldap.support.LdapSearchScope;

public final class SearchGroupsResolverSettings {
    public static final Function<String, Setting.AffixSetting<String>> BASE_DN = RealmSettings.affixSetting("group_search.base_dn", key -> Setting.simpleString(key, Setting.Property.NodeScope));
    public static final Function<String, Setting.AffixSetting<LdapSearchScope>> SCOPE = RealmSettings.affixSetting("group_search.scope", key -> new Setting<LdapSearchScope>((String)key, (String)null, s -> LdapSearchScope.resolve(s, LdapSearchScope.SUB_TREE), Setting.Property.NodeScope));
    public static final Setting.AffixSetting<String> USER_ATTRIBUTE = RealmSettings.simpleString("ldap", "group_search.user_attribute", Setting.Property.NodeScope);
    private static final String GROUP_SEARCH_DEFAULT_FILTER = "(&(|(objectclass=groupOfNames)(objectclass=groupOfUniqueNames)(objectclass=group)(objectclass=posixGroup))(|(uniqueMember={0})(member={0})(memberUid={0})))";
    public static final Setting.AffixSetting<String> FILTER = Setting.affixKeySetting(RealmSettings.realmSettingPrefix("ldap"), "group_search.filter", key -> Setting.simpleString(key, GROUP_SEARCH_DEFAULT_FILTER, Setting.Property.NodeScope), new Setting.AffixSettingDependency[0]);

    private SearchGroupsResolverSettings() {
    }

    public static Set<Setting.AffixSetting<?>> getSettings(String realmType) {
        HashSet settings = new HashSet();
        settings.add(BASE_DN.apply(realmType));
        settings.add(SCOPE.apply(realmType));
        if (realmType.equals("ldap")) {
            settings.add(FILTER);
            settings.add(USER_ATTRIBUTE);
        }
        return settings;
    }
}

