/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.action.user;

import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.CharArrays;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xpack.core.security.action.user.UserRequest;

public class PutUserRequest
extends ActionRequest
implements UserRequest,
WriteRequest<PutUserRequest> {
    private String username;
    private String[] roles;
    private String fullName;
    private String email;
    private Map<String, Object> metadata;
    private char[] passwordHash;
    private boolean enabled = true;
    private WriteRequest.RefreshPolicy refreshPolicy = WriteRequest.RefreshPolicy.IMMEDIATE;

    public PutUserRequest(StreamInput in) throws IOException {
        super(in);
        this.username = in.readString();
        this.passwordHash = PutUserRequest.readCharArrayFromStream(in);
        this.roles = in.readStringArray();
        this.fullName = in.readOptionalString();
        this.email = in.readOptionalString();
        this.metadata = in.readBoolean() ? in.readGenericMap() : null;
        this.refreshPolicy = WriteRequest.RefreshPolicy.readFrom(in);
        this.enabled = in.readBoolean();
    }

    public PutUserRequest() {
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (this.username == null) {
            validationException = ValidateActions.addValidationError("user is missing", validationException);
        }
        if (this.roles == null) {
            validationException = ValidateActions.addValidationError("roles are missing", validationException);
        }
        if (this.metadata != null && this.metadata.keySet().stream().anyMatch(s -> s.startsWith("_"))) {
            validationException = ValidateActions.addValidationError("metadata keys may not start with [_]", validationException);
        }
        return validationException;
    }

    public void username(String username) {
        this.username = username;
    }

    public void roles(String ... roles) {
        this.roles = roles;
    }

    public void fullName(String fullName) {
        this.fullName = fullName;
    }

    public void email(String email) {
        this.email = email;
    }

    public void metadata(Map<String, Object> metadata) {
        this.metadata = metadata;
    }

    public void passwordHash(@Nullable char[] passwordHash) {
        this.passwordHash = passwordHash;
    }

    public void enabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public WriteRequest.RefreshPolicy getRefreshPolicy() {
        return this.refreshPolicy;
    }

    @Override
    public PutUserRequest setRefreshPolicy(WriteRequest.RefreshPolicy refreshPolicy) {
        this.refreshPolicy = refreshPolicy;
        return this;
    }

    public String username() {
        return this.username;
    }

    public String[] roles() {
        return this.roles;
    }

    public String fullName() {
        return this.fullName;
    }

    public String email() {
        return this.email;
    }

    public Map<String, Object> metadata() {
        return this.metadata;
    }

    @Nullable
    public char[] passwordHash() {
        return this.passwordHash;
    }

    public boolean enabled() {
        return this.enabled;
    }

    @Override
    public String[] usernames() {
        return new String[]{this.username};
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.username);
        PutUserRequest.writeCharArrayToStream(out, this.passwordHash);
        out.writeStringArray(this.roles);
        out.writeOptionalString(this.fullName);
        out.writeOptionalString(this.email);
        if (this.metadata == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            out.writeGenericMap(this.metadata);
        }
        this.refreshPolicy.writeTo(out);
        out.writeBoolean(this.enabled);
    }

    private static char[] readCharArrayFromStream(StreamInput in) throws IOException {
        BytesReference charBytesRef = in.readSlicedBytesReference();
        if (charBytesRef == BytesArray.EMPTY) {
            return null;
        }
        return CharArrays.utf8BytesToChars(BytesReference.toBytes(charBytesRef));
    }

    private static void writeCharArrayToStream(StreamOutput out, char[] chars) throws IOException {
        BytesArray charBytesRef = chars == null ? null : new BytesArray(CharArrays.toUtf8Bytes(chars));
        out.writeBytesReference(charBytesRef);
    }

    @Override
    public String toString() {
        return "PutUserRequest{username='" + this.username + "', roles=" + Arrays.toString(this.roles) + ", fullName='" + this.fullName + "', email='" + this.email + "', metadata=" + String.valueOf(this.metadata) + ", passwordHash=" + (this.passwordHash == null ? "<null>" : "<not-null>") + ", enabled=" + this.enabled + ", refreshPolicy=" + String.valueOf(this.refreshPolicy) + "}";
    }
}

