/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.action.user;

import java.io.IOException;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xpack.core.security.action.user.UserRequest;
import org.elasticsearch.xpack.core.security.authz.AuthorizationEngine;
import org.elasticsearch.xpack.core.security.authz.RoleDescriptor;

public class HasPrivilegesRequest
extends ActionRequest
implements UserRequest {
    private String username;
    private String[] clusterPrivileges;
    private RoleDescriptor.IndicesPrivileges[] indexPrivileges;
    private RoleDescriptor.ApplicationResourcePrivileges[] applicationPrivileges;
    private final boolean runDetailedCheck = true;

    public HasPrivilegesRequest() {
    }

    public HasPrivilegesRequest(StreamInput in) throws IOException {
        super(in);
        this.username = in.readString();
        this.clusterPrivileges = in.readStringArray();
        int indexSize = in.readVInt();
        this.indexPrivileges = new RoleDescriptor.IndicesPrivileges[indexSize];
        for (int i = 0; i < indexSize; ++i) {
            this.indexPrivileges[i] = new RoleDescriptor.IndicesPrivileges(in);
        }
        this.applicationPrivileges = in.readArray(RoleDescriptor.ApplicationResourcePrivileges::new, RoleDescriptor.ApplicationResourcePrivileges[]::new);
    }

    public AuthorizationEngine.PrivilegesToCheck getPrivilegesToCheck() {
        return new AuthorizationEngine.PrivilegesToCheck(this.clusterPrivileges, this.indexPrivileges, this.applicationPrivileges, true);
    }

    @Override
    public ActionRequestValidationException validate() {
        assert (this.getPrivilegesToCheck().runDetailedCheck());
        return this.getPrivilegesToCheck().validate(null);
    }

    public String username() {
        return this.username;
    }

    public void username(String username) {
        this.username = username;
    }

    @Override
    public String[] usernames() {
        return new String[]{this.username};
    }

    public RoleDescriptor.IndicesPrivileges[] indexPrivileges() {
        return this.indexPrivileges;
    }

    public String[] clusterPrivileges() {
        return this.clusterPrivileges;
    }

    public RoleDescriptor.ApplicationResourcePrivileges[] applicationPrivileges() {
        return this.applicationPrivileges;
    }

    public void indexPrivileges(RoleDescriptor.IndicesPrivileges ... privileges) {
        this.indexPrivileges = privileges;
    }

    public void clusterPrivileges(String ... privileges) {
        this.clusterPrivileges = privileges;
    }

    public void applicationPrivileges(RoleDescriptor.ApplicationResourcePrivileges ... appPrivileges) {
        this.applicationPrivileges = appPrivileges;
    }

    public void privilegesToCheck(AuthorizationEngine.PrivilegesToCheck privilegesToCheck) {
        assert (privilegesToCheck.runDetailedCheck());
        this.clusterPrivileges(privilegesToCheck.cluster());
        this.indexPrivileges(privilegesToCheck.index());
        this.applicationPrivileges(privilegesToCheck.application());
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.username);
        out.writeStringArray(this.clusterPrivileges);
        out.writeVInt(this.indexPrivileges.length);
        for (RoleDescriptor.IndicesPrivileges priv : this.indexPrivileges) {
            priv.writeTo(out);
        }
        out.writeArray(RoleDescriptor.ApplicationResourcePrivileges::write, this.applicationPrivileges);
    }
}

