/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.inference.action;

import java.io.IOException;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.inference.TaskType;

public abstract class BaseInferenceActionRequest
extends ActionRequest {
    private boolean hasBeenRerouted;

    public BaseInferenceActionRequest() {
    }

    public BaseInferenceActionRequest(StreamInput in) throws IOException {
        super(in);
        this.hasBeenRerouted = in.getTransportVersion().onOrAfter(TransportVersions.INFERENCE_REQUEST_ADAPTIVE_RATE_LIMITING) ? in.readBoolean() : true;
    }

    public abstract boolean isStreaming();

    public abstract TaskType getTaskType();

    public abstract String getInferenceEntityId();

    public void setHasBeenRerouted(boolean hasBeenRerouted) {
        this.hasBeenRerouted = hasBeenRerouted;
    }

    public boolean hasBeenRerouted() {
        return this.hasBeenRerouted;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        if (out.getTransportVersion().onOrAfter(TransportVersions.INFERENCE_REQUEST_ADAPTIVE_RATE_LIMITING)) {
            out.writeBoolean(this.hasBeenRerouted);
        }
    }
}

