/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.action;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Objects;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.common.xcontent.LoggingDeprecationHandler;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.sort.SortBuilders;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xcontent.NamedXContentRegistry;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.action.AbstractGetResourcesRequest;
import org.elasticsearch.xpack.core.action.AbstractGetResourcesResponse;
import org.elasticsearch.xpack.core.action.util.ExpandedIdsMatcher;
import org.elasticsearch.xpack.core.action.util.QueryPage;

public abstract class AbstractTransportGetResourcesAction<Resource extends ToXContent & Writeable, Request extends AbstractGetResourcesRequest, Response extends AbstractGetResourcesResponse<Resource>>
extends HandledTransportAction<Request, Response> {
    private final Client client;
    private final NamedXContentRegistry xContentRegistry;

    protected AbstractTransportGetResourcesAction(String actionName, TransportService transportService, ActionFilters actionFilters, Writeable.Reader<Request> request, Client client, NamedXContentRegistry xContentRegistry) {
        super(actionName, transportService, actionFilters, request, EsExecutors.DIRECT_EXECUTOR_SERVICE);
        this.client = Objects.requireNonNull(client);
        this.xContentRegistry = Objects.requireNonNull(xContentRegistry);
    }

    protected void searchResources(AbstractGetResourcesRequest request, TaskId parentTaskId, ActionListener<QueryPage<Resource>> listener) {
        String[] tokens = Strings.tokenizeToStringArray(request.getResourceId(), ",");
        SearchSourceBuilder sourceBuilder = new SearchSourceBuilder().sort(SortBuilders.fieldSort(request.getResourceIdField()).unmappedType("long")).query(this.buildQuery(tokens, request.getResourceIdField()));
        if (request.getPageParams() != null) {
            sourceBuilder.from(request.getPageParams().getFrom()).size(request.getPageParams().getSize());
        }
        sourceBuilder.trackTotalHits(true);
        IndicesOptions indicesOptions = SearchRequest.DEFAULT_INDICES_OPTIONS;
        SearchRequest searchRequest = new SearchRequest(this.getIndices()).indicesOptions(IndicesOptions.fromOptions(true, indicesOptions.allowNoIndices(), indicesOptions.expandWildcardsOpen(), indicesOptions.expandWildcardsClosed(), indicesOptions)).source(this.customSearchOptions(sourceBuilder));
        searchRequest.setParentTask(parentTaskId);
        ClientHelper.executeAsyncWithOrigin(this.client.threadPool().getThreadContext(), this.executionOrigin(), searchRequest, listener.delegateFailure((l, response) -> {
            ArrayList<Resource> docs = new ArrayList<Resource>();
            HashSet<String> foundResourceIds = new HashSet<String>();
            long totalHitCount = response.getHits().getTotalHits().value();
            for (SearchHit hit : response.getHits().getHits()) {
                try (XContentParser parser = XContentHelper.createParserNotCompressed(LoggingDeprecationHandler.XCONTENT_PARSER_CONFIG.withRegistry(this.xContentRegistry), hit.getSourceRef(), XContentType.JSON);){
                    Resource resource = this.parse(parser);
                    String id = this.extractIdFromResource(resource);
                    if (foundResourceIds.contains(id)) continue;
                    docs.add(resource);
                    foundResourceIds.add(id);
                }
                catch (IOException e) {
                    l.onFailure(e);
                }
            }
            ExpandedIdsMatcher requiredMatches = new ExpandedIdsMatcher(tokens, request.isAllowNoResources());
            requiredMatches.filterMatchedIds(foundResourceIds);
            if (requiredMatches.hasUnmatchedIds()) {
                l.onFailure(this.notFoundException(requiredMatches.unmatchedIdsString()));
            } else if (requiredMatches.isOnlyExact()) {
                l.onResponse(new QueryPage(docs, docs.size(), this.getResultsField()));
            } else {
                l.onResponse(new QueryPage(docs, totalHitCount, this.getResultsField()));
            }
        }), this.client::search);
    }

    private QueryBuilder buildQuery(String[] tokens, String resourceIdField) {
        QueryBuilder additionalQuery;
        BoolQueryBuilder boolQuery = QueryBuilders.boolQuery();
        if (!Strings.isAllOrWildcard(tokens)) {
            BoolQueryBuilder shouldQueries = new BoolQueryBuilder();
            ArrayList<String> terms = new ArrayList<String>();
            for (String token : tokens) {
                if (Regex.isSimpleMatchPattern(token)) {
                    shouldQueries.should(QueryBuilders.wildcardQuery(resourceIdField, token));
                    continue;
                }
                terms.add(token);
            }
            if (!terms.isEmpty()) {
                shouldQueries.should(QueryBuilders.termsQuery(resourceIdField, terms));
            }
            if (!shouldQueries.should().isEmpty()) {
                boolQuery.filter(shouldQueries);
            }
        }
        if ((additionalQuery = this.additionalQuery()) != null) {
            boolQuery.filter(additionalQuery);
        }
        return boolQuery.hasClauses() ? boolQuery : QueryBuilders.matchAllQuery();
    }

    protected SearchSourceBuilder customSearchOptions(SearchSourceBuilder searchSourceBuilder) {
        return searchSourceBuilder;
    }

    @Nullable
    protected QueryBuilder additionalQuery() {
        return null;
    }

    protected abstract ParseField getResultsField();

    protected abstract String[] getIndices();

    protected abstract Resource parse(XContentParser var1) throws IOException;

    protected abstract ResourceNotFoundException notFoundException(String var1);

    protected abstract String executionOrigin();

    protected abstract String extractIdFromResource(Resource var1);
}

