/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.function.LongSupplier;
import java.util.function.ToLongFunction;
import org.apache.lucene.index.CompositeReader;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.OrdinalMap;
import org.apache.lucene.index.PointValues;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.BoostQuery;
import org.apache.lucene.search.FieldDoc;
import org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TotalHits;
import org.apache.lucene.util.NumericUtils;
import org.elasticsearch.action.search.SearchShardTask;
import org.elasticsearch.action.search.SearchType;
import org.elasticsearch.cluster.routing.IndexRouting;
import org.elasticsearch.common.lucene.search.Queries;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.index.IndexMode;
import org.elasticsearch.index.IndexService;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.IndexVersions;
import org.elasticsearch.index.cache.bitset.BitsetFilterCache;
import org.elasticsearch.index.engine.Engine;
import org.elasticsearch.index.fielddata.FieldDataContext;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.IndexNumericFieldData;
import org.elasticsearch.index.fielddata.IndexOrdinalsFieldData;
import org.elasticsearch.index.fielddata.LeafOrdinalsFieldData;
import org.elasticsearch.index.mapper.IdLoader;
import org.elasticsearch.index.mapper.KeywordFieldMapper;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.NestedLookup;
import org.elasticsearch.index.mapper.SourceLoader;
import org.elasticsearch.index.query.ParsedQuery;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.index.search.NestedHelper;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.search.SearchExtBuilder;
import org.elasticsearch.search.SearchService;
import org.elasticsearch.search.SearchShardTarget;
import org.elasticsearch.search.aggregations.SearchContextAggregations;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.collapse.CollapseContext;
import org.elasticsearch.search.dfs.DfsSearchResult;
import org.elasticsearch.search.fetch.FetchPhase;
import org.elasticsearch.search.fetch.FetchSearchResult;
import org.elasticsearch.search.fetch.StoredFieldsContext;
import org.elasticsearch.search.fetch.subphase.FetchDocValuesContext;
import org.elasticsearch.search.fetch.subphase.FetchFieldsContext;
import org.elasticsearch.search.fetch.subphase.FetchSourceContext;
import org.elasticsearch.search.fetch.subphase.ScriptFieldsContext;
import org.elasticsearch.search.fetch.subphase.highlight.SearchHighlightContext;
import org.elasticsearch.search.internal.ContextIndexSearcher;
import org.elasticsearch.search.internal.ReaderContext;
import org.elasticsearch.search.internal.ScrollContext;
import org.elasticsearch.search.internal.SearchContext;
import org.elasticsearch.search.internal.ShardSearchContextId;
import org.elasticsearch.search.internal.ShardSearchRequest;
import org.elasticsearch.search.profile.Profilers;
import org.elasticsearch.search.query.QuerySearchResult;
import org.elasticsearch.search.rank.context.QueryPhaseRankShardContext;
import org.elasticsearch.search.rank.feature.RankFeatureResult;
import org.elasticsearch.search.rescore.RescoreContext;
import org.elasticsearch.search.rescore.RescorePhase;
import org.elasticsearch.search.slice.SliceBuilder;
import org.elasticsearch.search.sort.SortAndFormats;
import org.elasticsearch.search.suggest.SuggestionSearchContext;

final class DefaultSearchContext
extends SearchContext {
    private final ReaderContext readerContext;
    private final ShardSearchRequest request;
    private final SearchShardTarget shardTarget;
    private final LongSupplier relativeTimeSupplier;
    private final SearchType searchType;
    private final IndexShard indexShard;
    private final IndexService indexService;
    private final ContextIndexSearcher searcher;
    private DfsSearchResult dfsResult;
    private QuerySearchResult queryResult;
    private RankFeatureResult rankFeatureResult;
    private FetchSearchResult fetchResult;
    private final float queryBoost;
    private final boolean lowLevelCancellation;
    private TimeValue timeout;
    private int terminateAfter = 0;
    private List<String> groupStats;
    private boolean explain;
    private boolean version = false;
    private boolean seqAndPrimaryTerm = false;
    private StoredFieldsContext storedFields;
    private ScriptFieldsContext scriptFields;
    private FetchSourceContext fetchSourceContext;
    private FetchDocValuesContext docValuesContext;
    private FetchFieldsContext fetchFieldsContext;
    private int from = -1;
    private int size = -1;
    private SortAndFormats sort;
    private Float minimumScore;
    private boolean trackScores = false;
    private int trackTotalHitsUpTo = 10000;
    private FieldDoc searchAfter;
    private CollapseContext collapse;
    private SliceBuilder sliceBuilder;
    private SearchShardTask task;
    private QueryPhaseRankShardContext queryPhaseRankShardContext;
    private ParsedQuery originalQuery;
    private Query query;
    private ParsedQuery postFilter;
    private Query aliasFilter;
    private SearchContextAggregations aggregations;
    private SearchHighlightContext highlight;
    private SuggestionSearchContext suggest;
    private List<RescoreContext> rescore;
    private Profilers profilers;
    private final Map<String, SearchExtBuilder> searchExtBuilders = new HashMap<String, SearchExtBuilder>();
    private final SearchExecutionContext searchExecutionContext;
    private final FetchPhase fetchPhase;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DefaultSearchContext(ReaderContext readerContext, ShardSearchRequest request, SearchShardTarget shardTarget, LongSupplier relativeTimeSupplier, TimeValue timeout, FetchPhase fetchPhase, boolean lowLevelCancellation, Executor executor, SearchService.ResultsType resultsType, boolean enableQueryPhaseParallelCollection, int minimumDocsPerSlice) throws IOException {
        this.readerContext = readerContext;
        this.request = request;
        this.fetchPhase = fetchPhase;
        boolean success = false;
        try {
            this.searchType = request.searchType();
            this.shardTarget = shardTarget;
            this.indexService = readerContext.indexService();
            this.indexShard = readerContext.indexShard();
            Engine.Searcher engineSearcher = readerContext.acquireSearcher("search");
            int maximumNumberOfSlices = DefaultSearchContext.determineMaximumNumberOfSlices(executor, request, resultsType, enableQueryPhaseParallelCollection, field -> DefaultSearchContext.getFieldCardinality(field, readerContext.indexService(), engineSearcher.getDirectoryReader()));
            this.searcher = executor == null || maximumNumberOfSlices <= 1 ? new ContextIndexSearcher(engineSearcher.getIndexReader(), engineSearcher.getSimilarity(), engineSearcher.getQueryCache(), engineSearcher.getQueryCachingPolicy(), lowLevelCancellation) : new ContextIndexSearcher(engineSearcher.getIndexReader(), engineSearcher.getSimilarity(), engineSearcher.getQueryCache(), engineSearcher.getQueryCachingPolicy(), lowLevelCancellation, executor, maximumNumberOfSlices, minimumDocsPerSlice);
            this.releasables.addAll(List.of(engineSearcher, this.searcher));
            this.relativeTimeSupplier = relativeTimeSupplier;
            this.timeout = timeout;
            this.searchExecutionContext = this.indexService.newSearchExecutionContext(request.shardId().id(), request.shardRequestIndex(), this.searcher, request::nowInMillis, shardTarget.getClusterAlias(), request.getRuntimeMappings(), request.source() == null ? null : Integer.valueOf(request.source().size()));
            this.queryBoost = request.indexBoost();
            this.lowLevelCancellation = lowLevelCancellation;
            success = true;
        }
        finally {
            if (!success) {
                this.close();
            }
        }
    }

    static long getFieldCardinality(String field, IndexService indexService, DirectoryReader directoryReader) {
        IndexFieldData<?> indexFieldData;
        MappedFieldType mappedFieldType = indexService.mapperService().fieldType(field);
        if (mappedFieldType == null) {
            return -1L;
        }
        try {
            indexFieldData = indexService.loadFielddata(mappedFieldType, FieldDataContext.noRuntimeFields("field cardinality"));
        }
        catch (Exception e) {
            return -1L;
        }
        return DefaultSearchContext.getFieldCardinality(indexFieldData, directoryReader);
    }

    static long getFieldCardinality(IndexFieldData<?> indexFieldData, DirectoryReader directoryReader) {
        if (indexFieldData instanceof IndexOrdinalsFieldData) {
            IndexOrdinalsFieldData indexOrdinalsFieldData = (IndexOrdinalsFieldData)indexFieldData;
            if (indexOrdinalsFieldData.supportsGlobalOrdinalsMapping()) {
                IndexOrdinalsFieldData global = indexOrdinalsFieldData.loadGlobal(directoryReader);
                OrdinalMap ordinalMap = global.getOrdinalMap();
                if (ordinalMap != null) {
                    return ordinalMap.getValueCount();
                }
                if (directoryReader.leaves().isEmpty()) {
                    return 0L;
                }
                return ((LeafOrdinalsFieldData)global.load(directoryReader.leaves().get(0))).getOrdinalsValues().getValueCount();
            }
        } else if (indexFieldData instanceof IndexNumericFieldData) {
            IndexNumericFieldData indexNumericFieldData = (IndexNumericFieldData)indexFieldData;
            IndexNumericFieldData.NumericType type = indexNumericFieldData.getNumericType();
            try {
                if (type == IndexNumericFieldData.NumericType.INT || type == IndexNumericFieldData.NumericType.SHORT) {
                    CompositeReader reader = directoryReader.getContext().reader();
                    byte[] min = PointValues.getMinPackedValue(reader, indexFieldData.getFieldName());
                    byte[] max = PointValues.getMaxPackedValue(reader, indexFieldData.getFieldName());
                    if (min != null && max != null) {
                        return NumericUtils.sortableBytesToInt(max, 0) - NumericUtils.sortableBytesToInt(min, 0) + 1;
                    }
                } else if (type == IndexNumericFieldData.NumericType.LONG) {
                    CompositeReader reader = directoryReader.getContext().reader();
                    byte[] min = PointValues.getMinPackedValue(reader, indexFieldData.getFieldName());
                    byte[] max = PointValues.getMaxPackedValue(reader, indexFieldData.getFieldName());
                    if (min != null && max != null) {
                        return NumericUtils.sortableBytesToLong(max, 0) - NumericUtils.sortableBytesToLong(min, 0) + 1L;
                    }
                }
            }
            catch (IOException ioe) {
                return -1L;
            }
        }
        return -1L;
    }

    static int determineMaximumNumberOfSlices(Executor executor, ShardSearchRequest request, SearchService.ResultsType resultsType, boolean enableQueryPhaseParallelCollection, ToLongFunction<String> fieldCardinality) {
        ThreadPoolExecutor tpe;
        return executor instanceof ThreadPoolExecutor && (tpe = (ThreadPoolExecutor)executor).getQueue().size() <= tpe.getMaximumPoolSize() && DefaultSearchContext.isParallelCollectionSupportedForResults(resultsType, request.source(), fieldCardinality, enableQueryPhaseParallelCollection) ? tpe.getMaximumPoolSize() : 1;
    }

    static boolean isParallelCollectionSupportedForResults(SearchService.ResultsType resultsType, SearchSourceBuilder source, ToLongFunction<String> fieldCardinality, boolean isQueryPhaseParallelismEnabled) {
        if (resultsType == SearchService.ResultsType.DFS) {
            return true;
        }
        if (resultsType == SearchService.ResultsType.QUERY && isQueryPhaseParallelismEnabled) {
            return source == null || source.supportsParallelCollection(fieldCardinality);
        }
        return false;
    }

    @Override
    public void addRankFeatureResult() {
        this.rankFeatureResult = new RankFeatureResult(this.readerContext.id(), this.shardTarget, this.request);
        this.addReleasable(this.rankFeatureResult::decRef);
    }

    @Override
    public RankFeatureResult rankFeatureResult() {
        return this.rankFeatureResult;
    }

    @Override
    public void addFetchResult() {
        this.fetchResult = new FetchSearchResult(this.readerContext.id(), this.shardTarget);
        this.addReleasable(this.fetchResult::decRef);
    }

    @Override
    public void addQueryResult() {
        this.queryResult = new QuerySearchResult(this.readerContext.id(), this.shardTarget, this.request);
        this.addReleasable(this.queryResult::decRef);
    }

    @Override
    public void addDfsResult() {
        this.dfsResult = new DfsSearchResult(this.readerContext.id(), this.shardTarget, this.request);
    }

    @Override
    public void preProcess() {
        int maxResultWindow;
        long size;
        if (this.hasOnlySuggest()) {
            return;
        }
        long from = this.from() == -1 ? 0L : (long)this.from();
        long resultWindow = from + (size = this.size() == -1 ? 10L : (long)this.size());
        if (resultWindow > (long)(maxResultWindow = this.indexService.getIndexSettings().getMaxResultWindow())) {
            if (this.scrollContext() == null) {
                throw new IllegalArgumentException("Result window is too large, from + size must be less than or equal to: [" + maxResultWindow + "] but was [" + resultWindow + "]. See the scroll api for a more efficient way to request large data sets. This limit can be set by changing the [" + IndexSettings.MAX_RESULT_WINDOW_SETTING.getKey() + "] index level setting.");
            }
            throw new IllegalArgumentException("Batch size is too large, size must be less than or equal to: [" + maxResultWindow + "] but was [" + resultWindow + "]. Scroll batch sizes cost as much memory as result windows so they are controlled by the [" + IndexSettings.MAX_RESULT_WINDOW_SETTING.getKey() + "] index level setting.");
        }
        if (this.rescore != null) {
            if (!RescorePhase.validateSort(this.sort)) {
                throw new IllegalArgumentException("Cannot use [sort] option in conjunction with [rescore].");
            }
            int maxWindow = this.indexService.getIndexSettings().getMaxRescoreWindow();
            for (RescoreContext rescoreContext : this.rescore()) {
                if (rescoreContext.getWindowSize() <= maxWindow) continue;
                throw new IllegalArgumentException("Rescore window [" + rescoreContext.getWindowSize() + "] is too large. It must be less than [" + maxWindow + "]. This prevents allocating massive heaps for storing the results to be rescored. This limit can be set by changing the [" + IndexSettings.MAX_RESCORE_WINDOW_SETTING.getKey() + "] index level setting.");
            }
        }
        if (this.sliceBuilder != null && this.scrollContext() != null) {
            int sliceLimit = this.indexService.getIndexSettings().getMaxSlicesPerScroll();
            int numSlices = this.sliceBuilder.getMax();
            if (numSlices > sliceLimit) {
                throw new IllegalArgumentException("The number of slices [" + numSlices + "] is too large. It must be less than [" + sliceLimit + "]. This limit can be set by changing the [" + IndexSettings.MAX_SLICES_PER_SCROLL.getKey() + "] index level setting.");
            }
        }
        try {
            QueryBuilder queryBuilder = this.request.getAliasFilter().getQueryBuilder();
            this.aliasFilter = queryBuilder == null ? null : queryBuilder.toQuery(this.searchExecutionContext);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        if (this.query == null) {
            this.parsedQuery(ParsedQuery.parsedMatchAllQuery());
        }
        if (this.queryBoost != 1.0f) {
            this.parsedQuery(new ParsedQuery((Query)new BoostQuery(this.query, this.queryBoost), this.parsedQuery()));
        }
        this.query = this.buildFilteredQuery(this.query);
        if (this.lowLevelCancellation) {
            this.searcher().addQueryCancellation(() -> {
                SearchShardTask task = this.getTask();
                if (task != null) {
                    task.ensureNotCancelled();
                }
            });
        }
    }

    @Override
    public Query buildFilteredQuery(Query query) {
        ArrayList<Query> filters = new ArrayList<Query>();
        NestedLookup nestedLookup = this.searchExecutionContext.nestedLookup();
        if (nestedLookup != NestedLookup.EMPTY && NestedHelper.mightMatchNestedDocs(query, this.searchExecutionContext) && (this.aliasFilter == null || NestedHelper.mightMatchNestedDocs(this.aliasFilter, this.searchExecutionContext))) {
            filters.add(Queries.newNonNestedFilter(this.searchExecutionContext.indexVersionCreated()));
        }
        if (this.aliasFilter != null) {
            filters.add(this.aliasFilter);
        }
        if (this.sliceBuilder != null) {
            Query slicedQuery = this.sliceBuilder.toFilter(this.request, this.searchExecutionContext);
            if (slicedQuery instanceof MatchNoDocsQuery) {
                return slicedQuery;
            }
            filters.add(slicedQuery);
        }
        if (filters.isEmpty()) {
            return query;
        }
        BooleanQuery.Builder builder = new BooleanQuery.Builder();
        builder.add(query, BooleanClause.Occur.MUST);
        for (Query filter : filters) {
            builder.add(filter, BooleanClause.Occur.FILTER);
        }
        return builder.build();
    }

    @Override
    public ShardSearchContextId id() {
        return this.readerContext.id();
    }

    @Override
    public String source() {
        return "search";
    }

    @Override
    public ShardSearchRequest request() {
        return this.request;
    }

    @Override
    public SearchType searchType() {
        return this.searchType;
    }

    @Override
    public SearchShardTarget shardTarget() {
        return this.shardTarget;
    }

    @Override
    public int numberOfShards() {
        return this.request.numberOfShards();
    }

    @Override
    public ScrollContext scrollContext() {
        return this.readerContext.scrollContext();
    }

    @Override
    public SearchContextAggregations aggregations() {
        return this.aggregations;
    }

    @Override
    public SearchContext aggregations(SearchContextAggregations aggregations) {
        this.aggregations = aggregations;
        return this;
    }

    public void addSearchExt(SearchExtBuilder searchExtBuilder) {
        this.searchExtBuilders.put(searchExtBuilder.getWriteableName(), searchExtBuilder);
    }

    @Override
    public SearchExtBuilder getSearchExt(String name) {
        return this.searchExtBuilders.get(name);
    }

    @Override
    public SearchHighlightContext highlight() {
        return this.highlight;
    }

    @Override
    public void highlight(SearchHighlightContext highlight) {
        this.highlight = highlight;
    }

    @Override
    public SuggestionSearchContext suggest() {
        return this.suggest;
    }

    public void suggest(SuggestionSearchContext suggest) {
        this.suggest = suggest;
    }

    @Override
    public QueryPhaseRankShardContext queryPhaseRankShardContext() {
        return this.queryPhaseRankShardContext;
    }

    @Override
    public void queryPhaseRankShardContext(QueryPhaseRankShardContext queryPhaseRankShardContext) {
        this.queryPhaseRankShardContext = queryPhaseRankShardContext;
    }

    @Override
    public List<RescoreContext> rescore() {
        if (this.rescore == null) {
            return List.of();
        }
        return this.rescore;
    }

    @Override
    public void addRescore(RescoreContext rescore) {
        if (this.rescore == null) {
            this.rescore = new ArrayList<RescoreContext>();
        }
        this.rescore.add(rescore);
    }

    @Override
    public boolean hasScriptFields() {
        return this.scriptFields != null && !this.scriptFields.fields().isEmpty();
    }

    @Override
    public ScriptFieldsContext scriptFields() {
        if (this.scriptFields == null) {
            this.scriptFields = new ScriptFieldsContext();
        }
        return this.scriptFields;
    }

    @Override
    public boolean sourceRequested() {
        return this.fetchSourceContext != null && this.fetchSourceContext.fetchSource();
    }

    @Override
    public FetchSourceContext fetchSourceContext() {
        return this.fetchSourceContext;
    }

    @Override
    public SearchContext fetchSourceContext(FetchSourceContext fetchSourceContext) {
        this.fetchSourceContext = fetchSourceContext;
        return this;
    }

    @Override
    public FetchDocValuesContext docValuesContext() {
        return this.docValuesContext;
    }

    @Override
    public SearchContext docValuesContext(FetchDocValuesContext docValuesContext) {
        this.docValuesContext = docValuesContext;
        return this;
    }

    @Override
    public FetchFieldsContext fetchFieldsContext() {
        return this.fetchFieldsContext;
    }

    @Override
    public SearchContext fetchFieldsContext(FetchFieldsContext fetchFieldsContext) {
        this.fetchFieldsContext = fetchFieldsContext;
        return this;
    }

    @Override
    public ContextIndexSearcher searcher() {
        return this.searcher;
    }

    @Override
    public IndexShard indexShard() {
        return this.indexShard;
    }

    @Override
    public BitsetFilterCache bitsetFilterCache() {
        return this.indexService.cache().bitsetFilterCache();
    }

    @Override
    public TimeValue timeout() {
        return this.timeout;
    }

    public void timeout(TimeValue timeout) {
        this.timeout = timeout;
    }

    @Override
    public int terminateAfter() {
        return this.terminateAfter;
    }

    @Override
    public void terminateAfter(int terminateAfter) {
        this.terminateAfter = terminateAfter;
    }

    @Override
    public SearchContext minimumScore(float minimumScore) {
        this.minimumScore = Float.valueOf(minimumScore);
        return this;
    }

    @Override
    public Float minimumScore() {
        return this.minimumScore;
    }

    @Override
    public SearchContext sort(SortAndFormats sort) {
        this.sort = sort;
        return this;
    }

    @Override
    public SortAndFormats sort() {
        return this.sort;
    }

    @Override
    public SearchContext trackScores(boolean trackScores) {
        this.trackScores = trackScores;
        return this;
    }

    @Override
    public boolean trackScores() {
        return this.trackScores;
    }

    @Override
    public SearchContext trackTotalHitsUpTo(int trackTotalHitsUpTo) {
        this.trackTotalHitsUpTo = trackTotalHitsUpTo;
        return this;
    }

    @Override
    public int trackTotalHitsUpTo() {
        return this.trackTotalHitsUpTo;
    }

    @Override
    public SearchContext searchAfter(FieldDoc searchAfter) {
        this.searchAfter = searchAfter;
        return this;
    }

    @Override
    public boolean lowLevelCancellation() {
        return this.lowLevelCancellation;
    }

    @Override
    public FieldDoc searchAfter() {
        return this.searchAfter;
    }

    public SearchContext collapse(CollapseContext collapse) {
        this.collapse = collapse;
        return this;
    }

    @Override
    public CollapseContext collapse() {
        return this.collapse;
    }

    public SearchContext sliceBuilder(SliceBuilder sliceBuilder) {
        this.sliceBuilder = sliceBuilder;
        return this;
    }

    @Override
    public SearchContext parsedPostFilter(ParsedQuery postFilter) {
        this.postFilter = postFilter;
        return this;
    }

    @Override
    public ParsedQuery parsedPostFilter() {
        return this.postFilter;
    }

    @Override
    public SearchContext parsedQuery(ParsedQuery query) {
        this.originalQuery = query;
        this.query = query.query();
        return this;
    }

    @Override
    public ParsedQuery parsedQuery() {
        return this.originalQuery;
    }

    @Override
    public Query query() {
        return this.query;
    }

    @Override
    public int from() {
        return this.from;
    }

    @Override
    public SearchContext from(int from) {
        this.from = from;
        return this;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public SearchContext size(int size) {
        this.size = size;
        return this;
    }

    @Override
    public boolean hasStoredFields() {
        return this.storedFields != null && this.storedFields.fieldNames() != null;
    }

    @Override
    public StoredFieldsContext storedFieldsContext() {
        return this.storedFields;
    }

    @Override
    public SearchContext storedFieldsContext(StoredFieldsContext storedFieldsContext) {
        this.storedFields = storedFieldsContext;
        return this;
    }

    @Override
    public boolean explain() {
        return this.explain;
    }

    @Override
    public void explain(boolean explain) {
        this.explain = explain;
    }

    @Override
    @Nullable
    public List<String> groupStats() {
        return this.groupStats;
    }

    public void groupStats(List<String> groupStats) {
        this.groupStats = groupStats;
    }

    @Override
    public boolean version() {
        return this.version;
    }

    @Override
    public void version(boolean version) {
        this.version = version;
    }

    @Override
    public boolean seqNoAndPrimaryTerm() {
        return this.seqAndPrimaryTerm;
    }

    @Override
    public void seqNoAndPrimaryTerm(boolean seqNoAndPrimaryTerm) {
        this.seqAndPrimaryTerm = seqNoAndPrimaryTerm;
    }

    @Override
    public DfsSearchResult dfsResult() {
        return this.dfsResult;
    }

    @Override
    public QuerySearchResult queryResult() {
        return this.queryResult;
    }

    public void addQuerySearchResultReleasable(Releasable releasable) {
        this.queryResult.addReleasable(releasable);
    }

    @Override
    public TotalHits getTotalHits() {
        if (this.queryResult != null) {
            return this.queryResult.getTotalHits();
        }
        return null;
    }

    @Override
    public float getMaxScore() {
        if (this.queryResult != null) {
            return this.queryResult.getMaxScore();
        }
        return Float.NaN;
    }

    @Override
    public FetchPhase fetchPhase() {
        return this.fetchPhase;
    }

    @Override
    public FetchSearchResult fetchResult() {
        return this.fetchResult;
    }

    @Override
    public long getRelativeTimeInMillis() {
        return this.relativeTimeSupplier.getAsLong();
    }

    @Override
    public SearchExecutionContext getSearchExecutionContext() {
        return this.searchExecutionContext;
    }

    @Override
    public Profilers getProfilers() {
        return this.profilers;
    }

    public void setProfilers(Profilers profilers) {
        this.profilers = profilers;
    }

    @Override
    public void setTask(SearchShardTask task) {
        this.task = task;
    }

    @Override
    public SearchShardTask getTask() {
        return this.task;
    }

    @Override
    public boolean isCancelled() {
        return this.task.isCancelled();
    }

    @Override
    public ReaderContext readerContext() {
        return this.readerContext;
    }

    @Override
    public SourceLoader newSourceLoader() {
        return this.searchExecutionContext.newSourceLoader(this.request.isForceSyntheticSource());
    }

    @Override
    public IdLoader newIdLoader() {
        if (this.indexService.getIndexSettings().getMode() == IndexMode.TIME_SERIES) {
            IndexRouting.ExtractFromSource indexRouting = null;
            List<String> routingPaths = null;
            if (this.indexService.getIndexSettings().getIndexVersionCreated().before(IndexVersions.TIME_SERIES_ROUTING_HASH_IN_ID)) {
                indexRouting = (IndexRouting.ExtractFromSource)this.indexService.getIndexSettings().getIndexRouting();
                routingPaths = this.indexService.getMetadata().getRoutingPaths();
                for (String routingField : routingPaths) {
                    if (!routingField.contains("*")) continue;
                    TreeSet<String> matchingRoutingPaths = new TreeSet<String>(routingPaths);
                    for (Mapper mapper : this.indexService.mapperService().mappingLookup().fieldMappers()) {
                        if (!(mapper instanceof KeywordFieldMapper) || !indexRouting.matchesField(mapper.fullPath())) continue;
                        matchingRoutingPaths.add(mapper.fullPath());
                    }
                    routingPaths = new ArrayList<String>(matchingRoutingPaths);
                    break;
                }
            }
            return IdLoader.createTsIdLoader(indexRouting, routingPaths);
        }
        return IdLoader.fromLeafStoredFieldLoader();
    }
}

