/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest.action.document;

import java.io.IOException;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.DocWriteResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.support.ActiveShardCount;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.cluster.metadata.DataStream;
import org.elasticsearch.common.bytes.ReleasableBytesReference;
import org.elasticsearch.index.VersionType;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestUtils;
import org.elasticsearch.rest.Scope;
import org.elasticsearch.rest.ServerlessScope;
import org.elasticsearch.rest.action.RestActions;
import org.elasticsearch.rest.action.RestToXContentListener;

@ServerlessScope(value=Scope.PUBLIC)
public class RestIndexAction
extends BaseRestHandler {
    static final String TYPES_DEPRECATION_MESSAGE = "[types removal] Specifying types in document index requests is deprecated, use the typeless endpoints instead (/{index}/_doc/{id}, /{index}/_doc, or /{index}/_create/{id}).";
    private final Set<String> capabilities = DataStream.isFailureStoreFeatureFlagEnabled() ? Set.of("failure_store_status") : Set.of();

    @Override
    public List<RestHandler.Route> routes() {
        return List.of(new RestHandler.Route(RestRequest.Method.POST, "/{index}/_doc/{id}"), new RestHandler.Route(RestRequest.Method.PUT, "/{index}/_doc/{id}"));
    }

    @Override
    public String getName() {
        return "document_index_action";
    }

    @Override
    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        ReleasableBytesReference source = request.requiredContent();
        IndexRequest indexRequest = new IndexRequest(request.param("index"));
        indexRequest.id(request.param("id"));
        indexRequest.routing(request.param("routing"));
        indexRequest.setPipeline(request.param("pipeline"));
        indexRequest.source(source, request.getXContentType());
        indexRequest.timeout(request.paramAsTime("timeout", IndexRequest.DEFAULT_TIMEOUT));
        indexRequest.setRefreshPolicy(request.param("refresh"));
        indexRequest.version(RestActions.parseVersion(request));
        indexRequest.versionType(VersionType.fromString(request.param("version_type"), indexRequest.versionType()));
        indexRequest.setIfSeqNo(request.paramAsLong("if_seq_no", indexRequest.ifSeqNo()));
        indexRequest.setIfPrimaryTerm(request.paramAsLong("if_primary_term", indexRequest.ifPrimaryTerm()));
        indexRequest.setRequireAlias(request.paramAsBoolean("require_alias", indexRequest.isRequireAlias()));
        indexRequest.setRequireDataStream(request.paramAsBoolean("require_data_stream", indexRequest.isRequireDataStream()));
        indexRequest.setIncludeSourceOnError(RestUtils.getIncludeSourceOnError(request));
        String sOpType = request.param("op_type");
        String waitForActiveShards = request.param("wait_for_active_shards");
        if (waitForActiveShards != null) {
            indexRequest.waitForActiveShards(ActiveShardCount.parseString(waitForActiveShards));
        }
        if (sOpType != null) {
            indexRequest.opType(sOpType);
        }
        return channel -> {
            source.mustIncRef();
            client.index(indexRequest, ActionListener.releaseAfter(new RestToXContentListener<DocWriteResponse>((RestChannel)channel, DocWriteResponse::status, r -> r.getLocation(indexRequest.routing())), source));
        };
    }

    @Override
    public Set<String> supportedCapabilities() {
        return this.capabilities;
    }

    @ServerlessScope(value=Scope.PUBLIC)
    public static final class AutoIdHandler
    extends RestIndexAction {
        @Override
        public String getName() {
            return "document_create_action_auto_id";
        }

        @Override
        public List<RestHandler.Route> routes() {
            return List.of(new RestHandler.Route(RestRequest.Method.POST, "/{index}/_doc"));
        }

        @Override
        public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
            assert (request.params().get("id") == null) : "non-null id: " + request.params().get("id");
            request.params().putIfAbsent("op_type", "create");
            return super.prepareRequest(request, client);
        }
    }

    @ServerlessScope(value=Scope.PUBLIC)
    public static final class CreateHandler
    extends RestIndexAction {
        @Override
        public String getName() {
            return "document_create_action";
        }

        @Override
        public List<RestHandler.Route> routes() {
            return List.of(new RestHandler.Route(RestRequest.Method.POST, "/{index}/_create/{id}"), new RestHandler.Route(RestRequest.Method.PUT, "/{index}/_create/{id}"));
        }

        @Override
        public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
            CreateHandler.validateOpType(request.params().get("op_type"));
            request.params().put("op_type", "create");
            return super.prepareRequest(request, client);
        }

        static void validateOpType(String opType) {
            if (null != opType && !"create".equals(opType.toLowerCase(Locale.ROOT))) {
                throw new IllegalArgumentException("opType must be 'create', found: [" + opType + "]");
            }
        }
    }
}

