/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.lucene.util.automaton;

import java.util.BitSet;
import java.util.LinkedList;
import org.apache.lucene.internal.hppc.IntArrayList;
import org.apache.lucene.internal.hppc.IntCursor;
import org.apache.lucene.internal.hppc.IntHashSet;
import org.apache.lucene.util.automaton.Automaton;
import org.apache.lucene.util.automaton.Operations;
import org.apache.lucene.util.automaton.Transition;

public final class MinimizationOperations {
    private MinimizationOperations() {
    }

    public static Automaton minimize(Automaton a, int determinizeWorkLimit) {
        int n;
        int q;
        if (a.getNumStates() == 0 || !a.isAccept(0) && a.getNumTransitions(0) == 0) {
            return new Automaton();
        }
        if ((a = Operations.determinize(a, determinizeWorkLimit)).getNumTransitions(0) == 1) {
            Transition t = new Transition();
            a.getTransition(0, 0, t);
            if (t.dest == 0 && t.min == 0 && t.max == 0x10FFFF) {
                return a;
            }
        }
        a = MinimizationOperations.totalize(a);
        int[] sigma = a.getStartPoints();
        int sigmaLen = sigma.length;
        int statesLen = a.getNumStates();
        IntArrayList[][] reverse = new IntArrayList[statesLen][sigmaLen];
        IntHashSet[] partition = new IntHashSet[statesLen];
        IntArrayList[] splitblock = new IntArrayList[statesLen];
        int[] block = new int[statesLen];
        StateList[][] active = new StateList[statesLen][sigmaLen];
        StateListNode[][] active2 = new StateListNode[statesLen][sigmaLen];
        LinkedList<IntPair> pending = new LinkedList<IntPair>();
        BitSet pending2 = new BitSet(sigmaLen * statesLen);
        BitSet split = new BitSet(statesLen);
        BitSet refine = new BitSet(statesLen);
        BitSet refine2 = new BitSet(statesLen);
        for (q = 0; q < statesLen; ++q) {
            splitblock[q] = new IntArrayList();
            partition[q] = new IntHashSet();
            for (int x = 0; x < sigmaLen; ++x) {
                active[q][x] = StateList.EMPTY;
            }
        }
        for (q = 0; q < statesLen; ++q) {
            Transition transition = new Transition();
            int j = a.isAccept(q) ? 0 : 1;
            partition[j].add(q);
            block[q] = j;
            transition.source = q;
            for (int x = 0; x < sigmaLen; ++x) {
                IntArrayList[] r = reverse[a.next(transition, sigma[x])];
                if (r[x] == null) {
                    r[x] = new IntArrayList();
                }
                r[x].add(q);
            }
        }
        for (int j = 0; j <= 1; ++j) {
            for (int x = 0; x < sigmaLen; ++x) {
                for (IntCursor qCursor : partition[j]) {
                    int q2 = qCursor.value;
                    if (reverse[q2][x] == null) continue;
                    StateList stateList = active[j][x];
                    if (stateList == StateList.EMPTY) {
                        active[j][x] = stateList = new StateList();
                    }
                    active2[q2][x] = stateList.add(q2);
                }
            }
        }
        for (int x = 0; x < sigmaLen; ++x) {
            int j = active[0][x].size <= active[1][x].size ? 0 : 1;
            pending.add(new IntPair(j, x));
            pending2.set(x * statesLen + j);
        }
        int k = 2;
        while (!pending.isEmpty()) {
            IntPair ip = (IntPair)pending.removeFirst();
            int p = ip.n1;
            int x = ip.n2;
            pending2.clear(x * statesLen + p);
            StateListNode m = active[p][x].first;
            while (m != null) {
                IntArrayList r = reverse[m.q][x];
                if (r != null) {
                    for (IntCursor iCursor : r) {
                        int i = iCursor.value;
                        if (split.get(i)) continue;
                        split.set(i);
                        int j = block[i];
                        splitblock[j].add(i);
                        if (refine2.get(j)) continue;
                        refine2.set(j);
                        refine.set(j);
                    }
                }
                m = m.next;
            }
            int j = refine.nextSetBit(0);
            while (j >= 0) {
                IntArrayList sb = splitblock[j];
                if (sb.size() < partition[j].size()) {
                    IntHashSet b1 = partition[j];
                    IntHashSet b2 = partition[k];
                    for (IntCursor iCursor : sb) {
                        int s = iCursor.value;
                        b1.remove(s);
                        b2.add(s);
                        block[s] = k;
                        for (int c = 0; c < sigmaLen; ++c) {
                            StateListNode sn = active2[s][c];
                            if (sn == null || sn.sl != active[j][c]) continue;
                            sn.remove();
                            StateList stateList = active[k][c];
                            if (stateList == StateList.EMPTY) {
                                active[k][c] = stateList = new StateList();
                            }
                            active2[s][c] = stateList.add(s);
                        }
                    }
                    for (int c = 0; c < sigmaLen; ++c) {
                        int aj = active[j][c].size;
                        int ak = active[k][c].size;
                        int ofs = c * statesLen;
                        if (!pending2.get(ofs + j) && 0 < aj && aj <= ak) {
                            pending2.set(ofs + j);
                            pending.add(new IntPair(j, c));
                            continue;
                        }
                        pending2.set(ofs + k);
                        pending.add(new IntPair(k, c));
                    }
                    ++k;
                }
                refine2.clear(j);
                for (IntCursor iCursor : sb) {
                    int s = iCursor.value;
                    split.clear(s);
                }
                sb.clear();
                j = refine.nextSetBit(j + 1);
            }
            refine.clear();
        }
        Automaton result = new Automaton();
        Transition t = new Transition();
        int[] stateMap = new int[statesLen];
        int[] stateRep = new int[k];
        result.createState();
        for (n = 0; n < k; ++n) {
            boolean isInitial = partition[n].contains(0);
            int newState = isInitial ? 0 : result.createState();
            for (IntCursor qCursor : partition[n]) {
                int q3 = qCursor.value;
                stateMap[q3] = newState;
                result.setAccept(newState, a.isAccept(q3));
                stateRep[newState] = q3;
            }
        }
        for (n = 0; n < k; ++n) {
            int numTransitions = a.initTransition(stateRep[n], t);
            for (int i = 0; i < numTransitions; ++i) {
                a.getNextTransition(t);
                result.addTransition(n, stateMap[t.dest], t.min, t.max);
            }
        }
        result.finishState();
        return Operations.removeDeadStates(result);
    }

    static Automaton totalize(Automaton a) {
        Automaton result = new Automaton();
        int numStates = a.getNumStates();
        for (int i = 0; i < numStates; ++i) {
            result.createState();
            result.setAccept(i, a.isAccept(i));
        }
        int deadState = result.createState();
        result.addTransition(deadState, deadState, 0, 0x10FFFF);
        Transition t = new Transition();
        for (int i = 0; i < numStates; ++i) {
            int maxi = 0;
            int count = a.initTransition(i, t);
            for (int j = 0; j < count; ++j) {
                a.getNextTransition(t);
                result.addTransition(i, t.dest, t.min, t.max);
                if (t.min > maxi) {
                    result.addTransition(i, deadState, maxi, t.min - 1);
                }
                if (t.max + 1 <= maxi) continue;
                maxi = t.max + 1;
            }
            if (maxi > 0x10FFFF) continue;
            result.addTransition(i, deadState, maxi, 0x10FFFF);
        }
        result.finishState();
        return result;
    }

    static final class StateList {
        static final StateList EMPTY = new StateList();
        int size;
        StateListNode first;
        StateListNode last;

        StateList() {
        }

        StateListNode add(int q) {
            assert (this != EMPTY);
            return new StateListNode(q, this);
        }
    }

    static final class StateListNode {
        final int q;
        StateListNode next;
        StateListNode prev;
        final StateList sl;

        StateListNode(int q, StateList sl) {
            this.q = q;
            this.sl = sl;
            if (sl.size++ == 0) {
                sl.first = sl.last = this;
            } else {
                sl.last.next = this;
                this.prev = sl.last;
                sl.last = this;
            }
        }

        void remove() {
            --this.sl.size;
            if (this.sl.first == this) {
                this.sl.first = this.next;
            } else {
                this.prev.next = this.next;
            }
            if (this.sl.last == this) {
                this.sl.last = this.prev;
            } else {
                this.next.prev = this.prev;
            }
        }
    }

    record IntPair(int n1, int n2) {
    }
}

