/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.geo;

import org.apache.lucene.util.SloppyMath;
import org.elasticsearch.core.ESSloppyMath;
import org.elasticsearch.geometry.Rectangle;

public class SphericalMercatorUtils {
    public static final double MERCATOR_BOUNDS = 2.003750834E7;
    private static final double MERCATOR_FACTOR = 111319.49077777777;
    private static final double TAN_LOWER_LIMIT = Math.tan(Math.nextUp(0.0));

    public static double lonToSphericalMercator(double lon) {
        return lon * 111319.49077777777;
    }

    public static double latToSphericalMercator(double lat) {
        double cos = SloppyMath.cos((90.0 + lat) * Math.PI / 360.0);
        double tan = Math.max(TAN_LOWER_LIMIT, Math.sqrt(1.0 - cos * cos) / cos);
        double y = ESSloppyMath.log(tan) / (Math.PI / 180);
        return y * 111319.49077777777;
    }

    public static Rectangle recToSphericalMercator(Rectangle r) {
        return new Rectangle(SphericalMercatorUtils.lonToSphericalMercator(r.getMinLon()), SphericalMercatorUtils.lonToSphericalMercator(r.getMaxLon()), SphericalMercatorUtils.latToSphericalMercator(r.getMaxLat()), SphericalMercatorUtils.latToSphericalMercator(r.getMinLat()));
    }

    private SphericalMercatorUtils() {
    }
}

