/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.nodes;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class ClusterStateQueue
implements JsonpSerializable {
    @Nullable
    private final Long total;
    @Nullable
    private final Long pending;
    @Nullable
    private final Long committed;
    public static final JsonpDeserializer<ClusterStateQueue> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ClusterStateQueue::setupClusterStateQueueDeserializer);

    private ClusterStateQueue(Builder builder) {
        this.total = builder.total;
        this.pending = builder.pending;
        this.committed = builder.committed;
    }

    public static ClusterStateQueue of(Function<Builder, ObjectBuilder<ClusterStateQueue>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Long total() {
        return this.total;
    }

    @Nullable
    public final Long pending() {
        return this.pending;
    }

    @Nullable
    public final Long committed() {
        return this.committed;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.total != null) {
            generator.writeKey("total");
            generator.write(this.total);
        }
        if (this.pending != null) {
            generator.writeKey("pending");
            generator.write(this.pending);
        }
        if (this.committed != null) {
            generator.writeKey("committed");
            generator.write(this.committed);
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupClusterStateQueueDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::total, JsonpDeserializer.longDeserializer(), "total");
        op.add(Builder::pending, JsonpDeserializer.longDeserializer(), "pending");
        op.add(Builder::committed, JsonpDeserializer.longDeserializer(), "committed");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<ClusterStateQueue> {
        @Nullable
        private Long total;
        @Nullable
        private Long pending;
        @Nullable
        private Long committed;

        public final Builder total(@Nullable Long value) {
            this.total = value;
            return this;
        }

        public final Builder pending(@Nullable Long value) {
            this.pending = value;
            return this;
        }

        public final Builder committed(@Nullable Long value) {
            this.committed = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public ClusterStateQueue build() {
            this._checkSingleUse();
            return new ClusterStateQueue(this);
        }
    }
}

