/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.analysis;

import co.elastic.clients.elasticsearch._types.analysis.TokenizerBase;
import co.elastic.clients.elasticsearch._types.analysis.TokenizerDefinition;
import co.elastic.clients.elasticsearch._types.analysis.TokenizerDefinitionVariant;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class SimplePatternTokenizer
extends TokenizerBase
implements TokenizerDefinitionVariant {
    @Nullable
    private final String pattern;
    public static final JsonpDeserializer<SimplePatternTokenizer> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, SimplePatternTokenizer::setupSimplePatternTokenizerDeserializer);

    private SimplePatternTokenizer(Builder builder) {
        super(builder);
        this.pattern = builder.pattern;
    }

    public static SimplePatternTokenizer of(Function<Builder, ObjectBuilder<SimplePatternTokenizer>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public TokenizerDefinition.Kind _tokenizerDefinitionKind() {
        return TokenizerDefinition.Kind.SimplePattern;
    }

    @Nullable
    public final String pattern() {
        return this.pattern;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.write("type", "simple_pattern");
        super.serializeInternal(generator, mapper);
        if (this.pattern != null) {
            generator.writeKey("pattern");
            generator.write(this.pattern);
        }
    }

    protected static void setupSimplePatternTokenizerDeserializer(ObjectDeserializer<Builder> op) {
        TokenizerBase.setupTokenizerBaseDeserializer(op);
        op.add(Builder::pattern, JsonpDeserializer.stringDeserializer(), "pattern");
        op.ignore("type");
    }

    public static class Builder
    extends TokenizerBase.AbstractBuilder<Builder>
    implements ObjectBuilder<SimplePatternTokenizer> {
        @Nullable
        private String pattern;

        public final Builder pattern(@Nullable String value) {
            this.pattern = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public SimplePatternTokenizer build() {
            this._checkSingleUse();
            return new SimplePatternTokenizer(this);
        }
    }
}

