/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.aggregations;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class InferenceClassImportance
implements JsonpSerializable {
    private final String className;
    private final double importance;
    public static final JsonpDeserializer<InferenceClassImportance> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, InferenceClassImportance::setupInferenceClassImportanceDeserializer);

    private InferenceClassImportance(Builder builder) {
        this.className = ApiTypeHelper.requireNonNull(builder.className, this, "className");
        this.importance = ApiTypeHelper.requireNonNull(builder.importance, (Object)this, "importance", 0.0);
    }

    public static InferenceClassImportance of(Function<Builder, ObjectBuilder<InferenceClassImportance>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String className() {
        return this.className;
    }

    public final double importance() {
        return this.importance;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("class_name");
        generator.write(this.className);
        generator.writeKey("importance");
        generator.write(this.importance);
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupInferenceClassImportanceDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::className, JsonpDeserializer.stringDeserializer(), "class_name");
        op.add(Builder::importance, JsonpDeserializer.doubleDeserializer(), "importance");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<InferenceClassImportance> {
        private String className;
        private Double importance;

        public final Builder className(String value) {
            this.className = value;
            return this;
        }

        public final Builder importance(double value) {
            this.importance = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public InferenceClassImportance build() {
            this._checkSingleUse();
            return new InferenceClassImportance(this);
        }
    }
}

