/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.aggregations;

import co.elastic.clients.elasticsearch._types.GeoLocation;
import co.elastic.clients.elasticsearch._types.aggregations.Aggregation;
import co.elastic.clients.elasticsearch._types.aggregations.AggregationVariant;
import co.elastic.clients.elasticsearch._types.aggregations.MetricAggregationBase;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class GeoCentroidAggregation
extends MetricAggregationBase
implements AggregationVariant {
    @Nullable
    private final Long count;
    @Nullable
    private final GeoLocation location;
    public static final JsonpDeserializer<GeoCentroidAggregation> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, GeoCentroidAggregation::setupGeoCentroidAggregationDeserializer);

    private GeoCentroidAggregation(Builder builder) {
        super(builder);
        this.count = builder.count;
        this.location = builder.location;
    }

    public static GeoCentroidAggregation of(Function<Builder, ObjectBuilder<GeoCentroidAggregation>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Aggregation.Kind _aggregationKind() {
        return Aggregation.Kind.GeoCentroid;
    }

    @Nullable
    public final Long count() {
        return this.count;
    }

    @Nullable
    public final GeoLocation location() {
        return this.location;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (this.count != null) {
            generator.writeKey("count");
            generator.write(this.count);
        }
        if (this.location != null) {
            generator.writeKey("location");
            this.location.serialize(generator, mapper);
        }
    }

    protected static void setupGeoCentroidAggregationDeserializer(ObjectDeserializer<Builder> op) {
        MetricAggregationBase.setupMetricAggregationBaseDeserializer(op);
        op.add(Builder::count, JsonpDeserializer.longDeserializer(), "count");
        op.add(Builder::location, GeoLocation._DESERIALIZER, "location");
    }

    public static class Builder
    extends MetricAggregationBase.AbstractBuilder<Builder>
    implements ObjectBuilder<GeoCentroidAggregation> {
        @Nullable
        private Long count;
        @Nullable
        private GeoLocation location;

        public final Builder count(@Nullable Long value) {
            this.count = value;
            return this;
        }

        public final Builder location(@Nullable GeoLocation value) {
            this.location = value;
            return this;
        }

        public final Builder location(Function<GeoLocation.Builder, ObjectBuilder<GeoLocation>> fn) {
            return this.location(fn.apply(new GeoLocation.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public GeoCentroidAggregation build() {
            this._checkSingleUse();
            return new GeoCentroidAggregation(this);
        }
    }
}

