/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.aggregations;

import co.elastic.clients.elasticsearch._types.Script;
import co.elastic.clients.elasticsearch._types.SortOrder;
import co.elastic.clients.elasticsearch._types.aggregations.MissingOrder;
import co.elastic.clients.elasticsearch._types.aggregations.ValueType;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

public abstract class CompositeAggregationBase
implements JsonpSerializable {
    @Nullable
    private final String field;
    @Nullable
    private final Boolean missingBucket;
    @Nullable
    private final MissingOrder missingOrder;
    @Nullable
    private final Script script;
    @Nullable
    private final ValueType valueType;
    @Nullable
    private final SortOrder order;

    protected CompositeAggregationBase(AbstractBuilder<?> builder) {
        this.field = ((AbstractBuilder)builder).field;
        this.missingBucket = ((AbstractBuilder)builder).missingBucket;
        this.missingOrder = ((AbstractBuilder)builder).missingOrder;
        this.script = ((AbstractBuilder)builder).script;
        this.valueType = ((AbstractBuilder)builder).valueType;
        this.order = ((AbstractBuilder)builder).order;
    }

    @Nullable
    public final String field() {
        return this.field;
    }

    @Nullable
    public final Boolean missingBucket() {
        return this.missingBucket;
    }

    @Nullable
    public final MissingOrder missingOrder() {
        return this.missingOrder;
    }

    @Nullable
    public final Script script() {
        return this.script;
    }

    @Nullable
    public final ValueType valueType() {
        return this.valueType;
    }

    @Nullable
    public final SortOrder order() {
        return this.order;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.field != null) {
            generator.writeKey("field");
            generator.write(this.field);
        }
        if (this.missingBucket != null) {
            generator.writeKey("missing_bucket");
            generator.write(this.missingBucket);
        }
        if (this.missingOrder != null) {
            generator.writeKey("missing_order");
            this.missingOrder.serialize(generator, mapper);
        }
        if (this.script != null) {
            generator.writeKey("script");
            this.script.serialize(generator, mapper);
        }
        if (this.valueType != null) {
            generator.writeKey("value_type");
            this.valueType.serialize(generator, mapper);
        }
        if (this.order != null) {
            generator.writeKey("order");
            this.order.serialize(generator, mapper);
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static <BuilderT extends AbstractBuilder<BuilderT>> void setupCompositeAggregationBaseDeserializer(ObjectDeserializer<BuilderT> op) {
        op.add(AbstractBuilder::field, JsonpDeserializer.stringDeserializer(), "field");
        op.add(AbstractBuilder::missingBucket, JsonpDeserializer.booleanDeserializer(), "missing_bucket");
        op.add(AbstractBuilder::missingOrder, MissingOrder._DESERIALIZER, "missing_order");
        op.add(AbstractBuilder::script, Script._DESERIALIZER, "script");
        op.add(AbstractBuilder::valueType, ValueType._DESERIALIZER, "value_type");
        op.add(AbstractBuilder::order, SortOrder._DESERIALIZER, "order");
    }

    public static abstract class AbstractBuilder<BuilderT extends AbstractBuilder<BuilderT>>
    extends WithJsonObjectBuilderBase<BuilderT> {
        @Nullable
        private String field;
        @Nullable
        private Boolean missingBucket;
        @Nullable
        private MissingOrder missingOrder;
        @Nullable
        private Script script;
        @Nullable
        private ValueType valueType;
        @Nullable
        private SortOrder order;

        public final BuilderT field(@Nullable String value) {
            this.field = value;
            return (BuilderT)this.self();
        }

        public final BuilderT missingBucket(@Nullable Boolean value) {
            this.missingBucket = value;
            return (BuilderT)this.self();
        }

        public final BuilderT missingOrder(@Nullable MissingOrder value) {
            this.missingOrder = value;
            return (BuilderT)this.self();
        }

        public final BuilderT script(@Nullable Script value) {
            this.script = value;
            return (BuilderT)this.self();
        }

        public final BuilderT script(Function<Script.Builder, ObjectBuilder<Script>> fn) {
            return this.script(fn.apply(new Script.Builder()).build());
        }

        public final BuilderT valueType(@Nullable ValueType value) {
            this.valueType = value;
            return (BuilderT)this.self();
        }

        public final BuilderT order(@Nullable SortOrder value) {
            this.order = value;
            return (BuilderT)this.self();
        }

        @Override
        protected abstract BuilderT self();
    }
}

