/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql;

import org.apache.derby.catalog.types.RoutineAliasInfo;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.TypeId;
import org.apache.derby.impl.jdbc.Util;
import org.apache.derby.impl.sql.GenericParameterValueSet;
import org.apache.derby.shared.common.error.StandardException;

final class GenericParameter {
    private static int DECIMAL_PARAMETER_DEFAULT_PRECISION = 31;
    private static int DECIMAL_PARAMETER_DEFAULT_SCALE = 15;
    private final GenericParameterValueSet pvs;
    private DataValueDescriptor value;
    int jdbcTypeId;
    String declaredClassName;
    short parameterMode;
    boolean isSet;
    private final boolean isReturnOutputParameter;
    int registerOutType = 0;
    int registerOutScale = -1;
    int registerOutPrecision = -1;

    GenericParameter(GenericParameterValueSet pvs, boolean isReturnOutputParameter) {
        this.pvs = pvs;
        this.isReturnOutputParameter = isReturnOutputParameter;
        this.parameterMode = (short)(this.isReturnOutputParameter ? 4 : 1);
    }

    public GenericParameter getClone(GenericParameterValueSet pvs) {
        GenericParameter gpClone = new GenericParameter(pvs, this.isReturnOutputParameter);
        gpClone.initialize(this.getValue().cloneValue(false), this.jdbcTypeId, this.declaredClassName);
        gpClone.isSet = true;
        return gpClone;
    }

    void initialize(DataValueDescriptor value, int jdbcTypeId, String className) {
        this.value = value;
        this.jdbcTypeId = jdbcTypeId;
        this.declaredClassName = className;
    }

    void clear() {
        this.isSet = false;
    }

    DataValueDescriptor getValue() {
        return this.value;
    }

    void setOutParameter(int sqlType, int scale) throws StandardException {
        if (this.registerOutType == sqlType && scale == this.registerOutScale) {
            return;
        }
        switch (this.parameterMode) {
            default: {
                throw StandardException.newException((String)"XCL22.S", (Object[])new Object[]{this.getJDBCParameterNumberStr()});
            }
            case 2: 
            case 4: 
        }
        if (!DataTypeDescriptor.isJDBCTypeEquivalent(this.jdbcTypeId, sqlType)) {
            throw this.throwInvalidOutParamMap(sqlType);
        }
        this.registerOutType = sqlType;
    }

    private StandardException throwInvalidOutParamMap(int sqlType) {
        String jdbcTypesName = Util.typeName(sqlType);
        TypeId typeId = TypeId.getBuiltInTypeId(this.jdbcTypeId);
        String thisTypeName = typeId == null ? this.declaredClassName : typeId.getSQLTypeName();
        StandardException e = StandardException.newException((String)"XCL25.S", (Object[])new Object[]{this.getJDBCParameterNumberStr(), jdbcTypesName, thisTypeName});
        return e;
    }

    void validate() throws StandardException {
        switch (this.parameterMode) {
            case 0: {
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 4: {
                if (this.registerOutType != 0) break;
                throw StandardException.newException((String)"07004", (Object[])new Object[]{this.getJDBCParameterNumberStr(), RoutineAliasInfo.parameterMode(this.parameterMode)});
            }
        }
    }

    int getScale() {
        return this.registerOutScale == -1 ? 0 : this.registerOutScale;
    }

    int getPrecision() {
        return this.registerOutPrecision;
    }

    String getJDBCParameterNumberStr() {
        return Integer.toString(this.pvs.getParameterNumber(this));
    }

    public String toString() {
        if (this.value == null) {
            return "null";
        }
        try {
            return this.value.getTraceString();
        }
        catch (StandardException se) {
            return "unexpected exception from getTraceString() - " + String.valueOf((Object)se);
        }
    }
}

