/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.client.am;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.derby.client.am.ClientBlob;
import org.apache.derby.client.am.ClientConnection;
import org.apache.derby.client.am.SqlException;
import org.apache.derby.shared.common.sanity.SanityManager;

class BlobLocatorOutputStream
extends OutputStream {
    private final ClientConnection connection;
    private final ClientBlob blob;
    private long currentPos;

    BlobLocatorOutputStream(ClientConnection connection, ClientBlob blob, long pos) throws SqlException {
        SanityManager.ASSERT((boolean)blob.isLocator());
        if (pos - 1L > blob.sqlLength()) {
            throw new IndexOutOfBoundsException();
        }
        this.connection = connection;
        this.blob = blob;
        this.currentPos = pos;
    }

    @Override
    public void write(int b) throws IOException {
        byte[] ba = new byte[]{(byte)b};
        this.writeBytes(ba);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.writeBytes(b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (len == 0) {
            return;
        }
        if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        byte[] ba = b;
        if (off > 0 || len < b.length) {
            ba = new byte[len];
            System.arraycopy(b, off, ba, 0, len);
        }
        this.writeBytes(ba);
    }

    private void writeBytes(byte[] b) throws IOException {
        try {
            this.blob.setBytesX(this.currentPos, b, 0, b.length);
            this.currentPos += (long)b.length;
        }
        catch (SqlException ex) {
            IOException ioEx = new IOException();
            ioEx.initCause(ex);
            throw ioEx;
        }
    }
}

