/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.execution;

import co.elastic.logstash.api.TimerMetric;
import java.io.IOException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyHash;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.javasupport.JavaUtil;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.logstash.RubyUtil;
import org.logstash.execution.QueueBatch;
import org.logstash.execution.QueueReadClient;
import org.logstash.instrument.metrics.AbstractMetricExt;
import org.logstash.instrument.metrics.AbstractNamespacedMetricExt;
import org.logstash.instrument.metrics.MetricKeys;
import org.logstash.instrument.metrics.counter.LongCounter;
import org.logstash.instrument.metrics.timer.TimerMetric;

@JRubyClass(name={"QueueReadClientBase"})
public abstract class QueueReadClientBase
extends RubyObject
implements QueueReadClient {
    private static final long serialVersionUID = 1L;
    protected int batchSize = 125;
    protected long waitForNanos = 50000000L;
    protected long waitForMillis = 50L;
    private final ConcurrentHashMap<Long, QueueBatch> inflightBatches = new ConcurrentHashMap();
    private transient LongCounter eventMetricOut;
    private transient LongCounter eventMetricFiltered;
    private transient TimerMetric eventMetricTime;
    private transient LongCounter pipelineMetricOut;
    private transient LongCounter pipelineMetricFiltered;
    private transient TimerMetric pipelineMetricTime;

    protected QueueReadClientBase(Ruby runtime, RubyClass metaClass) {
        super(runtime, metaClass);
    }

    @JRubyMethod(name={"inflight_batches"})
    public RubyHash rubyGetInflightBatches(ThreadContext context) {
        RubyHash result = RubyHash.newHash((Ruby)context.runtime);
        result.putAll(this.inflightBatches);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(name={"set_events_metric"})
    public IRubyObject setEventsMetric(IRubyObject metric) {
        AbstractNamespacedMetricExt namespacedMetric = (AbstractNamespacedMetricExt)metric;
        AbstractMetricExt abstractMetricExt = namespacedMetric.getMetric();
        synchronized (abstractMetricExt) {
            this.eventMetricOut = LongCounter.fromRubyBase(namespacedMetric, MetricKeys.OUT_KEY);
            this.eventMetricFiltered = LongCounter.fromRubyBase(namespacedMetric, MetricKeys.FILTERED_KEY);
            this.eventMetricTime = TimerMetric.fromRubyBase(namespacedMetric, MetricKeys.DURATION_IN_MILLIS_KEY);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(name={"set_pipeline_metric"})
    public IRubyObject setPipelineMetric(IRubyObject metric) {
        AbstractNamespacedMetricExt namespacedMetric = (AbstractNamespacedMetricExt)metric;
        AbstractMetricExt abstractMetricExt = namespacedMetric.getMetric();
        synchronized (abstractMetricExt) {
            this.pipelineMetricOut = LongCounter.fromRubyBase(namespacedMetric, MetricKeys.OUT_KEY);
            this.pipelineMetricFiltered = LongCounter.fromRubyBase(namespacedMetric, MetricKeys.FILTERED_KEY);
            this.pipelineMetricTime = TimerMetric.fromRubyBase(namespacedMetric, MetricKeys.DURATION_IN_MILLIS_KEY);
        }
        return this;
    }

    @JRubyMethod(name={"set_batch_dimensions"})
    public IRubyObject rubySetBatchDimensions(IRubyObject batchSize, IRubyObject waitForMillis) {
        this.setBatchDimensions(((RubyNumeric)batchSize).getIntValue(), ((RubyNumeric)waitForMillis).getIntValue());
        return this;
    }

    public void setBatchDimensions(int batchSize, int waitForMillis) {
        this.batchSize = batchSize;
        this.waitForNanos = TimeUnit.NANOSECONDS.convert(waitForMillis, TimeUnit.MILLISECONDS);
        this.waitForMillis = waitForMillis;
    }

    @JRubyMethod(name={"empty?"})
    public IRubyObject rubyIsEmpty(ThreadContext context) {
        return context.runtime.newBoolean(this.isEmpty());
    }

    @JRubyMethod(name={"close"})
    public void rubyClose(ThreadContext context) {
        try {
            this.close();
        }
        catch (IOException e) {
            throw RubyUtil.newRubyIOError(context.runtime, e);
        }
    }

    @JRubyMethod(name={"read_batch"})
    public IRubyObject rubyReadBatch(ThreadContext context) throws InterruptedException {
        return RubyUtil.toRubyObject(this.readBatch());
    }

    @Override
    public void closeBatch(QueueBatch batch) throws IOException {
        batch.close();
        this.inflightBatches.remove(Thread.currentThread().getId());
    }

    @JRubyMethod(name={"close_batch"})
    public void rubyCloseBatch(IRubyObject batch) throws IOException {
        this.closeBatch(QueueReadClientBase.extractQueueBatch(batch));
    }

    @JRubyMethod(name={"start_metrics"})
    public void rubyStartMetrics(IRubyObject batch) {
        this.startMetrics(QueueReadClientBase.extractQueueBatch(batch));
    }

    private static QueueBatch extractQueueBatch(IRubyObject batch) {
        return (QueueBatch)JavaUtil.unwrapIfJavaObject((IRubyObject)batch);
    }

    @JRubyMethod(name={"add_filtered_metrics"})
    public void rubyAddFilteredMetrics(IRubyObject size) {
        this.addFilteredMetrics(((RubyNumeric)size).getIntValue());
    }

    @JRubyMethod(name={"add_output_metrics"})
    public void rubyAddOutputMetrics(IRubyObject size) {
        this.addOutputMetrics(((RubyNumeric)size).getIntValue());
    }

    @Override
    public void startMetrics(QueueBatch batch) {
        long threadId = Thread.currentThread().getId();
        this.inflightBatches.put(threadId, batch);
    }

    @Override
    public void addFilteredMetrics(int filteredSize) {
        this.eventMetricFiltered.increment(filteredSize);
        this.pipelineMetricFiltered.increment(filteredSize);
    }

    @Override
    public void addOutputMetrics(int filteredSize) {
        this.eventMetricOut.increment(filteredSize);
        this.pipelineMetricOut.increment(filteredSize);
    }

    @Override
    public <V, E extends Exception> V executeWithTimers(TimerMetric.ExceptionalSupplier<V, E> supplier) throws E {
        return (V)this.eventMetricTime.time(() -> this.pipelineMetricTime.time(supplier));
    }

    @Override
    public <E extends Exception> void executeWithTimers(TimerMetric.ExceptionalRunnable<E> runnable) throws E {
        this.eventMetricTime.time(() -> this.pipelineMetricTime.time(runnable));
    }

    @JRubyMethod(name={"execute_with_timers"})
    public IRubyObject executeWithTimersRuby(ThreadContext context, Block block) {
        return this.executeWithTimers(() -> block.call(context));
    }

    public abstract void close() throws IOException;
}

