/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.javasupport;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jruby.Ruby;
import org.jruby.javasupport.JavaClass;
import org.jruby.javasupport.JavaSupport;
import org.jruby.javasupport.binding.AssignedName;
import org.jruby.javasupport.proxy.JavaProxyClass;
import org.jruby.util.ArraySupport;
import org.jruby.util.WeakIdentityHashMap;
import org.jruby.util.collections.ClassValue;

public class JavaSupportImpl
extends JavaSupport {
    private final ClassValue<Map<String, AssignedName>> staticAssignedNames = ClassValue.newInstance(klass -> new HashMap(8, 1.0f));
    private final ClassValue<Map<String, AssignedName>> instanceAssignedNames = ClassValue.newInstance(klass -> new HashMap(8, 1.0f));
    private final Map<ProxyClassKey, JavaProxyClass> javaProxyClasses = new HashMap<ProxyClassKey, JavaProxyClass>();
    @Deprecated
    private volatile Map<Object, Object[]> javaObjectVariables;

    public JavaSupportImpl(Ruby runtime2) {
        super(runtime2);
    }

    @Override
    @Deprecated
    public Map<String, JavaClass> getNameClassMap() {
        return Collections.emptyMap();
    }

    @Override
    public ClassValue<Map<String, AssignedName>> getStaticAssignedNames() {
        return this.staticAssignedNames;
    }

    @Override
    public ClassValue<Map<String, AssignedName>> getInstanceAssignedNames() {
        return this.instanceAssignedNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public Map<Set<?>, JavaProxyClass> getJavaProxyClassCache() {
        HashMap javaProxyClassCache = new HashMap(this.javaProxyClasses.size());
        Map<ProxyClassKey, JavaProxyClass> map2 = this.javaProxyClasses;
        synchronized (map2) {
            for (Map.Entry<ProxyClassKey, JavaProxyClass> entry : this.javaProxyClasses.entrySet()) {
                ProxyClassKey key2 = entry.getKey();
                HashSet<Object> cacheKey = new HashSet<Object>();
                cacheKey.add(key2.superClass);
                for (int i2 = 0; i2 < key2.interfaces.length; ++i2) {
                    cacheKey.add(key2.interfaces[i2]);
                }
                if (!key2.names.isEmpty()) {
                    cacheKey.addAll(key2.names);
                }
                javaProxyClassCache.put(cacheKey, entry.getValue());
            }
        }
        return Collections.unmodifiableMap(javaProxyClassCache);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected JavaProxyClass fetchJavaProxyClass(ProxyClassKey classKey) {
        Map<ProxyClassKey, JavaProxyClass> map2 = this.javaProxyClasses;
        synchronized (map2) {
            return this.javaProxyClasses.get(classKey);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected JavaProxyClass saveJavaProxyClass(ProxyClassKey classKey, JavaProxyClass klass) {
        Map<ProxyClassKey, JavaProxyClass> map2 = this.javaProxyClasses;
        synchronized (map2) {
            JavaProxyClass existing = this.javaProxyClasses.get(classKey);
            if (existing != null) {
                return existing;
            }
            this.javaProxyClasses.put(classKey, klass);
        }
        return klass;
    }

    public static JavaProxyClass fetchJavaProxyClass(Ruby runtime2, ProxyClassKey classKey) {
        return ((JavaSupportImpl)runtime2.getJavaSupport()).fetchJavaProxyClass(classKey);
    }

    public static JavaProxyClass saveJavaProxyClass(Ruby runtime2, ProxyClassKey classKey, JavaProxyClass klass) {
        return ((JavaSupportImpl)runtime2.getJavaSupport()).saveJavaProxyClass(classKey, klass);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public Object getJavaObjectVariable(Object o, int i2) {
        if (i2 == -1) {
            return null;
        }
        Map<Object, Object[]> variables = this.javaObjectVariables;
        if (variables == null) {
            return null;
        }
        JavaSupportImpl javaSupportImpl = this;
        synchronized (javaSupportImpl) {
            Object[] vars = variables.get(o);
            if (vars == null || vars.length <= i2) {
                return null;
            }
            return vars[i2];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void setJavaObjectVariable(Object o, int i2, Object v) {
        if (i2 == -1) {
            return;
        }
        JavaSupportImpl javaSupportImpl = this;
        synchronized (javaSupportImpl) {
            Object[] vars;
            WeakIdentityHashMap variables = this.javaObjectVariables;
            if (variables == null) {
                variables = this.javaObjectVariables = new WeakIdentityHashMap();
            }
            if ((vars = variables.get(o)) == null) {
                vars = new Object[i2 + 1];
                variables.put(o, vars);
            } else if (vars.length <= i2) {
                vars = ArraySupport.newCopy(vars, i2 + 1);
                variables.put(o, vars);
            }
            vars[i2] = v;
        }
    }

    public static final class ProxyClassKey {
        final Class superClass;
        final Class[] interfaces;
        final Set<String> names;
        private int hash;

        private ProxyClassKey(Class superClass, Class[] interfaces2, Set<String> names2) {
            this.superClass = superClass;
            this.interfaces = interfaces2;
            this.names = names2;
        }

        public static ProxyClassKey getInstance(Class superClass, Class[] interfaces2, Set<String> names2) {
            return new ProxyClassKey(superClass, interfaces2, names2);
        }

        public boolean equals(Object obj) {
            if (obj instanceof ProxyClassKey) {
                ProxyClassKey that = (ProxyClassKey)obj;
                if (this.superClass != that.superClass) {
                    return false;
                }
                if (this.names.size() != that.names.size()) {
                    return false;
                }
                if (!this.names.equals(that.names)) {
                    return false;
                }
                int len = this.interfaces.length;
                if (len != that.interfaces.length) {
                    return false;
                }
                for (int i2 = 0; i2 < len; ++i2) {
                    Class iface = this.interfaces[i2];
                    boolean ifaceFound = false;
                    for (int j = 0; j < len; ++j) {
                        if (iface != that.interfaces[j]) continue;
                        ifaceFound = true;
                        break;
                    }
                    if (ifaceFound) continue;
                    return false;
                }
                return true;
            }
            return false;
        }

        public int hashCode() {
            int hash2 = this.hash;
            if (hash2 != 0) {
                return hash2;
            }
            for (int i2 = 0; i2 < this.interfaces.length; ++i2) {
                hash2 += this.interfaces[i2].hashCode();
            }
            this.hash = hash2 * this.superClass.hashCode() ^ this.names.hashCode();
            return this.hash;
        }
    }
}

