/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.template;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.metadata.ComponentTemplate;
import org.elasticsearch.cluster.metadata.ComposableIndexTemplate;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xcontent.NamedXContentRegistry;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentParserConfiguration;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xcontent.yaml.YamlXContent;
import org.elasticsearch.xpack.core.ilm.LifecyclePolicy;
import org.elasticsearch.xpack.core.ilm.LifecyclePolicyUtils;
import org.elasticsearch.xpack.core.template.IndexTemplateRegistry;
import org.elasticsearch.xpack.core.template.IngestPipelineConfig;
import org.elasticsearch.xpack.core.template.LifecyclePolicyConfig;
import org.elasticsearch.xpack.core.template.ResourceUtils;
import org.elasticsearch.xpack.core.template.YamlIngestPipelineConfig;

public abstract class YamlTemplateRegistry
extends IndexTemplateRegistry {
    private static final Logger logger = LogManager.getLogger(YamlTemplateRegistry.class);
    private final int version;
    private final Map<String, ComponentTemplate> componentTemplates;
    private final Map<String, ComposableIndexTemplate> composableIndexTemplates;
    private final List<IngestPipelineConfig> ingestPipelines;
    private final List<LifecyclePolicy> lifecyclePolicies;
    private volatile boolean enabled;

    public YamlTemplateRegistry(Settings nodeSettings, ClusterService clusterService, ThreadPool threadPool, Client client, NamedXContentRegistry xContentRegistry) {
        this(nodeSettings, clusterService, threadPool, client, xContentRegistry, ignored -> true);
    }

    public YamlTemplateRegistry(Settings nodeSettings, ClusterService clusterService, ThreadPool threadPool, Client client, NamedXContentRegistry xContentRegistry, Predicate<String> templateFilter) {
        super(nodeSettings, clusterService, threadPool, client, xContentRegistry);
        try {
            Map<String, Object> resources = XContentHelper.convertToMap(YamlXContent.yamlXContent, ResourceUtils.loadResource(this.getClass(), "/resources.yaml"), false);
            this.version = ((Number)resources.get("version")).intValue();
            List componentTemplateNames = (List)resources.get("component-templates");
            List indexTemplateNames = (List)resources.get("index-templates");
            List ingestPipelineConfigs = (List)resources.get("ingest-pipelines");
            List lifecyclePolicyConfigs = (List)resources.get("lifecycle-policies");
            this.componentTemplates = Optional.ofNullable(componentTemplateNames).orElse(Collections.emptyList()).stream().map(o -> (String)o).filter(templateFilter).collect(Collectors.toMap(name -> name, name -> this.loadComponentTemplate((String)name, this.version)));
            this.composableIndexTemplates = Optional.ofNullable(indexTemplateNames).orElse(Collections.emptyList()).stream().map(o -> (String)o).filter(templateFilter).collect(Collectors.toMap(name -> name, name -> this.loadIndexTemplate((String)name, this.version)));
            this.ingestPipelines = Optional.ofNullable(ingestPipelineConfigs).orElse(Collections.emptyList()).stream().map(o -> (Map)o).map(map -> {
                Map.Entry pipelineConfig = map.entrySet().iterator().next();
                return this.loadIngestPipeline((String)pipelineConfig.getKey(), this.version, (List)((Map)pipelineConfig.getValue()).get("dependencies"));
            }).collect(Collectors.toList());
            this.lifecyclePolicies = Optional.ofNullable(lifecyclePolicyConfigs).orElse(Collections.emptyList()).stream().map(o -> (String)o).filter(templateFilter).map(this::loadLifecyclePolicy).collect(Collectors.toList());
        }
        catch (IOException e) {
            throw new ElasticsearchException(e);
        }
    }

    public int getVersion() {
        return this.version;
    }

    public abstract String getName();

    public void setEnabled(boolean enabled) {
        logger.info("{} index template registry is {}", (Object)this.getName(), (Object)(enabled ? "enabled" : "disabled"));
        this.enabled = enabled;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void close() {
        this.clusterService.removeListener(this);
    }

    @Override
    protected boolean requiresMasterNode() {
        return true;
    }

    @Override
    public Map<String, ComponentTemplate> getComponentTemplateConfigs() {
        if (this.enabled) {
            return this.componentTemplates;
        }
        return Map.of();
    }

    @Override
    public Map<String, ComposableIndexTemplate> getComposableTemplateConfigs() {
        if (this.enabled) {
            return this.composableIndexTemplates;
        }
        return Map.of();
    }

    @Override
    public List<IngestPipelineConfig> getIngestPipelines() {
        if (this.enabled) {
            return this.ingestPipelines;
        }
        return Collections.emptyList();
    }

    @Override
    public List<LifecyclePolicy> getLifecyclePolicies() {
        if (this.enabled) {
            return this.lifecyclePolicies;
        }
        return Collections.emptyList();
    }

    protected abstract String getVersionProperty();

    private ComponentTemplate loadComponentTemplate(String name, int version) {
        ComponentTemplate componentTemplate;
        block8: {
            byte[] content = ResourceUtils.loadVersionedResourceUTF8(this.getClass(), "/component-templates/" + name + ".yaml", version, this.getVersionProperty());
            XContentParser parser = YamlXContent.yamlXContent.createParser(XContentParserConfiguration.EMPTY, content);
            try {
                componentTemplate = ComponentTemplate.parse(parser);
                if (parser == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (parser != null) {
                        try {
                            parser.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new ElasticsearchException("failed to load " + this.getName() + " Ingest plugin's component template: " + name, (Throwable)e, new Object[0]);
                }
            }
            parser.close();
        }
        return componentTemplate;
    }

    private ComposableIndexTemplate loadIndexTemplate(String name, int version) {
        ComposableIndexTemplate composableIndexTemplate;
        block8: {
            byte[] content = ResourceUtils.loadVersionedResourceUTF8(this.getClass(), "/index-templates/" + name + ".yaml", version, this.getVersionProperty());
            XContentParser parser = YamlXContent.yamlXContent.createParser(XContentParserConfiguration.EMPTY, content);
            try {
                composableIndexTemplate = ComposableIndexTemplate.parse(parser);
                if (parser == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (parser != null) {
                        try {
                            parser.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new ElasticsearchException("failed to load " + this.getName() + " Ingest plugin's index template: " + name, (Throwable)e, new Object[0]);
                }
            }
            parser.close();
        }
        return composableIndexTemplate;
    }

    private IngestPipelineConfig loadIngestPipeline(String name, int version, @Nullable List<String> dependencies) {
        if (dependencies == null) {
            dependencies = Collections.emptyList();
        }
        return new YamlIngestPipelineConfig(name, "/ingest-pipelines/" + name + ".yaml", version, this.getVersionProperty(), dependencies, this.getClass());
    }

    private LifecyclePolicy loadLifecyclePolicy(String name) {
        try {
            String rawPolicy = ResourceUtils.loadResource(this.getClass(), "/lifecycle-policies/" + name + ".yaml");
            return LifecyclePolicyUtils.parsePolicy(rawPolicy, name, LifecyclePolicyConfig.DEFAULT_X_CONTENT_REGISTRY, XContentType.YAML);
        }
        catch (IOException e) {
            throw new ElasticsearchException(e);
        }
    }

    @Override
    protected boolean applyRolloverAfterTemplateV2Update() {
        return true;
    }
}

