/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.action.oidc;

import java.io.IOException;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.Nullable;

public final class OpenIdConnectLogoutRequest
extends ActionRequest {
    private String token;
    @Nullable
    private String refreshToken;

    public OpenIdConnectLogoutRequest() {
    }

    public OpenIdConnectLogoutRequest(StreamInput in) throws IOException {
        super(in);
        this.token = in.readString();
        this.refreshToken = in.readOptionalString();
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (Strings.isNullOrEmpty(this.token)) {
            validationException = ValidateActions.addValidationError("token is missing", validationException);
        }
        return validationException;
    }

    public String getToken() {
        return this.token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public String getRefreshToken() {
        return this.refreshToken;
    }

    public void setRefreshToken(String refreshToken) {
        this.refreshToken = refreshToken;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.token);
        out.writeOptionalString(this.refreshToken);
    }
}

